/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.category.repository.query;

import com.cyberway.mp.bc.common.api.OrderPageParam;
import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.dal.annotation.Join;
import com.cyberway.mp.bc.dal.annotation.OrderBy;
import com.cyberway.mp.bc.dal.annotation.Predicate;
import com.cyberway.mp.bc.dal.annotation.query.Contains;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import com.cyberway.mp.flow.api.category.dto.FlowCategoryPageDto;

@Predicate(dynamic=true)
@Join(script="fc_flow_category c left join fc_flow_category p on c.parent_id=p.id")
public class FlowCategoryWithParentNameQuery {
    private static final OrderFragment DEFAULT_ORDER_FRAGMENT = new OrderFragment("c.last_modified_time", "DESC");
    private static final String FIELD_PARENT_NAME = "parentName";
    @Alias(name="c.id")
    @OrderBy(order=2)
    private Long id;
    @Contains
    @Alias(name="c.code_name")
    private String codeName;
    @Contains
    @Alias(name="c.name")
    private String name;
    @Alias(name="c.tenant_id")
    private Long tenantId;
    @OrderByField
    private OrderFragment orderFragment;
    @OrderBy(order=-1)
    @Alias(name="c.sort_order")
    private Integer sortOrder;

    public FlowCategoryWithParentNameQuery() {
    }

    public FlowCategoryWithParentNameQuery(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrderFragment getOrderFragment() {
        return this.orderFragment;
    }

    public void setOrderFragment(OrderFragment orderFragment) {
        this.orderFragment = orderFragment;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public static FlowCategoryWithParentNameQuery fromFlowCategoryPageDto(FlowCategoryPageDto dto) {
        FlowCategoryWithParentNameQuery query = new FlowCategoryWithParentNameQuery();
        query.setCodeName(dto.getCodeName());
        query.setName(dto.getName());
        query.setTenantId(dto.getTenantId());
        OrderFragment paramOrderFragment = OrderFragment.fromOrderPageParam((OrderPageParam)dto);
        if (paramOrderFragment == null) {
            query.setOrderFragment(DEFAULT_ORDER_FRAGMENT);
        } else {
            if (FIELD_PARENT_NAME.equals(paramOrderFragment.getFieldName())) {
                paramOrderFragment.setFieldName("p.name");
            } else {
                paramOrderFragment.setFieldName("c." + Strings.underscoreName((String)paramOrderFragment.getFieldName()));
            }
            query.setOrderFragment(paramOrderFragment);
        }
        return query;
    }

    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }
}

