/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.category.service;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.category.dto.FlowCategoryModifyBaseDto;
import com.cyberway.mp.flow.api.category.dto.FlowCategoryModifyDto;
import com.cyberway.mp.flow.api.category.dto.FlowCategoryPageDto;
import com.cyberway.mp.flow.api.category.dto.FlowCategoryTreePageDto;
import com.cyberway.mp.flow.api.category.vo.FlowCategoryListVo;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.domain.category.entity.FlowCategory;
import com.cyberway.mp.flow.domain.category.entity.FlowCategoryWithParentName;
import com.cyberway.mp.flow.domain.category.repository.FlowCategoryRepository;
import com.cyberway.mp.flow.domain.category.repository.query.FlowCategoryWithParentNameQuery;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class FlowCategoryService {
    private final FlowCategoryRepository flowCategoryRepository;

    public FlowCategoryService(FlowCategoryRepository flowCategoryRepository) {
        this.flowCategoryRepository = flowCategoryRepository;
    }

    public void createFlowCategory(FlowCategory flowCategory) {
        if (this.flowCategoryRepository.countByCodeName(flowCategory.getCodeName()) > 0L) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_CATEGORY_CODE_ALREADY_EXISTED);
        }
        if (!CodeUtils.isEmptyId(flowCategory.getParentId())) {
            FlowCategory parent = (FlowCategory)((Object)this.flowCategoryRepository.findOne(flowCategory.getParentId()));
            if (parent == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.PARENT_CATEGORY_NOT_EXISTED);
            }
            flowCategory.setAllParentId((String)StringUtils.defaultIfBlank((CharSequence)parent.getAllParentId(), (CharSequence)"|") + parent.getId() + "|");
        }
        this.flowCategoryRepository.save((Object)flowCategory);
    }

    public FlowCategory getFlowCategory(long id) {
        return (FlowCategory)((Object)this.flowCategoryRepository.findOne(id));
    }

    public FlowCategoryWithParentName getFlowCategoryWithParentName(long id) {
        List<FlowCategoryWithParentName> list = this.flowCategoryRepository.searchWithParentNameNoPage(new FlowCategoryWithParentNameQuery(id));
        return list.isEmpty() ? null : list.get(0);
    }

    public List<FlowCategory> batchGetFlowCategory(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.flowCategoryRepository.findByIdIn(ids);
    }

    public void modifyFlowCategory(FlowCategoryModifyDto dto) {
        FlowCategory flowCategory = (FlowCategory)((Object)this.flowCategoryRepository.findOne(dto.getId()));
        if (flowCategory == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_CATEGORY_ID_NOT_EXISTED);
        }
        String oldAllParentId = flowCategory.getAllParentId();
        flowCategory.update((FlowCategoryModifyBaseDto)dto);
        if (!CodeUtils.isEmptyId(flowCategory.getParentId())) {
            FlowCategory parent = (FlowCategory)((Object)this.flowCategoryRepository.findOne(flowCategory.getParentId()));
            if (parent == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.PARENT_CATEGORY_NOT_EXISTED);
            }
            flowCategory.setAllParentId((String)StringUtils.defaultIfBlank((CharSequence)parent.getAllParentId(), (CharSequence)"|") + parent.getId() + "|");
        } else {
            flowCategory.setAllParentId("");
        }
        this.flowCategoryRepository.updateById((Object)flowCategory, (Long)flowCategory.getId());
        if (!flowCategory.getAllParentId().equals(oldAllParentId)) {
            String oldPrefix = (String)StringUtils.defaultIfBlank((CharSequence)oldAllParentId, (CharSequence)"|") + flowCategory.getId() + "|";
            String newPrefix = (String)StringUtils.defaultIfBlank((CharSequence)flowCategory.getAllParentId(), (CharSequence)"|") + flowCategory.getId() + "|";
            this.flowCategoryRepository.listAllChildren(oldPrefix).forEach(child -> {
                child.setAllParentId(newPrefix + child.getAllParentId().substring(oldPrefix.length()));
                this.flowCategoryRepository.updateById(child, (Long)child.getId());
            });
        }
    }

    public void batchDeleteFlowCategory(Collection<Long> ids) {
        this.flowCategoryRepository.deleteByIdIn(ids);
    }

    public List<FlowCategoryWithParentName> pageQueryFlowCategory(FlowCategoryPageDto dto) {
        return this.flowCategoryRepository.searchWithParentName(FlowCategoryWithParentNameQuery.fromFlowCategoryPageDto(dto), (PageParam)dto);
    }

    public long countFlowCategory(FlowCategoryWithParentNameQuery query) {
        return this.flowCategoryRepository.countFlowCategory(query);
    }

    public List<Long> listAllChildrenId(FlowCategory flowCategory) {
        String allParentIdPrefix = (String)StringUtils.defaultIfBlank((CharSequence)flowCategory.getAllParentId(), (CharSequence)"|") + flowCategory.getId() + "|";
        return this.flowCategoryRepository.listAllChildrenId(allParentIdPrefix);
    }

    public long countByCodeName(String codeName) {
        return this.flowCategoryRepository.countByCodeName(codeName);
    }

    public List<FlowCategory> findByCodeNameIn(List<String> codeNames) {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        if (null == tenantId) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.LOGIN_TENANT_ID_NOT_FOUND);
        }
        return this.flowCategoryRepository.findByCodeNameInAndTenantId(codeNames, tenantId);
    }

    public FlowCategory getByCodeName(String codeName) {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        if (null == tenantId) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.LOGIN_TENANT_ID_NOT_FOUND);
        }
        List<FlowCategory> list = this.flowCategoryRepository.findByCodeNameAndTenantId(codeName, tenantId);
        return list.isEmpty() ? null : list.get(0);
    }

    public List<FlowCategory> batchGetRelationFlowCategory(Collection<Long> ids) {
        ArrayList<FlowCategory> flowCategories = new ArrayList<FlowCategory>();
        if (io.seata.common.util.CollectionUtils.isEmpty(ids)) {
            return flowCategories;
        }
        List<FlowCategory> childFlowCategories = this.flowCategoryRepository.findByIdIn(ids);
        if (CollectionUtils.isEmpty(childFlowCategories)) {
            return flowCategories;
        }
        flowCategories.addAll(childFlowCategories);
        List<String> allParentIds = flowCategories.stream().map(FlowCategory::getAllParentId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(allParentIds)) {
            return flowCategories;
        }
        HashSet<Long> idSets = new HashSet<Long>(ids);
        allParentIds.forEach(allParentId -> {
            String[] parentIdAttr;
            for (String parentId : parentIdAttr = allParentId.split("\\|")) {
                if (!StringUtils.isNotBlank((CharSequence)parentId)) continue;
                idSets.add(Long.parseLong(parentId));
            }
        });
        return this.flowCategoryRepository.findByIdIn(idSets);
    }

    public List<FlowCategory> listAll() {
        return this.flowCategoryRepository.findAll();
    }

    public void updateFlowCategory(FlowCategory flowCategory) {
        this.flowCategoryRepository.updateById((Object)flowCategory, (Long)flowCategory.getId());
    }

    public List<FlowCategoryListVo> listFlowCategoryTree(FlowCategoryTreePageDto dto) {
        return this.flowCategoryRepository.listFlowCategoryTree(dto);
    }

    public long countFlowCategoryTree(FlowCategoryTreePageDto dto) {
        return this.flowCategoryRepository.calFlowCategoryTree(dto);
    }
}

