/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.communicate.entity;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import com.cyberway.mp.flow.api.communicate.dto.FlowCommunicateAddDto;
import com.cyberway.mp.flow.api.communicate.vo.FlowCommunicateTreeVo;
import com.cyberway.mp.flow.api.communicate.vo.FlowCommunicateVo;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.dto.AttachmentInfo;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.node.entity.FlowNode;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

@Table(name="fc_flow_communicate")
public class FlowCommunicate
extends BusinessEntityWithAppInstance {
    private Long flowInstanceId;
    private Long flowNodeId;
    private Long flowTaskId;
    private Long replyId;
    private String nodeKey;
    private String contentText;
    private String attachmentInfo;

    public Long getFlowInstanceId() {
        return this.flowInstanceId;
    }

    public void setFlowInstanceId(Long flowInstanceId) {
        this.flowInstanceId = flowInstanceId;
    }

    public Long getFlowNodeId() {
        return this.flowNodeId;
    }

    public void setFlowNodeId(Long flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public Long getFlowTaskId() {
        return this.flowTaskId;
    }

    public void setFlowTaskId(Long flowTaskId) {
        this.flowTaskId = flowTaskId;
    }

    public Long getReplyId() {
        return this.replyId;
    }

    public void setReplyId(Long replyId) {
        this.replyId = replyId;
    }

    public String getNodeKey() {
        return this.nodeKey;
    }

    public void setNodeKey(String nodeKey) {
        this.nodeKey = nodeKey;
    }

    public String getContentText() {
        return this.contentText;
    }

    public void setContentText(String contentText) {
        this.contentText = contentText;
    }

    public String getAttachmentInfo() {
        return this.attachmentInfo;
    }

    public void setAttachmentInfo(String attachmentInfo) {
        this.attachmentInfo = attachmentInfo;
    }

    public static FlowCommunicate fromFlowInstance(FlowInstance flowInstance, FlowCommunicateAddDto dto) {
        FlowCommunicate flowCommunicate = new FlowCommunicate();
        FlowCommunicate.initFlowCommunicate(flowCommunicate, flowInstance, dto);
        flowCommunicate.setFlowInstanceId((Long)flowInstance.getId());
        flowCommunicate.setFlowNodeId(FlowConstant.EMPTY_ID_VALUE);
        flowCommunicate.setFlowTaskId(FlowConstant.EMPTY_ID_VALUE);
        flowCommunicate.setReplyId(FlowConstant.EMPTY_ID_VALUE);
        flowCommunicate.setNodeKey("");
        return flowCommunicate;
    }

    public static FlowCommunicate fromFlowNode(FlowNode flowNode, FlowCommunicateAddDto dto) {
        FlowCommunicate flowCommunicate = new FlowCommunicate();
        FlowCommunicate.initFlowCommunicate(flowCommunicate, flowNode, dto);
        flowCommunicate.setFlowInstanceId(flowNode.getFlowInstanceId());
        flowCommunicate.setFlowNodeId((Long)flowNode.getId());
        flowCommunicate.setFlowTaskId(FlowConstant.EMPTY_ID_VALUE);
        flowCommunicate.setReplyId(FlowConstant.EMPTY_ID_VALUE);
        flowCommunicate.setNodeKey(flowNode.getNodeKey());
        return flowCommunicate;
    }

    public static FlowCommunicate fromFlowTask(FlowTask flowTask, FlowCommunicateAddDto dto) {
        FlowCommunicate flowCommunicate = new FlowCommunicate();
        FlowCommunicate.initFlowCommunicate(flowCommunicate, flowTask, dto);
        flowCommunicate.setFlowInstanceId(flowTask.getFlowInstanceId());
        flowCommunicate.setFlowNodeId(flowTask.getFlowNodeId());
        flowCommunicate.setFlowTaskId((Long)flowTask.getId());
        flowCommunicate.setReplyId(FlowConstant.EMPTY_ID_VALUE);
        flowCommunicate.setNodeKey(flowTask.getNodeKey());
        return flowCommunicate;
    }

    public static FlowCommunicate fromReply(FlowCommunicate reply, FlowCommunicateAddDto dto) {
        FlowCommunicate flowCommunicate = new FlowCommunicate();
        FlowCommunicate.initFlowCommunicate(flowCommunicate, reply, dto);
        flowCommunicate.setFlowInstanceId(reply.getFlowInstanceId());
        flowCommunicate.setFlowNodeId(reply.getFlowNodeId());
        flowCommunicate.setFlowTaskId(reply.getFlowTaskId());
        flowCommunicate.setReplyId((Long)reply.getId());
        flowCommunicate.setNodeKey(reply.getNodeKey());
        return flowCommunicate;
    }

    private static void initFlowCommunicate(FlowCommunicate flowCommunicate, BusinessEntityWithAppInstance entity, FlowCommunicateAddDto dto) {
        flowCommunicate.setTenantId(entity.getTenantId());
        flowCommunicate.setBusinessZoneId(entity.getBusinessZoneId());
        flowCommunicate.setAppInstanceId(entity.getAppInstanceId());
        flowCommunicate.setContentText(dto.getContentText());
        flowCommunicate.setAttachmentInfo(dto.getAttachmentInfo() == null ? "" : JSON.toJSONString((Object)dto.getAttachmentInfo()));
    }

    public FlowCommunicateVo toFlowCommunicateVo() {
        FlowCommunicateVo vo = new FlowCommunicateVo();
        this.initFlowCommunicateVo(vo);
        return vo;
    }

    public FlowCommunicateTreeVo toFlowCommunicateTreeVo() {
        FlowCommunicateTreeVo vo = new FlowCommunicateTreeVo();
        this.initFlowCommunicateVo((FlowCommunicateVo)vo);
        vo.setReplies(new ArrayList());
        return vo;
    }

    private void initFlowCommunicateVo(FlowCommunicateVo vo) {
        vo.setId((Long)this.getId());
        vo.setFlowInstanceId(this.getFlowInstanceId());
        vo.setFlowNodeId(CodeUtils.formatNullableId(this.getFlowNodeId()));
        vo.setFlowTaskId(CodeUtils.formatNullableId(this.getFlowTaskId()));
        vo.setReplyId(CodeUtils.formatNullableId(this.getReplyId()));
        vo.setNodeKey(this.getNodeKey());
        vo.setContentText(this.getContentText());
        vo.setAttachmentInfo(StringUtils.isBlank((CharSequence)this.attachmentInfo) ? Collections.emptyList() : JSON.parseArray((String)this.attachmentInfo, AttachmentInfo.class));
        vo.setCreatedTime(this.getCreatedTime());
    }
}

