/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.communicate.repository.query;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.dal.annotation.Predicate;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.communicate.dto.FlowCommunicateListDto;
import com.cyberway.mp.flow.api.communicate.dto.FlowCommunicateTreeDto;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.infra.util.CodeUtils;

@Predicate(dynamic=true)
public class FlowCommunicateQuery {
    private static final OrderFragment DEFAULT_ORDER_FRAGMENT = new OrderFragment("created_time", "ASC");
    private Long flowInstanceId;
    private Long flowNodeId;
    private Long flowTaskId;
    private Long replyId;
    @OrderByField
    private OrderFragment orderFragment = DEFAULT_ORDER_FRAGMENT;

    public Long getFlowInstanceId() {
        return this.flowInstanceId;
    }

    public void setFlowInstanceId(Long flowInstanceId) {
        this.flowInstanceId = flowInstanceId;
    }

    public Long getFlowNodeId() {
        return this.flowNodeId;
    }

    public void setFlowNodeId(Long flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public Long getFlowTaskId() {
        return this.flowTaskId;
    }

    public void setFlowTaskId(Long flowTaskId) {
        this.flowTaskId = flowTaskId;
    }

    public Long getReplyId() {
        return this.replyId;
    }

    public void setReplyId(Long replyId) {
        this.replyId = replyId;
    }

    public OrderFragment getOrderFragment() {
        return this.orderFragment;
    }

    public void setOrderFragment(OrderFragment orderFragment) {
        this.orderFragment = orderFragment;
    }

    public static FlowCommunicateQuery fromFlowCommunicateListDto(FlowCommunicateListDto dto) {
        FlowCommunicateQuery query = new FlowCommunicateQuery();
        query.setReplyId(dto.getReplyId());
        FlowCommunicateQuery.initFlowCommunicateQuery(query, (FlowCommunicateTreeDto)dto);
        return query;
    }

    public static FlowCommunicateQuery fromFlowCommunicateTreeDto(FlowCommunicateTreeDto dto) {
        FlowCommunicateQuery query = new FlowCommunicateQuery();
        FlowCommunicateQuery.initFlowCommunicateQuery(query, dto);
        return query;
    }

    private static void initFlowCommunicateQuery(FlowCommunicateQuery query, FlowCommunicateTreeDto dto) {
        boolean notContainSub;
        boolean bl = notContainSub = Boolean.FALSE.equals(dto.getContainSub()) && (dto.getFlowInstanceId() != null || dto.getFlowNodeId() != null);
        if (dto.getFlowTaskId() != null) {
            query.setFlowTaskId(dto.getFlowTaskId());
        } else if (notContainSub) {
            query.setFlowTaskId(FlowConstant.EMPTY_ID_VALUE);
        }
        if (dto.getFlowNodeId() != null) {
            query.setFlowNodeId(dto.getFlowNodeId());
        } else if (notContainSub) {
            query.setFlowNodeId(FlowConstant.EMPTY_ID_VALUE);
        }
        query.setFlowInstanceId(dto.getFlowInstanceId());
        if (CodeUtils.isEmptyId(query.getReplyId()) && query.getFlowInstanceId() == null && query.getFlowNodeId() == null && query.getFlowTaskId() == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.ALL_QUERY_ID_EMPTY);
        }
    }
}

