/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.condition.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixValueAddDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixValueBatchAddItemDto;
import com.cyberway.mp.flow.api.condition.dto.ConditionMatrixValueModifyDto;
import com.cyberway.mp.flow.api.condition.vo.ConditionMatrixValueVo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@Table(name="fc_condition_matrix_value")
public class ConditionMatrixValue
extends BusinessEntityWithAppInstance {
    private Long matrixId;
    private Long userId;
    private String userName;
    private String ruleValues;
    private Boolean mainValue;
    private Long mainValueId;
    private Integer sortNo;

    public Long getMatrixId() {
        return this.matrixId;
    }

    public void setMatrixId(Long matrixId) {
        this.matrixId = matrixId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRuleValues() {
        return this.ruleValues;
    }

    public void setRuleValues(String ruleValues) {
        this.ruleValues = ruleValues;
    }

    public Boolean getMainValue() {
        return this.mainValue;
    }

    public void setMainValue(Boolean mainValue) {
        this.mainValue = mainValue;
    }

    public Long getMainValueId() {
        return this.mainValueId;
    }

    public void setMainValueId(Long mainValueId) {
        this.mainValueId = mainValueId;
    }

    public Integer getSortNo() {
        return this.sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public ConditionMatrixValueVo toVo(Map<Long, List<IdNameDto>> userMap) {
        ConditionMatrixValueVo vo = new ConditionMatrixValueVo();
        vo.setId((Long)this.getId());
        vo.setMatrixId(this.matrixId);
        vo.setRuleValues((Map)JSON.parseObject((String)this.getRuleValues(), (TypeReference)new TypeReference<Map<String, String[]>>(){}, (Feature[])new Feature[0]));
        vo.setUsers(userMap.get(this.getId()));
        return vo;
    }

    public static List<ConditionMatrixValue> fromAddDto(ConditionMatrixValueAddDto dto, long mainValueId) {
        return ConditionMatrixValue.buildConditionMatrixValues(dto.getUsers(), dto.getRuleValues(), dto.getMatrixId(), mainValueId);
    }

    public static List<ConditionMatrixValue> fromItemAddDto(ConditionMatrixValueBatchAddItemDto dto, long matrixId, long mainValueId) {
        return ConditionMatrixValue.buildConditionMatrixValues(dto.getUsers(), dto.getRuleValues(), matrixId, mainValueId);
    }

    public static List<ConditionMatrixValue> fromModifyDto(ConditionMatrixValueModifyDto dto, ConditionMatrixValue oldMainValue) {
        List<ConditionMatrixValue> list = ConditionMatrixValue.buildConditionMatrixValues(dto.getUsers(), dto.getRuleValues(), oldMainValue.getMatrixId(), dto.getId());
        ConditionMatrixValue newMainValue = list.get(0);
        newMainValue.setCreatedTime(oldMainValue.getCreatedTime());
        newMainValue.setCreatedUserId(oldMainValue.getCreatedUserId());
        newMainValue.setCreatedUserName(oldMainValue.getCreatedUserName());
        return list;
    }

    private static List<ConditionMatrixValue> buildConditionMatrixValues(List<IdNameDto> users, Map<String, String[]> ruleValues, long matrixId, long mainValueId) {
        String values = JSON.toJSONString(ruleValues);
        AtomicInteger sortNo = new AtomicInteger();
        HashSet userIdSet = new HashSet();
        List<ConditionMatrixValue> list = users.stream().map(u -> {
            if (userIdSet.contains(u.getId())) {
                return null;
            }
            userIdSet.add(u.getId());
            ConditionMatrixValue value = new ConditionMatrixValue();
            value.setMatrixId(matrixId);
            value.setUserId(u.getId());
            value.setUserName(u.getName());
            value.setRuleValues(values);
            value.setMainValue(false);
            value.setSortNo(sortNo.getAndIncrement());
            value.setMainValueId(mainValueId);
            return value;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        ConditionMatrixValue mainValue = (ConditionMatrixValue)((Object)list.get(0));
        mainValue.setMainValue(true);
        mainValue.setId(Long.valueOf(mainValueId));
        return list;
    }
}

