/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.condition.service;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.condition.enums.RuleComplexType;
import com.cyberway.mp.flow.api.condition.enums.RuleConditionType;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.domain.condition.entity.ConditionMatrix;
import com.cyberway.mp.flow.domain.condition.entity.ConditionMatrixRule;
import com.cyberway.mp.flow.domain.condition.entity.ConditionMatrixValue;
import com.cyberway.mp.flow.domain.condition.repository.ConditionMatrixRepository;
import com.cyberway.mp.flow.domain.condition.repository.ConditionMatrixRuleRepository;
import com.cyberway.mp.flow.domain.condition.repository.ConditionMatrixValueRepository;
import com.cyberway.mp.flow.domain.condition.repository.query.ConditionMatrixMainValueQuery;
import com.cyberway.mp.flow.domain.condition.repository.query.ConditionMatrixQuery;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionMatrixService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConditionMatrixRepository repository;
    private final ConditionMatrixRuleRepository ruleRepository;
    private final ConditionMatrixValueRepository valueRepository;

    public ConditionMatrixService(ConditionMatrixRepository repository, ConditionMatrixRuleRepository ruleRepository, ConditionMatrixValueRepository valueRepository) {
        this.repository = repository;
        this.ruleRepository = ruleRepository;
        this.valueRepository = valueRepository;
    }

    public void saveConditionMatrix(ConditionMatrix conditionMatrix, List<ConditionMatrixRule> rules) {
        this.repository.save((Object)conditionMatrix);
        rules.forEach(r -> r.setMatrixId((Long)conditionMatrix.getId()));
        this.ruleRepository.batchInsert(rules);
    }

    public void updateConditionMatrix(ConditionMatrix conditionMatrix) {
        this.repository.updateById((Object)conditionMatrix, (Long)conditionMatrix.getId());
    }

    public void updateConditionMatrix(ConditionMatrix conditionMatrix, List<ConditionMatrixRule> rules) {
        this.repository.updateById((Object)conditionMatrix, (Long)conditionMatrix.getId());
        this.ruleRepository.deleteByMatrixId((Long)conditionMatrix.getId());
        rules.forEach(r -> r.setMatrixId((Long)conditionMatrix.getId()));
        this.ruleRepository.batchInsert(rules);
    }

    public void deleteConditionMatrix(long id) {
        ConditionMatrix conditionMatrix = this.getConditionMatrix(id);
        if (conditionMatrix == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_ID_NOT_EXISTED);
        }
        if (Boolean.TRUE.equals(conditionMatrix.getAlreadyUse())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.CONDITION_MATRIX_ALREADY_USE);
        }
        this.repository.delete(id);
        this.ruleRepository.deleteByMatrixId(id);
        this.valueRepository.deleteByMatrixId(id);
    }

    public boolean checkMatrixCodeExisted(String matrixCode, Long excludeId) {
        if (excludeId != null) {
            return this.repository.countByMatrixCodeAndIdNot(matrixCode, excludeId) > 0L;
        }
        return this.repository.countByMatrixCode(matrixCode) > 0L;
    }

    public ConditionMatrix getConditionMatrix(long id) {
        return (ConditionMatrix)((Object)this.repository.findOne(id));
    }

    public List<ConditionMatrix> batchGetConditionMatrix(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.repository.findByIdIn(ids);
    }

    public ConditionMatrix getConditionMatrixByCode(String matrixCode) {
        return this.repository.findByMatrixCode(matrixCode);
    }

    public long countConditionMatrix(ConditionMatrixQuery query) {
        return this.repository.countConditionMatrix(query);
    }

    public List<ConditionMatrix> pageConditionMatrix(ConditionMatrixQuery query, PageParam pageParam) {
        return this.repository.searchConditionMatrix(query, pageParam);
    }

    public List<ConditionMatrixRule> listConditionMatrixRules(long matrixId) {
        return this.ruleRepository.findByMatrixIdOrderBySortNoAsc(matrixId);
    }

    public void addConditionMatrixValue(ConditionMatrixValue conditionMatrixValue) {
        this.valueRepository.save((Object)conditionMatrixValue);
    }

    public void batchAddConditionMatrixValue(List<ConditionMatrixValue> conditionMatrixValues) {
        if (conditionMatrixValues.isEmpty()) {
            return;
        }
        this.valueRepository.batchInsert(conditionMatrixValues);
    }

    public void updateConditionMatrixValue(ConditionMatrixValue conditionMatrixValue) {
        this.valueRepository.updateById((Object)conditionMatrixValue, (Long)conditionMatrixValue.getId());
    }

    public void cleanConditionMatrixValueByMainValue(long mainValueId) {
        this.valueRepository.deleteByMainValueId(mainValueId);
    }

    public void cleanConditionMatrixValueByMainValues(Collection<Long> mainValueIds) {
        if (mainValueIds.isEmpty()) {
            return;
        }
        this.valueRepository.deleteByMainValueIdIn(mainValueIds);
    }

    public void cleanConditionMatrixValueByMatrix(long matrixId) {
        this.valueRepository.deleteByMatrixId(matrixId);
    }

    public ConditionMatrixValue getConditionMatrixValue(long id) {
        return (ConditionMatrixValue)((Object)this.valueRepository.findOne(id));
    }

    public boolean alreadyHasValue(long matrixId) {
        ConditionMatrixMainValueQuery query = new ConditionMatrixMainValueQuery();
        query.setMatrixId(matrixId);
        query.setMainValue(null);
        return this.valueRepository.countMainValue(query) > 0L;
    }

    public long countConditionMatrixMainValue(ConditionMatrixMainValueQuery query) {
        return this.valueRepository.countMainValue(query);
    }

    public List<ConditionMatrixValue> pageConditionMatrixMainValue(ConditionMatrixMainValueQuery query, PageParam pageParam) {
        return this.valueRepository.searchMainValue(query, pageParam);
    }

    public List<ConditionMatrixValue> batchGetValue(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.valueRepository.findByIdIn(ids);
    }

    public List<ConditionMatrixValue> batchGetValueByMainValue(Collection<Long> mainValueIds) {
        if (mainValueIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.valueRepository.findByMainValueIdInOrderBySortNoAsc(mainValueIds);
    }

    public List<Long> filterUser(Long matrixId, Map<String, Object> ruleValueMap) {
        return this.filterUser(null, matrixId, ruleValueMap, false);
    }

    public List<Long> filterUser(Collection<Long> userIds, Long matrixId, Map<String, Object> ruleValueMap) {
        if (userIds == null || userIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.filterUser(userIds, matrixId, ruleValueMap, true);
    }

    private List<Long> filterUser(Collection<Long> userIds, Long matrixId, Map<String, Object> ruleValueMap, boolean filterUser) {
        AbstractCollection result;
        List<ConditionMatrixValue> values;
        ConditionMatrix matrix = (ConditionMatrix)((Object)this.repository.findOne(matrixId));
        List<ConditionMatrixRule> rules = this.ruleRepository.findByMatrixIdOrderBySortNoAsc(matrixId);
        if (filterUser) {
            values = this.valueRepository.findByMatrixIdAndUserIdIn(matrixId, userIds);
            result = new HashSet();
        } else {
            values = this.valueRepository.findByMatrixId(matrixId);
            result = new ArrayList();
        }
        HashMap calResultMap = MapUtil.newHashMap((int)values.size());
        Map<String, Object> convertedRuleValueMap = this.convertRuleValueMap(rules, ruleValueMap);
        for (ConditionMatrixValue value : values) {
            boolean calResult = calResultMap.computeIfAbsent(value.getMainValueId(), k -> this.calCondition(rules, value, matrix.getComplexType(), convertedRuleValueMap));
            if (!calResult) continue;
            result.add(value.getUserId());
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        if (filterUser) {
            ArrayList<Long> sortedResult = new ArrayList<Long>();
            userIds.stream().filter(result::contains).forEach(sortedResult::add);
            return sortedResult;
        }
        return (List)((Object)result);
    }

    private Map<String, Object> convertRuleValueMap(List<ConditionMatrixRule> rules, Map<String, Object> ruleValueMap) {
        HashMap convertedRuleValueMap = MapUtil.newHashMap((int)ruleValueMap.size());
        for (ConditionMatrixRule rule : rules) {
            Object sourceValue = ruleValueMap.get(rule.getRuleCode());
            if (sourceValue == null) {
                convertedRuleValueMap.put(rule.getRuleCode(), null);
                continue;
            }
            switch (rule.getValueType()) {
                case NUMBER: {
                    convertedRuleValueMap.put(rule.getRuleCode(), Convert.toBigDecimal((Object)sourceValue.toString()));
                    break;
                }
                case STRING: {
                    convertedRuleValueMap.put(rule.getRuleCode(), sourceValue.toString());
                    break;
                }
                case DATETIME: {
                    convertedRuleValueMap.put(rule.getRuleCode(), Convert.toDate((Object)sourceValue));
                    break;
                }
            }
        }
        return convertedRuleValueMap;
    }

    private boolean calCondition(List<ConditionMatrixRule> rules, ConditionMatrixValue value, RuleComplexType complexType, Map<String, Object> ruleValueMap) {
        Map values = (Map)JSON.parseObject((String)value.getRuleValues(), (TypeReference)new TypeReference<Map<String, String[]>>(){}, (Feature[])new Feature[0]);
        for (ConditionMatrixRule rule : rules) {
            boolean calResult = this.calCondition(rule, (String[])values.get(rule.getRuleCode()), ruleValueMap.get(rule.getRuleCode()));
            if (RuleComplexType.OR.equals((Object)complexType) && calResult) {
                return true;
            }
            if (!RuleComplexType.AND.equals((Object)complexType) || calResult) continue;
            return false;
        }
        return RuleComplexType.AND.equals((Object)complexType);
    }

    private boolean calCondition(ConditionMatrixRule rule, String[] values, Object valueObj) {
        if (values == null) {
            return false;
        }
        if (valueObj == null) {
            return RuleConditionType.NE.equals((Object)rule.getConditionType()) || RuleConditionType.NOT_IN.equals((Object)rule.getConditionType());
        }
        switch (rule.getValueType()) {
            case DATETIME: {
                return this.calDateCondition(rule.getConditionType(), Boolean.TRUE.equals(rule.getIncludeLeft()), Boolean.TRUE.equals(rule.getIncludeRight()), values, (Date)valueObj);
            }
            case NUMBER: {
                return this.calNumberCondition(rule.getConditionType(), Boolean.TRUE.equals(rule.getIncludeLeft()), Boolean.TRUE.equals(rule.getIncludeRight()), values, (BigDecimal)valueObj);
            }
            case STRING: {
                return this.calStringCondition(rule.getConditionType(), Boolean.TRUE.equals(rule.getIncludeLeft()), Boolean.TRUE.equals(rule.getIncludeRight()), values, (String)valueObj);
            }
        }
        return false;
    }

    private boolean calDateCondition(RuleConditionType conditionType, boolean includeLeft, boolean includeRight, String[] values, Date valueObj) {
        Date[] convertedValues = new Date[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                convertedValues[i] = DatePattern.UTC_MS_WITH_XXX_OFFSET_FORMAT.parse(values[i]);
                continue;
            }
            catch (ParseException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        switch (conditionType) {
            case EQ: {
                return valueObj.equals(convertedValues[0]);
            }
            case NE: {
                return !valueObj.equals(convertedValues[0]);
            }
            case GE: {
                return !valueObj.before(convertedValues[0]);
            }
            case GT: {
                return valueObj.after(convertedValues[0]);
            }
            case LE: {
                return !valueObj.after(convertedValues[0]);
            }
            case LT: {
                return valueObj.before(convertedValues[0]);
            }
            case BETWEEN: {
                return this.betweenDate(valueObj, convertedValues[0], convertedValues[1], includeLeft, includeRight);
            }
            case IN: {
                return Arrays.asList(convertedValues).contains(valueObj);
            }
            case NOT_IN: {
                return !Arrays.asList(convertedValues).contains(valueObj);
            }
        }
        return false;
    }

    private boolean betweenDate(Date valueObj, Date leftValue, Date rightValue, boolean includeLeft, boolean includeRight) {
        if (includeLeft && includeRight) {
            return !valueObj.before(leftValue) && !valueObj.after(rightValue);
        }
        if (includeLeft) {
            return !valueObj.before(leftValue) && valueObj.before(rightValue);
        }
        if (includeRight) {
            return valueObj.after(leftValue) && !valueObj.after(rightValue);
        }
        return valueObj.after(leftValue) && valueObj.before(rightValue);
    }

    private boolean calNumberCondition(RuleConditionType conditionType, boolean includeLeft, boolean includeRight, String[] values, BigDecimal valueObj) {
        BigDecimal[] convertedValues = new BigDecimal[values.length];
        for (int i = 0; i < values.length; ++i) {
            convertedValues[i] = new BigDecimal(values[i]);
        }
        switch (conditionType) {
            case EQ: {
                return valueObj.compareTo(convertedValues[0]) == 0;
            }
            case NE: {
                return valueObj.compareTo(convertedValues[0]) != 0;
            }
            case GE: {
                return valueObj.compareTo(convertedValues[0]) > -1;
            }
            case GT: {
                return valueObj.compareTo(convertedValues[0]) > 0;
            }
            case LE: {
                return valueObj.compareTo(convertedValues[0]) < 1;
            }
            case LT: {
                return valueObj.compareTo(convertedValues[0]) < 0;
            }
            case BETWEEN: {
                boolean reverse = convertedValues[0].compareTo(convertedValues[1]) > 0;
                BigDecimal leftValue = reverse ? convertedValues[1] : convertedValues[0];
                BigDecimal rightValue = reverse ? convertedValues[0] : convertedValues[1];
                return this.betweenComparable(valueObj, leftValue, rightValue, includeLeft, includeRight);
            }
            case IN: {
                return Arrays.asList(convertedValues).contains(valueObj);
            }
            case NOT_IN: {
                return !Arrays.asList(convertedValues).contains(valueObj);
            }
        }
        return false;
    }

    private <T> boolean betweenComparable(Comparable<T> valueObj, T leftValue, T rightValue, boolean includeLeft, boolean includeRight) {
        if (includeLeft && includeRight) {
            return valueObj.compareTo(leftValue) > -1 && valueObj.compareTo(rightValue) < 1;
        }
        if (includeLeft) {
            return valueObj.compareTo(leftValue) > -1 && valueObj.compareTo(rightValue) < 0;
        }
        if (includeRight) {
            return valueObj.compareTo(leftValue) > 0 && valueObj.compareTo(rightValue) < 1;
        }
        return valueObj.compareTo(leftValue) > 0 && valueObj.compareTo(rightValue) < 0;
    }

    private boolean calStringCondition(RuleConditionType conditionType, boolean includeLeft, boolean includeRight, String[] values, String valueObj) {
        switch (conditionType) {
            case EQ: {
                return valueObj.equals(values[0]);
            }
            case NE: {
                return !valueObj.equals(values[0]);
            }
            case GE: {
                return valueObj.compareTo(values[0]) > -1;
            }
            case GT: {
                return valueObj.compareTo(values[0]) > 0;
            }
            case LE: {
                return valueObj.compareTo(values[0]) < 1;
            }
            case LT: {
                return valueObj.compareTo(values[0]) < 0;
            }
            case BETWEEN: {
                boolean reverse = values[0].compareTo(values[1]) > 0;
                String leftValue = reverse ? values[1] : values[0];
                String rightValue = reverse ? values[0] : values[1];
                return this.betweenComparable((Comparable)((Object)valueObj), (Object)leftValue, (Object)rightValue, includeLeft, includeRight);
            }
            case IN: {
                return Arrays.asList(values).contains(valueObj);
            }
            case NOT_IN: {
                return !Arrays.asList(values).contains(valueObj);
            }
        }
        return false;
    }

    public void fixValue(Long matrixId, Set<String> needCleanRuleCodes) {
        List<ConditionMatrixValue> values = this.valueRepository.findByMatrixId(matrixId);
        values.forEach(value -> {
            Map valueMap = (Map)JSON.parseObject((String)value.getRuleValues(), (TypeReference)new TypeReference<Map<String, String[]>>(){}, (Feature[])new Feature[0]);
            int size = valueMap.size();
            needCleanRuleCodes.forEach(valueMap::remove);
            if (valueMap.size() != size) {
                value.setRuleValues(JSON.toJSONString((Object)valueMap));
                this.valueRepository.updateById(value, (Long)value.getId());
            }
        });
    }

    public void markUsed(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        this.repository.markUsed(ids);
    }
}

