/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.delegation.entity;

import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRuleCreateDto;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRuleModifyBaseDto;
import com.cyberway.mp.flow.api.delegation.enums.DelegationRuleStatus;
import com.cyberway.mp.flow.api.delegation.vo.DelegationRuleInfoVo;
import com.cyberway.mp.flow.api.delegation.vo.DelegationRuleListVo;
import com.cyberway.mp.flow.domain.delegation.entity.DelegationRuleItem;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Table(name="fc_delegation_rule")
public class DelegationRule
extends BusinessEntityWithAppInstance {
    private Long ownerUserId;
    private String ownerUserName;
    private Long delegationUserId;
    private String delegationUserName;
    private Date startTime;
    private Date endTime;
    private Boolean delegateAll;
    private String projectNames;
    private Boolean startHandled;
    private Boolean endHandled;
    private DelegationRuleStatus status;
    private String description;
    private String invalidNoticeCode;

    public Long getOwnerUserId() {
        return this.ownerUserId;
    }

    public void setOwnerUserId(Long ownerUserId) {
        this.ownerUserId = ownerUserId;
    }

    public String getOwnerUserName() {
        return this.ownerUserName;
    }

    public void setOwnerUserName(String ownerUserName) {
        this.ownerUserName = ownerUserName;
    }

    public Long getDelegationUserId() {
        return this.delegationUserId;
    }

    public void setDelegationUserId(Long delegationUserId) {
        this.delegationUserId = delegationUserId;
    }

    public String getDelegationUserName() {
        return this.delegationUserName;
    }

    public void setDelegationUserName(String delegationUserName) {
        this.delegationUserName = delegationUserName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Boolean getDelegateAll() {
        return this.delegateAll;
    }

    public void setDelegateAll(Boolean delegateAll) {
        this.delegateAll = delegateAll;
    }

    public String getProjectNames() {
        return this.projectNames;
    }

    public void setProjectNames(String projectNames) {
        this.projectNames = projectNames;
    }

    public Boolean getStartHandled() {
        return this.startHandled;
    }

    public void setStartHandled(Boolean startHandled) {
        this.startHandled = startHandled;
    }

    public Boolean getEndHandled() {
        return this.endHandled;
    }

    public void setEndHandled(Boolean endHandled) {
        this.endHandled = endHandled;
    }

    public DelegationRuleStatus getStatus() {
        return this.status;
    }

    public void setStatus(DelegationRuleStatus status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInvalidNoticeCode() {
        return this.invalidNoticeCode;
    }

    public void setInvalidNoticeCode(String invalidNoticeCode) {
        this.invalidNoticeCode = invalidNoticeCode;
    }

    public static DelegationRule fromDelegationRuleCreateDto(DelegationRuleCreateDto dto) {
        DelegationRule delegationRule = new DelegationRule();
        delegationRule.setOwnerUserId(dto.getOwnerUserId());
        delegationRule.setOwnerUserName(dto.getOwnerUserName());
        delegationRule.setDelegationUserId(dto.getDelegationUserId());
        delegationRule.setDelegationUserName(dto.getDelegationUserName());
        delegationRule.setStartTime(CodeUtils.nullableMinTime(dto.getStartTime()));
        delegationRule.setEndTime(CodeUtils.nullableMaxTime(dto.getEndTime()));
        delegationRule.setDelegateAll(Boolean.TRUE.equals(dto.getDelegateAll()));
        if (Boolean.FALSE.equals(delegationRule.getDelegateAll()) && dto.getProjects() != null) {
            delegationRule.setProjectNames(dto.getProjects().stream().map(IdNameDto::getName).collect(Collectors.joining(",")));
        } else {
            delegationRule.setProjectNames("");
        }
        delegationRule.setStartHandled(false);
        delegationRule.setEndHandled(false);
        delegationRule.setStatus(DelegationRuleStatus.ENABLED);
        delegationRule.setDescription(dto.getDescription());
        delegationRule.setInvalidNoticeCode(dto.getInvalidNoticeCode());
        return delegationRule;
    }

    public void update(DelegationRuleModifyBaseDto dto) {
        this.setOwnerUserId(dto.getOwnerUserId());
        this.setOwnerUserName(dto.getOwnerUserName());
        this.setDelegationUserId(dto.getDelegationUserId());
        this.setDelegationUserName(dto.getDelegationUserName());
        this.setStartTime(CodeUtils.nullableMinTime(dto.getStartTime()));
        this.setEndTime(CodeUtils.nullableMaxTime(dto.getEndTime()));
        this.setDelegateAll(Boolean.TRUE.equals(dto.getDelegateAll()));
        if (Boolean.FALSE.equals(this.getDelegateAll()) && dto.getProjects() != null) {
            this.setProjectNames(dto.getProjects().stream().map(IdNameDto::getName).collect(Collectors.joining(",")));
        } else {
            this.setProjectNames("");
        }
        this.setDescription(StringUtils.defaultString((String)dto.getDescription()));
        this.setInvalidNoticeCode(StringUtils.defaultString((String)dto.getInvalidNoticeCode()));
    }

    public DelegationRuleListVo toDelegationRuleListVo() {
        DelegationRuleListVo vo = new DelegationRuleListVo();
        this.initDelegationRuleListVo(vo);
        return vo;
    }

    public DelegationRuleInfoVo toDelegationRuleInfoVo(Collection<DelegationRuleItem> items) {
        DelegationRuleInfoVo vo = new DelegationRuleInfoVo();
        this.initDelegationRuleListVo((DelegationRuleListVo)vo);
        vo.setProjects(items.stream().map(DelegationRuleItem::toIdNameVo).collect(Collectors.toList()));
        vo.setDescription(this.getDescription());
        vo.setDelegateAll(this.getDelegateAll());
        return vo;
    }

    private void initDelegationRuleListVo(DelegationRuleListVo vo) {
        vo.setId((Long)this.getId());
        vo.setOwnerUserId(this.getOwnerUserId());
        vo.setOwnerUserName(this.getOwnerUserName());
        vo.setDelegationUserId(this.getDelegationUserId());
        vo.setDelegationUserName(this.getDelegationUserName());
        vo.setStartTime(this.getStartTime());
        vo.setEndTime(this.getEndTime());
        vo.setProjectNames(this.getProjectNames());
        vo.setStatus(this.getStatus());
    }
}

