/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.delegation.repository.query;

import com.cyberway.mp.bc.common.api.OrderPageParam;
import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.dal.annotation.Predicate;
import com.cyberway.mp.bc.dal.annotation.query.Contains;
import com.cyberway.mp.bc.dal.annotation.query.GreaterThanEqual;
import com.cyberway.mp.bc.dal.annotation.query.LessThanEqual;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.dal.annotation.query.SubQuery;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRulePageDto;
import java.util.Date;

@Predicate(dynamic=true, tableName="fc_delegation_rule r")
public class DelegationRuleQuery {
    private static final OrderFragment DEFAULT_ORDER_FRAGMENT = new OrderFragment("r.created_time", "ASC");
    private Long ownerUserId;
    @Contains
    private String ownerUserName;
    private Long delegationUserId;
    @Contains
    private String delegationUserName;
    @Alias(name="start_time")
    @GreaterThanEqual
    private Date startTimeAE;
    @Alias(name="start_time")
    @LessThanEqual
    private Date startTimeBE;
    @Alias(name="end_time")
    @GreaterThanEqual
    private Date endTimeAE;
    @Alias(name="end_time")
    @LessThanEqual
    private Date endTimeBE;
    @SubQuery(value="exists(select 1 from fc_delegation_rule_item i where i.rule_id=r.id and i.first_version_id=#{projectFirstVersionId})")
    private Long projectFirstVersionId;
    @OrderByField
    private OrderFragment orderFragment;

    public Long getOwnerUserId() {
        return this.ownerUserId;
    }

    public void setOwnerUserId(Long ownerUserId) {
        this.ownerUserId = ownerUserId;
    }

    public String getOwnerUserName() {
        return this.ownerUserName;
    }

    public void setOwnerUserName(String ownerUserName) {
        this.ownerUserName = ownerUserName;
    }

    public Long getDelegationUserId() {
        return this.delegationUserId;
    }

    public void setDelegationUserId(Long delegationUserId) {
        this.delegationUserId = delegationUserId;
    }

    public String getDelegationUserName() {
        return this.delegationUserName;
    }

    public void setDelegationUserName(String delegationUserName) {
        this.delegationUserName = delegationUserName;
    }

    public Date getStartTimeAE() {
        return this.startTimeAE;
    }

    public void setStartTimeAE(Date startTimeAE) {
        this.startTimeAE = startTimeAE;
    }

    public Date getStartTimeBE() {
        return this.startTimeBE;
    }

    public void setStartTimeBE(Date startTimeBE) {
        this.startTimeBE = startTimeBE;
    }

    public Date getEndTimeAE() {
        return this.endTimeAE;
    }

    public void setEndTimeAE(Date endTimeAE) {
        this.endTimeAE = endTimeAE;
    }

    public Date getEndTimeBE() {
        return this.endTimeBE;
    }

    public void setEndTimeBE(Date endTimeBE) {
        this.endTimeBE = endTimeBE;
    }

    public Long getProjectFirstVersionId() {
        return this.projectFirstVersionId;
    }

    public void setProjectFirstVersionId(Long projectFirstVersionId) {
        this.projectFirstVersionId = projectFirstVersionId;
    }

    public OrderFragment getOrderFragment() {
        return this.orderFragment;
    }

    public void setOrderFragment(OrderFragment orderFragment) {
        this.orderFragment = orderFragment;
    }

    public static DelegationRuleQuery fromDelegationRulePageDto(DelegationRulePageDto dto) {
        DelegationRuleQuery delegationRuleQuery = new DelegationRuleQuery();
        delegationRuleQuery.setOwnerUserId(dto.getOwnerUserId());
        delegationRuleQuery.setOwnerUserName(dto.getOwnerUserName());
        delegationRuleQuery.setDelegationUserId(dto.getDelegationUserId());
        delegationRuleQuery.setDelegationUserName(dto.getDelegationUserName());
        delegationRuleQuery.setStartTimeAE(dto.getStartTimeAE());
        delegationRuleQuery.setStartTimeBE(dto.getStartTimeBE());
        delegationRuleQuery.setEndTimeAE(dto.getEndTimeAE());
        delegationRuleQuery.setEndTimeBE(dto.getEndTimeBE());
        delegationRuleQuery.setProjectFirstVersionId(dto.getProjectFirstVersionId());
        OrderFragment paramOrderFragment = OrderFragment.fromOrderPageParam((OrderPageParam)dto);
        if (paramOrderFragment == null) {
            delegationRuleQuery.setOrderFragment(DEFAULT_ORDER_FRAGMENT);
        } else {
            paramOrderFragment.setFieldName("r." + Strings.underscoreName((String)paramOrderFragment.getFieldName()));
            delegationRuleQuery.setOrderFragment(paramOrderFragment);
        }
        return delegationRuleQuery;
    }
}

