/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.delegation.service;

import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.lock.LockService;
import com.cyberway.mp.flow.domain.delegation.entity.DelegationRule;
import com.cyberway.mp.flow.domain.delegation.repository.DelegationRuleRepository;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDelegationTask
implements Runnable {
    private static final int LOCK_LEASE_MINUTES = 5;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final long id;
    protected final DelegationRuleRepository delegationRuleRepository;
    protected final LockService lockService;

    protected BaseDelegationTask(long id, DelegationRuleRepository delegationRuleRepository, LockService lockService) {
        this.id = id;
        this.delegationRuleRepository = delegationRuleRepository;
        this.lockService = lockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String lockKey = "DELEGATION_RULE_" + this.id;
        if (this.lockService.tryLock(lockKey, TimeUnit.MINUTES, 0L, 5L)) {
            try {
                DelegationRule rule = (DelegationRule)((Object)this.delegationRuleRepository.findOne(this.id));
                if (this.checkNeedRun(rule)) {
                    ServiceContext context = ServiceContext.getContext();
                    context.set("req.tenantId", (Object)rule.getTenantId().toString());
                    context.set("req.businessZoneId", (Object)rule.getBusinessZoneId().toString());
                    context.set("req.appInstanceId", (Object)rule.getAppInstanceId().toString());
                    context.set("req.userId", (Object)rule.getOwnerUserId().toString());
                    context.set("req.userName", (Object)rule.getOwnerUserName());
                    this.doRun(rule);
                }
            }
            finally {
                try {
                    this.lockService.unlock(lockKey);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected abstract boolean checkNeedRun(DelegationRule var1);

    protected abstract void doRun(DelegationRule var1);
}

