/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.delegation.service;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.dal.model.Entity;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.bc.lock.LockService;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRulePageDto;
import com.cyberway.mp.flow.api.delegation.enums.DelegationRuleStatus;
import com.cyberway.mp.flow.domain.delegation.entity.DelegationRule;
import com.cyberway.mp.flow.domain.delegation.entity.DelegationRuleItem;
import com.cyberway.mp.flow.domain.delegation.repository.DelegationRuleItemRepository;
import com.cyberway.mp.flow.domain.delegation.repository.DelegationRuleRepository;
import com.cyberway.mp.flow.domain.delegation.repository.query.DelegationRuleQuery;
import com.cyberway.mp.flow.domain.delegation.service.DelegationScheduleService;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectRepository;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.repository.FlowTaskRepository;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegationRuleService {
    private static final int LOCK_LEASE_MINUTES = 5;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DelegationRuleRepository delegationRuleRepository;
    private final DelegationRuleItemRepository delegationRuleItemRepository;
    private final FlowProjectRepository flowProjectRepository;
    private final FlowTaskRepository flowTaskRepository;
    private final FlowEngineService flowEngineService;
    private final LockService lockService;
    private final DelegationScheduleService delegationScheduleService;

    public DelegationRuleService(DelegationRuleRepository delegationRuleRepository, DelegationRuleItemRepository delegationRuleItemRepository, FlowProjectRepository flowProjectRepository, FlowTaskRepository flowTaskRepository, FlowEngineService flowEngineService, LockService lockService, DelegationScheduleService delegationScheduleService) {
        this.delegationRuleRepository = delegationRuleRepository;
        this.delegationRuleItemRepository = delegationRuleItemRepository;
        this.flowProjectRepository = flowProjectRepository;
        this.flowTaskRepository = flowTaskRepository;
        this.flowEngineService = flowEngineService;
        this.lockService = lockService;
        this.delegationScheduleService = delegationScheduleService;
    }

    public void createDelegationRule(DelegationRule delegationRule, Collection<DelegationRuleItem> items) {
        this.validateDelegateRule(delegationRule, items);
        Date now = new Date();
        if (delegationRule.getEndTime().before(now)) {
            delegationRule.setStartHandled(true);
            delegationRule.setEndHandled(true);
        }
        this.delegationRuleRepository.save((Object)delegationRule);
        if (Boolean.FALSE.equals(delegationRule.getDelegateAll()) && !items.isEmpty()) {
            items.forEach(item -> item.setRuleId((Long)delegationRule.getId()));
            this.delegationRuleItemRepository.batchInsert(items);
        }
        if (Boolean.FALSE.equals(delegationRule.getStartHandled())) {
            this.delegationScheduleService.addStartSchedule(delegationRule);
            this.delegationScheduleService.addEndSchedule(delegationRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyDelegationRule(DelegationRule delegationRule, Collection<DelegationRuleItem> items) {
        this.validateDelegateRule(delegationRule, items);
        String lockKey = "DELEGATION_RULE_" + delegationRule.getId();
        if (!this.lockService.tryLock(lockKey, TimeUnit.MINUTES, 0L, 5L)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_LOCK_FAILED);
        }
        try {
            DelegationRule oldRule = (DelegationRule)((Object)this.delegationRuleRepository.findOne((Long)delegationRule.getId()));
            if (DelegationRuleStatus.ENABLED.equals((Object)oldRule.getStatus())) {
                this.modifyEnableRule(delegationRule, items, oldRule);
            } else {
                this.delegationRuleRepository.updateById((Object)delegationRule, (Long)delegationRule.getId());
                this.delegationRuleItemRepository.cleanByRuleId((Long)delegationRule.getId());
                if (Boolean.FALSE.equals(delegationRule.getDelegateAll()) && !items.isEmpty()) {
                    this.delegationRuleItemRepository.batchInsert(items);
                }
            }
        }
        finally {
            try {
                this.lockService.unlock(lockKey);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void modifyEnableRule(DelegationRule delegationRule, Collection<DelegationRuleItem> items, DelegationRule oldRule) {
        List<DelegationRuleItem> oldItems = Boolean.FALSE.equals(oldRule.getDelegateAll()) ? this.delegationRuleItemRepository.findByRuleId((Long)oldRule.getId()) : Collections.emptyList();
        boolean changeUser = !oldRule.getOwnerUserId().equals(delegationRule.getOwnerUserId()) || !oldRule.getDelegationUserId().equals(delegationRule.getDelegationUserId());
        Date now = new Date();
        if (!changeUser && oldRule.getEndTime().before(now) && delegationRule.getEndTime().before(now)) {
            delegationRule.setStartHandled(true);
        } else {
            delegationRule.setStartHandled(false);
            delegationRule.setEndHandled(false);
        }
        this.delegationRuleRepository.updateById((Object)delegationRule, (Long)delegationRule.getId());
        if (!oldItems.isEmpty()) {
            this.delegationRuleItemRepository.deleteByIdIn(oldItems.stream().map(Entity::getId).collect(Collectors.toList()));
        }
        if (Boolean.FALSE.equals(delegationRule.getDelegateAll()) && !items.isEmpty()) {
            this.delegationRuleItemRepository.batchInsert(items);
        }
        Set<Long> cancelProjects = changeUser ? Collections.emptySet() : this.calCancelProjects(delegationRule, items, oldRule, oldItems);
        this.cleanDelegation(delegationRule, oldRule, cancelProjects, now, changeUser);
        if (Boolean.FALSE.equals(delegationRule.getStartHandled())) {
            this.delegationScheduleService.addStartSchedule(delegationRule);
        }
        if (Boolean.FALSE.equals(delegationRule.getEndHandled())) {
            this.delegationScheduleService.addEndSchedule(delegationRule);
        }
    }

    private Set<Long> calCancelProjects(DelegationRule delegationRule, Collection<DelegationRuleItem> items, DelegationRule oldRule, Collection<DelegationRuleItem> oldItems) {
        HashSet<Long> cancelProjects = new HashSet<Long>();
        if (Boolean.FALSE.equals(delegationRule.getDelegateAll())) {
            Set newProjects = items.stream().map(DelegationRuleItem::getFirstVersionId).collect(Collectors.toSet());
            if (Boolean.TRUE.equals(oldRule.getDelegateAll())) {
                cancelProjects.addAll(this.flowProjectRepository.listAllFirstVersionId());
            } else {
                cancelProjects.addAll(oldItems.stream().map(DelegationRuleItem::getFirstVersionId).collect(Collectors.toSet()));
            }
            cancelProjects.removeAll(newProjects);
        }
        return cancelProjects;
    }

    private void cleanDelegation(DelegationRule delegationRule, DelegationRule oldRule, Set<Long> cancelProjects, Date now, boolean changeUser) {
        block2: {
            block3: {
                if (!changeUser && oldRule.getStartTime().after(now)) break block2;
                if (!changeUser && !delegationRule.getStartTime().after(now) && !delegationRule.getEndTime().before(now)) break block3;
                List<FlowTask> tasks = this.flowTaskRepository.listToCancelDelegation((Long)delegationRule.getId());
                for (FlowTask task : tasks) {
                    this.flowEngineService.cancelDelegateTask(task.getTaskId());
                }
                break block2;
            }
            if (cancelProjects.isEmpty()) break block2;
            List<FlowTask> tasks = this.flowTaskRepository.listToCancelDelegationForProjects((Long)delegationRule.getId(), cancelProjects);
            for (FlowTask task : tasks) {
                this.flowEngineService.cancelDelegateTask(task.getTaskId());
            }
        }
    }

    private void validateDelegateRule(DelegationRule delegationRule, Collection<DelegationRuleItem> items) {
        boolean conflict;
        boolean delegationAll = Boolean.TRUE.equals(delegationRule.getDelegateAll());
        if (!delegationAll && items.isEmpty()) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_EMPTY_PROJECT);
        }
        if (delegationRule.getDelegationUserId().equals(delegationRule.getOwnerUserId())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_SAME_USER);
        }
        if (!delegationRule.getEndTime().after(delegationRule.getStartTime())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_TIME_ERROR);
        }
        if (delegationRule.getId() == null) {
            conflict = delegationAll ? this.delegationRuleRepository.countConflictDelegateAll(delegationRule.getOwnerUserId(), delegationRule.getStartTime(), delegationRule.getEndTime()) > 0L : !items.isEmpty() && this.delegationRuleRepository.countConflict(delegationRule.getOwnerUserId(), delegationRule.getStartTime(), delegationRule.getEndTime(), items.stream().map(DelegationRuleItem::getFirstVersionId).collect(Collectors.toSet())) > 0L;
        } else {
            boolean bl = delegationAll ? this.delegationRuleRepository.countConflictDelegateAllExcludeId(delegationRule.getOwnerUserId(), delegationRule.getStartTime(), delegationRule.getEndTime(), (Long)delegationRule.getId()) > 0L : (conflict = !items.isEmpty() && this.delegationRuleRepository.countConflictExcludeId(delegationRule.getOwnerUserId(), delegationRule.getStartTime(), delegationRule.getEndTime(), items.stream().map(DelegationRuleItem::getFirstVersionId).collect(Collectors.toSet()), (Long)delegationRule.getId()) > 0L);
        }
        if (conflict) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_CONFLICT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDelegationRule(long id) {
        String lockKey = "DELEGATION_RULE_" + id;
        if (!this.lockService.tryLock(lockKey, TimeUnit.MINUTES, 0L, 5L)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_LOCK_FAILED);
        }
        try {
            DelegationRule rule = (DelegationRule)((Object)this.delegationRuleRepository.findOne(id));
            if (rule == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_ID_NOT_EXISTED);
            }
            if (Boolean.FALSE.equals(rule.getDelegateAll())) {
                this.delegationRuleItemRepository.cleanByRuleId(id);
            }
            this.delegationRuleRepository.delete(id);
            if (DelegationRuleStatus.ENABLED.equals((Object)rule.getStatus()) && !rule.getStartTime().after(new Date())) {
                List<FlowTask> tasks = this.flowTaskRepository.listToCancelDelegation((Long)rule.getId());
                for (FlowTask task : tasks) {
                    this.flowEngineService.cancelDelegateTask(task.getTaskId());
                }
            }
        }
        finally {
            try {
                this.lockService.unlock(lockKey);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableDelegationRule(long id) {
        String lockKey = "DELEGATION_RULE_" + id;
        if (!this.lockService.tryLock(lockKey, TimeUnit.MINUTES, 0L, 5L)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_LOCK_FAILED);
        }
        try {
            DelegationRule rule = (DelegationRule)((Object)this.delegationRuleRepository.findOne(id));
            if (rule == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_ID_NOT_EXISTED);
            }
            if (DelegationRuleStatus.DISABLED.equals((Object)rule.getStatus())) {
                rule.setStatus(DelegationRuleStatus.ENABLED);
                if (rule.getEndTime().after(new Date())) {
                    rule.setStartHandled(false);
                    rule.setEndHandled(false);
                }
                this.delegationRuleRepository.updateById((Object)rule, (Long)rule.getId());
                if (Boolean.FALSE.equals(rule.getStartHandled())) {
                    this.delegationScheduleService.addStartSchedule(rule);
                    this.delegationScheduleService.addEndSchedule(rule);
                }
            }
        }
        finally {
            try {
                this.lockService.unlock(lockKey);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableDelegationRule(long id) {
        String lockKey = "DELEGATION_RULE_" + id;
        if (!this.lockService.tryLock(lockKey, TimeUnit.MINUTES, 0L, 5L)) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_LOCK_FAILED);
        }
        try {
            DelegationRule rule = (DelegationRule)((Object)this.delegationRuleRepository.findOne(id));
            if (rule == null) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.DELEGATION_RULE_ID_NOT_EXISTED);
            }
            if (DelegationRuleStatus.ENABLED.equals((Object)rule.getStatus())) {
                rule.setStartHandled(true);
                rule.setEndHandled(true);
                rule.setStatus(DelegationRuleStatus.DISABLED);
                this.delegationRuleRepository.updateById((Object)rule, (Long)rule.getId());
                Date now = new Date();
                if (rule.getStartTime().before(now)) {
                    this.cleanDelegation(rule, null, null, now, true);
                }
            }
        }
        finally {
            try {
                this.lockService.unlock(lockKey);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public DelegationRule getDelegationRule(long id) {
        return (DelegationRule)((Object)this.delegationRuleRepository.findOne(id));
    }

    public List<DelegationRule> pageQueryDelegationRule(DelegationRulePageDto dto) {
        return this.delegationRuleRepository.searchDelegationRule(DelegationRuleQuery.fromDelegationRulePageDto(dto), (PageParam)dto);
    }

    public long countDelegationRule(DelegationRuleQuery query) {
        return this.delegationRuleRepository.countDelegationRule(query);
    }

    public List<DelegationRuleItem> listItemInRule(long ruleId) {
        return this.delegationRuleItemRepository.findByRuleId(ruleId);
    }

    public DelegationRule checkDelegation(long ownerUserId, long firstVersionId) {
        return this.delegationRuleRepository.checkDelegation(ownerUserId, firstVersionId, new Date());
    }
}

