/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.delegation.service;

import com.cyberway.mp.bc.lock.LockService;
import com.cyberway.mp.flow.domain.delegation.entity.DelegationRule;
import com.cyberway.mp.flow.domain.delegation.repository.DelegationRuleItemRepository;
import com.cyberway.mp.flow.domain.delegation.repository.DelegationRuleRepository;
import com.cyberway.mp.flow.domain.delegation.service.DelegationScheduleInitTask;
import com.cyberway.mp.flow.domain.delegation.service.EndDelegationTask;
import com.cyberway.mp.flow.domain.delegation.service.StartDelegationTask;
import com.cyberway.mp.flow.domain.task.repository.FlowTaskRepository;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class DelegationScheduleService {
    private static final int REDUNDANT_SECONDS = 5;
    private final DelegationRuleRepository delegationRuleRepository;
    private final DelegationRuleItemRepository delegationRuleItemRepository;
    private final FlowTaskRepository flowTaskRepository;
    private final FlowEngineService flowEngineService;
    private final LockService lockService;
    private final ThreadPoolTaskScheduler scheduler;

    public DelegationScheduleService(DelegationRuleRepository delegationRuleRepository, DelegationRuleItemRepository delegationRuleItemRepository, FlowTaskRepository flowTaskRepository, FlowEngineService flowEngineService, LockService lockService) {
        this.delegationRuleRepository = delegationRuleRepository;
        this.delegationRuleItemRepository = delegationRuleItemRepository;
        this.flowTaskRepository = flowTaskRepository;
        this.flowEngineService = flowEngineService;
        this.lockService = lockService;
        this.scheduler = new ThreadPoolTaskScheduler();
        this.scheduler.setPoolSize(10);
        this.scheduler.setThreadGroupName("delegation");
        this.scheduler.setThreadNamePrefix("delegation-");
        this.scheduler.initialize();
        this.scheduler.schedule((Runnable)new DelegationScheduleInitTask(delegationRuleRepository, this), DateUtils.addSeconds((Date)new Date(), (int)30));
    }

    public void addStartSchedule(DelegationRule delegationRule) {
        Date now = DateUtils.addSeconds((Date)new Date(), (int)5);
        StartDelegationTask task = new StartDelegationTask((Long)delegationRule.getId(), this.delegationRuleRepository, this.delegationRuleItemRepository, this.flowTaskRepository, this.flowEngineService, this.lockService);
        if (delegationRule.getStartTime().before(now)) {
            this.scheduler.schedule((Runnable)task, now);
        } else {
            this.scheduler.schedule((Runnable)task, delegationRule.getStartTime());
        }
    }

    public void addEndSchedule(DelegationRule delegationRule) {
        Date now = DateUtils.addSeconds((Date)new Date(), (int)5);
        EndDelegationTask task = new EndDelegationTask((Long)delegationRule.getId(), this.delegationRuleRepository, this.flowTaskRepository, this.flowEngineService, this.lockService);
        if (delegationRule.getEndTime().before(now)) {
            this.scheduler.schedule((Runnable)task, now);
        } else {
            this.scheduler.schedule((Runnable)task, delegationRule.getEndTime());
        }
    }
}

