/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.delegation.service;

import com.cyberway.mp.bc.lock.LockService;
import com.cyberway.mp.flow.api.delegation.enums.DelegationRuleStatus;
import com.cyberway.mp.flow.domain.delegation.entity.DelegationRule;
import com.cyberway.mp.flow.domain.delegation.repository.DelegationRuleRepository;
import com.cyberway.mp.flow.domain.delegation.service.BaseDelegationTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.repository.FlowTaskRepository;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import java.util.Date;
import java.util.List;

public class EndDelegationTask
extends BaseDelegationTask {
    private final FlowTaskRepository flowTaskRepository;
    private final FlowEngineService flowEngineService;

    public EndDelegationTask(long id, DelegationRuleRepository delegationRuleRepository, FlowTaskRepository flowTaskRepository, FlowEngineService flowEngineService, LockService lockService) {
        super(id, delegationRuleRepository, lockService);
        this.flowTaskRepository = flowTaskRepository;
        this.flowEngineService = flowEngineService;
    }

    @Override
    protected boolean checkNeedRun(DelegationRule rule) {
        return rule != null && DelegationRuleStatus.ENABLED.equals((Object)rule.getStatus()) && !rule.getEndTime().after(new Date()) && Boolean.FALSE.equals(rule.getEndHandled());
    }

    @Override
    protected void doRun(DelegationRule rule) {
        List<FlowTask> tasks = this.flowTaskRepository.listToCancelDelegation((Long)rule.getId());
        for (FlowTask task : tasks) {
            this.flowEngineService.cancelDelegateTask(task.getTaskId());
        }
        DelegationRule updateRule = new DelegationRule();
        updateRule.setEndHandled(true);
        updateRule.setId((Long)rule.getId());
        this.delegationRuleRepository.updateById((Object)updateRule, (Long)rule.getId());
    }
}

