/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.delegation.service;

import com.cyberway.mp.bc.lock.LockService;
import com.cyberway.mp.flow.api.delegation.enums.DelegationRuleStatus;
import com.cyberway.mp.flow.domain.delegation.entity.DelegationRule;
import com.cyberway.mp.flow.domain.delegation.repository.DelegationRuleItemRepository;
import com.cyberway.mp.flow.domain.delegation.repository.DelegationRuleRepository;
import com.cyberway.mp.flow.domain.delegation.service.BaseDelegationTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.repository.FlowTaskRepository;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import java.util.Date;
import java.util.List;

public class StartDelegationTask
extends BaseDelegationTask {
    private final DelegationRuleItemRepository delegationRuleItemRepository;
    private final FlowTaskRepository flowTaskRepository;
    private final FlowEngineService flowEngineService;

    public StartDelegationTask(long id, DelegationRuleRepository delegationRuleRepository, DelegationRuleItemRepository delegationRuleItemRepository, FlowTaskRepository flowTaskRepository, FlowEngineService flowEngineService, LockService lockService) {
        super(id, delegationRuleRepository, lockService);
        this.delegationRuleItemRepository = delegationRuleItemRepository;
        this.flowTaskRepository = flowTaskRepository;
        this.flowEngineService = flowEngineService;
    }

    @Override
    protected boolean checkNeedRun(DelegationRule rule) {
        return rule != null && DelegationRuleStatus.ENABLED.equals((Object)rule.getStatus()) && !rule.getStartTime().after(new Date()) && Boolean.FALSE.equals(rule.getStartHandled()) && Boolean.FALSE.equals(rule.getEndHandled());
    }

    @Override
    protected void doRun(DelegationRule rule) {
        if (Boolean.TRUE.equals(rule.getDelegateAll())) {
            List<FlowTask> tasks = this.flowTaskRepository.listToDelegation(rule.getOwnerUserId());
            for (FlowTask task : tasks) {
                this.flowEngineService.delegateTask(task.getTaskId(), rule.getDelegationUserId(), (Long)rule.getId());
            }
        } else {
            List<Long> firstVersionIds = this.delegationRuleItemRepository.listFirstVersionIds((Long)rule.getId());
            List<FlowTask> tasks = this.flowTaskRepository.listToDelegationForProjects(rule.getOwnerUserId(), firstVersionIds);
            for (FlowTask task : tasks) {
                this.flowEngineService.delegateTask(task.getTaskId(), rule.getDelegationUserId(), (Long)rule.getId());
            }
        }
        DelegationRule updateRule = new DelegationRule();
        updateRule.setStartHandled(true);
        updateRule.setId((Long)rule.getId());
        this.delegationRuleRepository.updateById((Object)updateRule, (Long)rule.getId());
    }
}

