/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.his.service;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.domain.his.entity.FlowHisActivity;
import com.cyberway.mp.flow.domain.his.entity.FlowHisVariable;
import com.cyberway.mp.flow.domain.his.repository.FlowHisActivityRepository;
import com.cyberway.mp.flow.domain.his.repository.FlowHisVariableRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class FlowHisService {
    private final FlowHisActivityRepository flowHisActivityRepository;
    private final FlowHisVariableRepository flowHisVariableRepository;
    private final ParserConfig parserConfig;

    public FlowHisService(FlowHisActivityRepository flowHisActivityRepository, FlowHisVariableRepository flowHisVariableRepository) {
        this.flowHisActivityRepository = flowHisActivityRepository;
        this.flowHisVariableRepository = flowHisVariableRepository;
        this.parserConfig = new ParserConfig();
        this.parserConfig.setAutoTypeSupport(true);
    }

    public void batchInsertActivity(Collection<FlowHisActivity> flowHisActivities) {
        if (flowHisActivities.isEmpty()) {
            return;
        }
        this.flowHisActivityRepository.batchInsert(flowHisActivities);
    }

    public void batchInsertVariable(Collection<FlowHisVariable> flowHisVariables) {
        if (flowHisVariables.isEmpty()) {
            return;
        }
        this.flowHisVariableRepository.batchInsert(flowHisVariables);
    }

    public List<FlowHisActivity> listActivityByFlowInstanceId(Long flowInstanceId) {
        return this.flowHisActivityRepository.findByFlowInstanceIdOrderBySortNoAsc(flowInstanceId);
    }

    public List<FlowHisVariable> listVariableByFlowInstanceId(Long flowInstanceId) {
        return this.flowHisVariableRepository.findByFlowInstanceId(flowInstanceId);
    }

    public Map<String, Object> getVariableMapByFlowInstanceId(Long flowInstanceId, Long flowTaskId) {
        return this.getVariableMapByFlowInstanceId(flowInstanceId, flowTaskId, null);
    }

    public Map<String, Object> getVariableMapByFlowInstanceId(Long flowInstanceId, Set<String> filterVarNames) {
        return this.getVariableMapByFlowInstanceId(flowInstanceId, FlowConstant.EMPTY_ID_VALUE, filterVarNames);
    }

    public Map<String, Object> getVariableMapByFlowInstanceId(Long flowInstanceId, Long flowTaskId, Set<String> filterVarNames) {
        List<FlowHisVariable> list = this.listVariableByFlowInstanceId(flowInstanceId);
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = MapUtil.newHashMap((int)list.size());
        boolean notFilter = filterVarNames == null || filterVarNames.isEmpty();
        list.forEach(variable -> {
            if (!variable.getFlowTaskId().equals(FlowConstant.EMPTY_ID_VALUE) && !variable.getFlowTaskId().equals(flowTaskId)) {
                return;
            }
            if (!notFilter && !filterVarNames.contains(variable.getName())) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)variable.getVariableValue())) {
                result.put(variable.getName(), null);
            } else {
                result.put(variable.getName(), JSON.parse((String)variable.getVariableValue(), (ParserConfig)this.parserConfig));
            }
        });
        return result;
    }

    public Map<Long, Map<String, Object>> getVariableMapByFlowInstanceIds(Collection<Long> flowInstanceIds, Set<String> filterVarNames) {
        List<FlowHisVariable> list = this.flowHisVariableRepository.findByFlowInstanceIdIn(flowInstanceIds);
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = MapUtil.newHashMap((int)flowInstanceIds.size());
        boolean notFilter = filterVarNames == null || filterVarNames.isEmpty();
        list.forEach(variable -> {
            if (!FlowConstant.EMPTY_ID_VALUE.equals(variable.getFlowTaskId())) {
                return;
            }
            if (!notFilter && !filterVarNames.contains(variable.getName())) {
                return;
            }
            Map variableMap = result.computeIfAbsent(variable.getFlowInstanceId(), k -> new HashMap(16));
            if (StringUtils.isBlank((CharSequence)variable.getVariableValue())) {
                variableMap.put(variable.getName(), null);
            } else {
                variableMap.put(variable.getName(), JSON.parse((String)variable.getVariableValue(), (ParserConfig)this.parserConfig));
            }
        });
        return result;
    }
}

