/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.instance.entity;

import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import com.cyberway.mp.flow.api.instance.enums.FlowInstanceStatus;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceBaseVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceInfoVo;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import java.util.Date;

@Table(name="fc_flow_instance")
public class FlowInstance
extends BusinessEntityWithAppInstance {
    private String processInstanceId;
    private String instanceName;
    private String instanceCode;
    private Long flowProjectId;
    private String flowProjectCode;
    private Long businessKey;
    private Long startUserId;
    private String startUserName;
    private Date startTime;
    private Date endTime;
    private Date dueTime;
    private Boolean dueNoticed;
    private Date urgeStarterTime;
    private Date urgeSpecialTime;
    private FlowInstanceStatus status;
    private Integer bizDataFlowStatus;
    private Integer urgeTimes;

    public String getInstanceCode() {
        return this.instanceCode;
    }

    public void setInstanceCode(String instanceCode) {
        this.instanceCode = instanceCode;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public Long getFlowProjectId() {
        return this.flowProjectId;
    }

    public void setFlowProjectId(Long flowProjectId) {
        this.flowProjectId = flowProjectId;
    }

    public String getFlowProjectCode() {
        return this.flowProjectCode;
    }

    public void setFlowProjectCode(String flowProjectCode) {
        this.flowProjectCode = flowProjectCode;
    }

    public Long getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(Long businessKey) {
        this.businessKey = businessKey;
    }

    public Long getStartUserId() {
        return this.startUserId;
    }

    public void setStartUserId(Long startUserId) {
        this.startUserId = startUserId;
    }

    public String getStartUserName() {
        return this.startUserName;
    }

    public void setStartUserName(String startUserName) {
        this.startUserName = startUserName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getDueTime() {
        return this.dueTime;
    }

    public void setDueTime(Date dueTime) {
        this.dueTime = dueTime;
    }

    public Boolean getDueNoticed() {
        return this.dueNoticed;
    }

    public void setDueNoticed(Boolean dueNoticed) {
        this.dueNoticed = dueNoticed;
    }

    public Date getUrgeStarterTime() {
        return this.urgeStarterTime;
    }

    public void setUrgeStarterTime(Date urgeStarterTime) {
        this.urgeStarterTime = urgeStarterTime;
    }

    public Date getUrgeSpecialTime() {
        return this.urgeSpecialTime;
    }

    public void setUrgeSpecialTime(Date urgeSpecialTime) {
        this.urgeSpecialTime = urgeSpecialTime;
    }

    public FlowInstanceStatus getStatus() {
        return this.status;
    }

    public void setStatus(FlowInstanceStatus status) {
        this.status = status;
    }

    public Integer getBizDataFlowStatus() {
        return this.bizDataFlowStatus;
    }

    public void setBizDataFlowStatus(Integer bizDataFlowStatus) {
        this.bizDataFlowStatus = bizDataFlowStatus;
    }

    public Integer getUrgeTimes() {
        return this.urgeTimes;
    }

    public void setUrgeTimes(Integer urgeTimes) {
        this.urgeTimes = urgeTimes;
    }

    public boolean alreadyFinish() {
        return FlowInstanceStatus.COMPLETED.equals((Object)this.status) || FlowInstanceStatus.CANCELED.equals((Object)this.status);
    }

    public FlowInstanceInfoVo toFlowInstanceInfoVo() {
        FlowInstanceInfoVo flowInstanceInfoVo = new FlowInstanceInfoVo();
        this.initFlowInstanceBaseVo((FlowInstanceBaseVo)flowInstanceInfoVo);
        flowInstanceInfoVo.setEndTime(CodeUtils.formatNullableMinTime(this.getEndTime()));
        return flowInstanceInfoVo;
    }

    protected void initFlowInstanceBaseVo(FlowInstanceBaseVo vo) {
        vo.setId((Long)this.getId());
        vo.setBusinessKey(this.getBusinessKey());
        vo.setInstanceName(this.getInstanceName());
        vo.setStartUserId(CodeUtils.formatNullableId(this.getStartUserId()));
        vo.setStartUserName(this.getStartUserName());
        vo.setStartTime(this.getStartTime());
        vo.setStatus(this.getStatus());
        vo.setDueTime(CodeUtils.formatNullableMaxTime(this.getDueTime()));
        vo.setFlowProjectId(this.getFlowProjectId());
        vo.setFlowProjectCode(this.getFlowProjectCode());
        vo.setBizDataFlowStatus(this.getBizDataFlowStatus());
        vo.setInstanceCode(this.getInstanceCode());
    }
}

