/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.instance.entity;

import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceBaseVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceDetailListVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceDueVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceListVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceMyHandledPageVo;
import com.cyberway.mp.flow.api.instance.vo.FlowInstanceMyStartedPageVo;
import com.cyberway.mp.flow.api.project.enums.FormType;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import java.util.Date;

public class FlowInstanceWithCategory
extends FlowInstance {
    @Alias(name="c.id")
    private Long flowCategoryId;
    @Alias(name="c.name")
    private String flowCategoryName;
    @Alias(name="p.form_type")
    private FormType formType;
    @Alias(name="p.form_url")
    private String formUrl;
    @Alias(name="p.edit_form_url")
    private String editFormUrl;

    public Long getFlowCategoryId() {
        return this.flowCategoryId;
    }

    public void setFlowCategoryId(Long flowCategoryId) {
        this.flowCategoryId = flowCategoryId;
    }

    public String getFlowCategoryName() {
        return this.flowCategoryName;
    }

    public void setFlowCategoryName(String flowCategoryName) {
        this.flowCategoryName = flowCategoryName;
    }

    public FormType getFormType() {
        return this.formType;
    }

    public void setFormType(FormType formType) {
        this.formType = formType;
    }

    public String getFormUrl() {
        return this.formUrl;
    }

    public void setFormUrl(String formUrl) {
        this.formUrl = formUrl;
    }

    public String getEditFormUrl() {
        return this.editFormUrl;
    }

    public void setEditFormUrl(String editFormUrl) {
        this.editFormUrl = editFormUrl;
    }

    public FlowInstanceDueVo toFlowInstanceDueVo(long now) {
        FlowInstanceDueVo vo = new FlowInstanceDueVo();
        this.initFlowInstanceDueVo(vo, now);
        return vo;
    }

    public FlowInstanceListVo toFlowInstanceListVo() {
        FlowInstanceListVo flowInstanceListVo = new FlowInstanceListVo();
        this.initFlowInstanceListVo(flowInstanceListVo);
        return flowInstanceListVo;
    }

    public FlowInstanceDetailListVo toFlowInstanceDetailListVo() {
        FlowInstanceDetailListVo flowInstanceDetailListVo = new FlowInstanceDetailListVo();
        this.initFlowInstanceListVo((FlowInstanceListVo)flowInstanceDetailListVo);
        flowInstanceDetailListVo.setFormType(this.getFormType());
        flowInstanceDetailListVo.setFormUrl(this.getFormUrl());
        flowInstanceDetailListVo.setProcessInstanceId(this.getProcessInstanceId());
        return flowInstanceDetailListVo;
    }

    private void initFlowInstanceListVo(FlowInstanceListVo vo) {
        this.initFlowInstanceBaseVo((FlowInstanceBaseVo)vo);
        vo.setFlowCategoryId(this.getFlowCategoryId());
        vo.setFlowCategoryName(this.getFlowCategoryName());
        vo.setEndTime(CodeUtils.formatNullableMinTime(this.getEndTime()));
    }

    private void initFlowInstanceDueVo(FlowInstanceDueVo vo, long now) {
        this.initFlowInstanceBaseVo((FlowInstanceBaseVo)vo);
        vo.setFlowCategoryId(this.getFlowCategoryId());
        vo.setFlowCategoryName(this.getFlowCategoryName());
        vo.setUrgeTimes(this.getUrgeTimes());
        if (vo.getDueTime() == null || vo.getDueTime().getTime() >= now) {
            vo.setDueMs(Long.valueOf(0L));
        } else {
            vo.setDueMs(Long.valueOf(now - vo.getDueTime().getTime()));
        }
    }

    public FlowInstanceMyHandledPageVo toFlowInstanceMyHandledPageVo(Date now) {
        FlowInstanceMyStartedPageVo vo = new FlowInstanceMyStartedPageVo();
        this.initFlowInstanceMyHandledPageVo((FlowInstanceMyHandledPageVo)vo, now);
        return vo;
    }

    public FlowInstanceMyStartedPageVo toFlowInstanceMyStartedPageVo(Date now) {
        FlowInstanceMyStartedPageVo vo = new FlowInstanceMyStartedPageVo();
        this.initFlowInstanceMyHandledPageVo((FlowInstanceMyHandledPageVo)vo, now);
        return vo;
    }

    private void initFlowInstanceMyHandledPageVo(FlowInstanceMyHandledPageVo vo, Date now) {
        this.initFlowInstanceListVo((FlowInstanceListVo)vo);
        vo.setFormType(this.getFormType());
        vo.setFormUrl(this.getFormUrl());
        vo.setBizDataFlowStatus(this.getBizDataFlowStatus());
        vo.setEditFormUrl(this.getEditFormUrl());
        vo.setInstanceDueStatus(this.convertInstanceDueStatus(now));
    }

    private Integer convertInstanceDueStatus(Date now) {
        if (this.getDueTime() == null || FlowConstant.EMPTY_MAX_TIME.equals(this.getDueTime())) {
            return 3;
        }
        Date compareDate = this.getEndTime() == null || FlowConstant.EMPTY_MIN_TIME.equals(this.getEndTime()) ? now : this.getEndTime();
        return compareDate.before(this.getDueTime()) ? 2 : 1;
    }
}

