/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.instance.repository;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.dal.GenericMapper;
import com.cyberway.mp.bc.dal.annotation.IgnoreMethod;
import com.cyberway.mp.bc.dal.annotation.IgnoreTenantFilter;
import com.cyberway.mp.bc.dal.annotation.ResultBeanAlias;
import com.cyberway.mp.flow.api.instance.enums.FlowInstanceStatus;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceWithCategory;
import com.cyberway.mp.flow.domain.instance.repository.query.FlowInstanceQuery;
import com.cyberway.mp.flow.domain.instance.repository.query.FlowInstanceWithCategoryQuery;
import com.cyberway.mp.flow.infra.annotation.ReplaceQueryTable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface FlowInstanceRepository
extends GenericMapper<FlowInstance, Long> {
    public List<FlowInstance> findByIdIn(@Param(value="id") Collection<Long> var1);

    public List<FlowInstance> findByIdInAndStatus(@Param(value="id") Collection<Long> var1, @Param(value="status") String var2);

    public List<FlowInstance> findByProcessInstanceId(@Param(value="processInstanceId") String var1);

    public List<FlowInstance> searchFlowInstance(FlowInstanceQuery var1);

    public long countWithCategory(FlowInstanceWithCategoryQuery var1);

    @ResultBeanAlias(value="i")
    public List<FlowInstanceWithCategory> searchWithCategory(FlowInstanceWithCategoryQuery var1, PageParam var2);

    @ReplaceQueryTable(sourceTables={"fc_flow_instance", "fc_flow_instance_ext"}, targetTables={"fc_sd_flow_instance_start", "fc_sd_flow_instance_ext_start"})
    public long countWithCategoryShardingStartTime(FlowInstanceWithCategoryQuery var1);

    @ReplaceQueryTable(sourceTables={"fc_flow_instance", "fc_flow_instance_ext"}, targetTables={"fc_sd_flow_instance_start", "fc_sd_flow_instance_ext_start"})
    @ResultBeanAlias(value="i")
    public List<FlowInstanceWithCategory> searchWithCategoryShardingStartTime(FlowInstanceWithCategoryQuery var1, PageParam var2);

    @IgnoreTenantFilter
    @IgnoreMethod
    public List<FlowInstance> listForDueNotice(@Param(value="now") Date var1);

    @IgnoreTenantFilter
    @IgnoreMethod
    public void markDueNoticed(@Param(value="id") long var1, @Param(value="addUrgeTimes") boolean var3);

    @IgnoreTenantFilter
    @IgnoreMethod
    public List<FlowInstance> listForUrgeStarter(@Param(value="now") Date var1);

    @IgnoreTenantFilter
    @IgnoreMethod
    public void markUrgeStarter(@Param(value="id") long var1, @Param(value="emptyTime") Date var3, @Param(value="addUrgeTimes") boolean var4);

    @IgnoreTenantFilter
    @IgnoreMethod
    public List<FlowInstance> listForUrgeSpecial(@Param(value="now") Date var1);

    @IgnoreTenantFilter
    @IgnoreMethod
    public void markUrgeSpecial(@Param(value="id") long var1, @Param(value="emptyTime") Date var3, @Param(value="addUrgeTimes") boolean var4);

    @IgnoreMethod
    public String getDesignContentForFlowInstance(@Param(value="id") long var1);

    @IgnoreMethod
    public void addUrgeTimes(@Param(value="id") long var1);

    @IgnoreMethod
    public void changeRunningProjectId(@Param(value="oldProjectId") long var1, @Param(value="newProjectId") long var3, @Param(value="lastModifiedTime") Date var5, @Param(value="lastModifiedUserId") Long var6, @Param(value="lastModifiedUserName") String var7);

    public List<FlowInstance> findByFlowProjectCodeAndBusinessKeyAndStatus(@Param(value="flowProjectCode") String var1, @Param(value="businessKey") Long var2, @Param(value="status") FlowInstanceStatus var3);
}

