/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.instance.repository.query;

import com.cyberway.mp.bc.common.api.OrderPageParam;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.dal.annotation.Join;
import com.cyberway.mp.bc.dal.annotation.Predicate;
import com.cyberway.mp.bc.dal.annotation.query.Contains;
import com.cyberway.mp.bc.dal.annotation.query.GreaterThanEqual;
import com.cyberway.mp.bc.dal.annotation.query.In;
import com.cyberway.mp.bc.dal.annotation.query.LessThanEqual;
import com.cyberway.mp.bc.dal.annotation.query.NotIn;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.dal.annotation.query.SubQuery;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceDuePageDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceExtPageDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceExtQuerySupportDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceMyHandledPageDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstancePageDto;
import com.cyberway.mp.flow.api.instance.enums.FlowInstanceStatus;
import com.cyberway.mp.flow.domain.instance.repository.query.FlowInstanceExtQuery;
import io.seata.common.util.CollectionUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

@Predicate(dynamic=true)
@Join(script="fc_flow_instance i join fc_flow_project p on i.flow_project_id=p.id join fc_flow_model m on m.id=p.flow_model_id join fc_flow_category c on c.id=m.flow_category_id left join fc_flow_instance_ext ext on ext.flow_instance_id=i.id")
public class FlowInstanceWithCategoryQuery
extends FlowInstanceExtQuery {
    private static final OrderFragment DEFAULT_ORDER_FRAGMENT = new OrderFragment("i.start_time", "DESC");
    private static final Map<String, String> ORDER_FIELD_MAP = new HashMap<String, String>();
    @Contains
    @Alias(name="i.start_user_name")
    private String startUserName;
    @Alias(name="i.start_user_id")
    private Long startUserId;
    @In
    @Alias(name="i.start_user_id")
    private Collection<Long> startUserIdIn;
    @Alias(name="i.id")
    private Long id;
    @Alias(name="i.instance_code")
    @Contains
    private String instanceCodeLike;
    @Alias(name="i.instance_code")
    private String instanceCode;
    @Alias(name="i.app_instance_id")
    private Long appInstanceId;
    @Alias(name="c.id")
    private Long flowCategoryId;
    @In
    @Alias(name="c.id")
    private Collection<Long> flowCategoryIdIn;
    @Contains
    @Alias(name="c.name")
    private String flowCategoryName;
    @Contains
    @Alias(name="i.instance_name")
    private String instanceName;
    @Alias(name="i.status")
    private FlowInstanceStatus status;
    @In
    @Alias(name="i.status")
    private List<FlowInstanceStatus> statusIn;
    @NotIn
    @Alias(name="i.status")
    private List<FlowInstanceStatus> statusNotIn;
    @GreaterThanEqual
    @Alias(name="i.start_time")
    private Date minStartTime;
    @LessThanEqual
    @Alias(name="i.start_time")
    private Date maxStartTime;
    @GreaterThanEqual
    @Alias(name="i.end_time")
    private Date minEndTime;
    @LessThanEqual
    @Alias(name="i.end_time")
    private Date maxEndTime;
    @GreaterThanEqual
    @Alias(name="i.due_time")
    private Date minDueTime;
    @LessThanEqual
    @Alias(name="i.due_time")
    private Date maxDueTime;
    @Alias(name="p.id")
    private Long flowProjectId;
    @Alias(name="p.first_version_id")
    private Long firstVersionId;
    @Alias(name="p.code_name")
    private String flowProjectCode;
    @Alias(name="i.business_key")
    private Long businessKey;
    @SubQuery(value="exists(select 1 from fc_flow_task t where t.flow_instance_id=i.id and t.action_user_id=#{existedActionUserId} and t.status!='DELETED')")
    private Long existedActionUserId;
    @SubQuery(value="exists(select 1 from fc_flow_cc cc where cc.flow_instance_id = i.id and cc.user_id=#{existedCcUserId})")
    private Long existedCcUserId;
    @SubQuery(value="exists(select 1 from fc_flow_task t where t.flow_instance_id=i.id and t.task_name like #{currentTaskNameLike} and t.status in ('RUNNING','SUSPENDED','WAIT_STARTER_FILL','WAIT_STARTER_FILL_SAME_NODE'))")
    private String currentTaskNameLike;
    @SubQuery(value="exists(select 1 from fc_flow_task t where t.flow_instance_id=i.id and t.assignee_user_name like #{currentTaskAssigneeNameLike} and t.status in ('RUNNING','SUSPENDED','WAIT_STARTER_FILL','WAIT_STARTER_FILL_SAME_NODE'))")
    private String currentTaskAssigneeNameLike;
    @OrderByField
    private List<OrderFragment> orderFragment;

    public List<FlowInstanceStatus> getStatusNotIn() {
        return this.statusNotIn;
    }

    public void setStatusNotIn(List<FlowInstanceStatus> statusNotIn) {
        this.statusNotIn = statusNotIn;
    }

    public String getInstanceCode() {
        return this.instanceCode;
    }

    public void setInstanceCode(String instanceCode) {
        this.instanceCode = instanceCode;
    }

    public String getInstanceCodeLike() {
        return this.instanceCodeLike;
    }

    public void setInstanceCodeLike(String instanceCodeLike) {
        this.instanceCodeLike = instanceCodeLike;
    }

    public Long getStartUserId() {
        return this.startUserId;
    }

    public void setStartUserId(Long startUserId) {
        this.startUserId = startUserId;
    }

    public Collection<Long> getStartUserIdIn() {
        return this.startUserIdIn;
    }

    public void setStartUserIdIn(Collection<Long> startUserIdIn) {
        this.startUserIdIn = startUserIdIn;
    }

    public String getStartUserName() {
        return this.startUserName;
    }

    public void setStartUserName(String startUserName) {
        this.startUserName = startUserName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getFlowCategoryId() {
        return this.flowCategoryId;
    }

    public void setFlowCategoryId(Long flowCategoryId) {
        this.flowCategoryId = flowCategoryId;
    }

    public Collection<Long> getFlowCategoryIdIn() {
        return this.flowCategoryIdIn;
    }

    public void setFlowCategoryIdIn(Collection<Long> flowCategoryIdIn) {
        this.flowCategoryIdIn = flowCategoryIdIn;
    }

    public String getFlowCategoryName() {
        return this.flowCategoryName;
    }

    public void setFlowCategoryName(String flowCategoryName) {
        this.flowCategoryName = flowCategoryName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public FlowInstanceStatus getStatus() {
        return this.status;
    }

    public void setStatus(FlowInstanceStatus status) {
        this.status = status;
    }

    public List<FlowInstanceStatus> getStatusIn() {
        return this.statusIn;
    }

    public void setStatusIn(List<FlowInstanceStatus> statusIn) {
        this.statusIn = statusIn;
    }

    public Date getMinStartTime() {
        return this.minStartTime;
    }

    public void setMinStartTime(Date minStartTime) {
        this.minStartTime = minStartTime;
    }

    public Date getMaxStartTime() {
        return this.maxStartTime;
    }

    public void setMaxStartTime(Date maxStartTime) {
        this.maxStartTime = maxStartTime;
    }

    public Date getMinEndTime() {
        return this.minEndTime;
    }

    public void setMinEndTime(Date minEndTime) {
        this.minEndTime = minEndTime;
    }

    public Date getMaxEndTime() {
        return this.maxEndTime;
    }

    public void setMaxEndTime(Date maxEndTime) {
        this.maxEndTime = maxEndTime;
    }

    public Date getMinDueTime() {
        return this.minDueTime;
    }

    public void setMinDueTime(Date minDueTime) {
        this.minDueTime = minDueTime;
    }

    public Date getMaxDueTime() {
        return this.maxDueTime;
    }

    public void setMaxDueTime(Date maxDueTime) {
        this.maxDueTime = maxDueTime;
    }

    public Long getFlowProjectId() {
        return this.flowProjectId;
    }

    public void setFlowProjectId(Long flowProjectId) {
        this.flowProjectId = flowProjectId;
    }

    public Long getFirstVersionId() {
        return this.firstVersionId;
    }

    public void setFirstVersionId(Long firstVersionId) {
        this.firstVersionId = firstVersionId;
    }

    public String getFlowProjectCode() {
        return this.flowProjectCode;
    }

    public void setFlowProjectCode(String flowProjectCode) {
        this.flowProjectCode = flowProjectCode;
    }

    public Long getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(Long businessKey) {
        this.businessKey = businessKey;
    }

    public String getCurrentTaskNameLike() {
        return this.currentTaskNameLike;
    }

    public void setCurrentTaskNameLike(String currentTaskNameLike) {
        this.currentTaskNameLike = currentTaskNameLike;
    }

    public String getCurrentTaskAssigneeNameLike() {
        return this.currentTaskAssigneeNameLike;
    }

    public void setCurrentTaskAssigneeNameLike(String currentTaskAssigneeNameLike) {
        this.currentTaskAssigneeNameLike = currentTaskAssigneeNameLike;
    }

    public Long getExistedActionUserId() {
        return this.existedActionUserId;
    }

    public void setExistedActionUserId(Long existedActionUserId) {
        this.existedActionUserId = existedActionUserId;
    }

    public List<OrderFragment> getOrderFragment() {
        return this.orderFragment;
    }

    public void setOrderFragment(List<OrderFragment> orderFragment) {
        this.orderFragment = orderFragment;
    }

    public Long getAppInstanceId() {
        return this.appInstanceId;
    }

    public void setAppInstanceId(Long appInstanceId) {
        this.appInstanceId = appInstanceId;
    }

    public Long getExistedCcUserId() {
        return this.existedCcUserId;
    }

    public void setExistedCcUserId(Long existedCcUserId) {
        this.existedCcUserId = existedCcUserId;
    }

    private void initByFlowInstanceDuePageDto(FlowInstanceDuePageDto dto) {
        this.initByExtDto((FlowInstanceExtQuerySupportDto)dto);
        this.setStartUserName(dto.getStartUserName());
        this.setId(dto.getId());
        this.setFlowCategoryId(dto.getFlowCategoryId());
        this.setFlowCategoryIdIn(dto.getFlowCategoryIdIn());
        this.setFlowCategoryName(dto.getFlowCategoryName());
        this.setInstanceName(dto.getInstanceName());
        this.setMinStartTime(dto.getMinStartTime());
        this.setMaxStartTime(dto.getMaxStartTime());
        this.setFlowProjectId(dto.getProjectId());
        this.setFlowProjectCode(dto.getFlowProjectCode());
        this.setFirstVersionId(dto.getFirstProjectId());
        this.setStartUserId(dto.getStartUserId());
        this.setStartUserIdIn(dto.getStartUserIdIn());
        this.setAppInstanceId(dto.getAppInstanceId());
        this.setInstanceCodeLike(dto.getInstanceCodeLike());
        this.setInstanceCode(dto.getInstanceCode());
        this.setBusinessKey(dto.getBusinessKey());
        if (StringUtils.isNotBlank((CharSequence)dto.getCurrentTaskNameLike())) {
            this.setCurrentTaskNameLike("%" + dto.getCurrentTaskNameLike() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCurrentTaskAssigneeNameLike())) {
            this.setCurrentTaskAssigneeNameLike("%" + dto.getCurrentTaskAssigneeNameLike() + "%");
        }
        this.calOrderFragment((FlowInstanceExtPageDto)dto);
    }

    private void calOrderFragment(FlowInstanceExtPageDto dto) {
        if (null == dto || StringUtils.isBlank((CharSequence)dto.getOrderField()) && CollectionUtils.isEmpty((Collection)dto.getOrderList())) {
            this.setOrderFragment(List.of(DEFAULT_ORDER_FRAGMENT));
            return;
        }
        List orderFragmentList = OrderFragment.fromOrderPageParams((OrderPageParam)dto);
        orderFragmentList.forEach(paramOrderFragment -> {
            if (paramOrderFragment.getFieldName().startsWith("ext")) {
                this.handleExtFieldsOrderFragment((OrderFragment)paramOrderFragment);
            } else if (ORDER_FIELD_MAP.containsKey(paramOrderFragment.getFieldName())) {
                paramOrderFragment.setFieldName(ORDER_FIELD_MAP.get(paramOrderFragment.getFieldName()));
            } else {
                paramOrderFragment.setFieldName("i." + paramOrderFragment.getFieldName());
            }
        });
        this.setOrderFragment(orderFragmentList);
    }

    public static FlowInstanceWithCategoryQuery fromFlowInstanceDuePageDto(FlowInstanceDuePageDto dto) {
        FlowInstanceWithCategoryQuery flowInstanceWithCategoryQuery = new FlowInstanceWithCategoryQuery();
        flowInstanceWithCategoryQuery.initByFlowInstanceDuePageDto(dto);
        flowInstanceWithCategoryQuery.setStatusIn(List.of(FlowInstanceStatus.RUNNING, FlowInstanceStatus.SUSPENDED));
        flowInstanceWithCategoryQuery.setMaxDueTime(new Date());
        return flowInstanceWithCategoryQuery;
    }

    public static FlowInstanceWithCategoryQuery fromFlowInstancePageDto(FlowInstancePageDto dto) {
        FlowInstanceWithCategoryQuery flowInstanceWithCategoryQuery = new FlowInstanceWithCategoryQuery();
        flowInstanceWithCategoryQuery.initByFlowInstanceDuePageDto((FlowInstanceDuePageDto)dto);
        flowInstanceWithCategoryQuery.setStatus(dto.getStatus());
        flowInstanceWithCategoryQuery.setMinEndTime(dto.getMinEndTime());
        flowInstanceWithCategoryQuery.setMaxStartTime(dto.getMaxStartTime());
        return flowInstanceWithCategoryQuery;
    }

    public static FlowInstanceWithCategoryQuery fromFlowInstanceMyHandledPageDto(FlowInstanceMyHandledPageDto dto) {
        FlowInstanceWithCategoryQuery query = new FlowInstanceWithCategoryQuery();
        query.initByExtDto((FlowInstanceExtQuerySupportDto)dto);
        query.setId(dto.getId());
        query.setInstanceName(dto.getInstanceNameLike());
        query.setStartUserName(dto.getStartUserNameLike());
        query.setStatus(dto.getStatus());
        query.setFlowCategoryId(dto.getFlowCategoryId());
        query.setFlowCategoryIdIn(dto.getFlowCategoryIdIn());
        query.setMinStartTime(dto.getMinStartTime());
        query.setMaxStartTime(dto.getMaxStartTime());
        query.setMinEndTime(dto.getMinEndTime());
        query.setMaxEndTime(dto.getMaxEndTime());
        query.setBusinessKey(dto.getBusinessKey());
        query.setMinDueTime(dto.getMinDueTime());
        query.setMaxDueTime(dto.getMaxDueTime());
        query.calOrderFragment((FlowInstanceExtPageDto)dto);
        query.setInstanceCodeLike(dto.getInstanceCodeLike());
        query.setInstanceCode(dto.getInstanceCode());
        if (StringUtils.isNotBlank((CharSequence)dto.getCurrentTaskNameLike())) {
            query.setCurrentTaskNameLike("%" + dto.getCurrentTaskNameLike() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCurrentTaskAssigneeNameLike())) {
            query.setCurrentTaskAssigneeNameLike("%" + dto.getCurrentTaskAssigneeNameLike() + "%");
        }
        query.convertInstanceDueStatus(dto.getInstanceDueStatus());
        return query;
    }

    private void convertInstanceDueStatus(Integer instanceDueStatus) {
        if (instanceDueStatus == null) {
            return;
        }
        Date now = new Date();
        switch (instanceDueStatus) {
            case 1: {
                if (this.getMaxDueTime() != null && !this.getMaxDueTime().after(now)) break;
                this.setMaxDueTime(now);
                break;
            }
            case 2: {
                if (this.getMaxDueTime() == null || FlowConstant.EMPTY_MAX_TIME.equals(this.getMaxDueTime())) {
                    this.setMaxDueTime(DateUtils.addSeconds((Date)FlowConstant.EMPTY_MAX_TIME, (int)-1));
                }
                if (this.getMinDueTime() != null && !this.getMinDueTime().before(now)) break;
                this.setMinDueTime(now);
                break;
            }
            case 3: {
                this.setMinDueTime(FlowConstant.EMPTY_MAX_TIME);
                break;
            }
        }
    }

    static {
        ORDER_FIELD_MAP.put("flowCategoryName", "c.name");
        ORDER_FIELD_MAP.put("flow_category_name", "c.name");
        ORDER_FIELD_MAP.put("flowCategoryId", "c.id");
        ORDER_FIELD_MAP.put("flow_category_id", "c.id");
        ORDER_FIELD_MAP.put("formUrl", "p.form_url");
        ORDER_FIELD_MAP.put("form_url", "p.form_url");
        ORDER_FIELD_MAP.put("editFormUrl", "p.edit_form_url");
        ORDER_FIELD_MAP.put("edit_form_url", "p.edit_form_url");
        ORDER_FIELD_MAP.put("formType", "p.form_type");
        ORDER_FIELD_MAP.put("form_type", "p.form_type");
    }
}

