/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.instance.service;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.flow.api.common.dto.SetVariablesDto;
import com.cyberway.mp.flow.api.constants.BizFlowConstant;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.dto.FlowDraftInstanceDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceCcDto;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceExtDto;
import com.cyberway.mp.flow.api.instance.enums.FlowInstanceStatus;
import com.cyberway.mp.flow.domain.instance.entity.FlowCc;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceAddNode;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceExt;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceExtArray;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceWithCategory;
import com.cyberway.mp.flow.domain.instance.repository.FlowCcRepository;
import com.cyberway.mp.flow.domain.instance.repository.FlowInstanceAddNodeRepository;
import com.cyberway.mp.flow.domain.instance.repository.FlowInstanceExtArrayRepository;
import com.cyberway.mp.flow.domain.instance.repository.FlowInstanceExtRepository;
import com.cyberway.mp.flow.domain.instance.repository.FlowInstanceRepository;
import com.cyberway.mp.flow.domain.instance.repository.query.FlowInstanceQuery;
import com.cyberway.mp.flow.domain.instance.repository.query.FlowInstanceWithCategoryQuery;
import com.cyberway.mp.flow.domain.project.entity.FlowProject;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class FlowInstanceService {
    private final FlowInstanceRepository flowInstanceRepository;
    private final FlowInstanceAddNodeRepository flowInstanceAddNodeRepository;
    private final FlowInstanceExtRepository flowInstanceExtRepository;
    private final FlowInstanceExtArrayRepository flowInstanceExtArrayRepository;
    private final FlowEngineService flowEngineService;
    private final FlowCcRepository flowCcRepository;

    public FlowInstanceService(FlowInstanceRepository flowInstanceRepository, FlowInstanceAddNodeRepository flowInstanceAddNodeRepository, FlowInstanceExtRepository flowInstanceExtRepository, FlowInstanceExtArrayRepository flowInstanceExtArrayRepository, FlowEngineService flowEngineService, FlowCcRepository flowCcRepository) {
        this.flowInstanceRepository = flowInstanceRepository;
        this.flowInstanceAddNodeRepository = flowInstanceAddNodeRepository;
        this.flowInstanceExtRepository = flowInstanceExtRepository;
        this.flowInstanceExtArrayRepository = flowInstanceExtArrayRepository;
        this.flowEngineService = flowEngineService;
        this.flowCcRepository = flowCcRepository;
    }

    public void createFlowInstance(FlowInstance flowInstance) {
        this.flowInstanceRepository.save((Object)flowInstance);
    }

    public FlowInstance getFlowInstance(long id) {
        return (FlowInstance)((Object)this.flowInstanceRepository.findOne(id));
    }

    public FlowInstance getFlowInstanceByProcessInstanceId(String processInstanceId) {
        List<FlowInstance> list = this.flowInstanceRepository.findByProcessInstanceId(processInstanceId);
        return list.isEmpty() ? null : list.get(0);
    }

    public List<FlowInstance> batchGetFlowInstance(Collection<Long> ids) {
        return this.flowInstanceRepository.findByIdIn(ids);
    }

    public List<FlowInstance> batchGetFlowInstanceByStatus(Collection<Long> ids, String status) {
        return this.flowInstanceRepository.findByIdInAndStatus(ids, status);
    }

    public void modifyFlowInstance(FlowInstance flowInstance) {
        this.flowInstanceRepository.updateById((Object)flowInstance, (Long)flowInstance.getId());
    }

    public long countFlowInstanceWithCategory(FlowInstanceWithCategoryQuery query) {
        if (query.getMinStartTime() != null || query.getMaxStartTime() != null) {
            return this.flowInstanceRepository.countWithCategoryShardingStartTime(query);
        }
        return this.flowInstanceRepository.countWithCategory(query);
    }

    public List<FlowInstanceWithCategory> pageQueryFlowInstanceWithCategory(FlowInstanceWithCategoryQuery query, PageParam pageParam) {
        if (query.getMinStartTime() != null || query.getMaxStartTime() != null) {
            return this.flowInstanceRepository.searchWithCategoryShardingStartTime(query, pageParam);
        }
        return this.flowInstanceRepository.searchWithCategory(query, pageParam);
    }

    public List<FlowInstance> listFlowInstance(FlowInstanceQuery query) {
        return this.flowInstanceRepository.searchFlowInstance(query);
    }

    public List<FlowInstance> listForDueNotice() {
        return this.flowInstanceRepository.listForDueNotice(new Date());
    }

    public void markDueNoticed(long id, boolean addUrgeTimes) {
        this.flowInstanceRepository.markDueNoticed(id, addUrgeTimes);
    }

    public List<FlowInstance> listForUrgeStarter() {
        return this.flowInstanceRepository.listForUrgeStarter(new Date());
    }

    public void markUrgeStarter(long id, boolean addUrgeTimes) {
        this.flowInstanceRepository.markUrgeStarter(id, FlowConstant.EMPTY_MAX_TIME, addUrgeTimes);
    }

    public List<FlowInstance> listForUrgeSpecial() {
        return this.flowInstanceRepository.listForUrgeSpecial(new Date());
    }

    public void markUrgeSpecial(long id, boolean addUrgeTimes) {
        this.flowInstanceRepository.markUrgeSpecial(id, FlowConstant.EMPTY_MAX_TIME, addUrgeTimes);
    }

    public void markFlowInstanceCancelled(long id, Date endTime) {
        FlowInstance flowInstance = new FlowInstance();
        flowInstance.setStatus(FlowInstanceStatus.CANCELED);
        flowInstance.setBizDataFlowStatus(BizFlowConstant.FLOW_STATUS_CLOSED);
        flowInstance.setEndTime(endTime);
        flowInstance.setId(Long.valueOf(id));
        this.flowInstanceRepository.updateById((Object)flowInstance, id);
    }

    public void changeFlowInstanceStatus(long id, FlowInstanceStatus status) {
        FlowInstance flowInstance = new FlowInstance();
        flowInstance.setStatus(status);
        flowInstance.setId(Long.valueOf(id));
        this.flowInstanceRepository.updateById((Object)flowInstance, id);
    }

    public void changeFlowInstanceBizDataFlowStatus(long id, Integer bizDataFlowStatus) {
        FlowInstance flowInstance = new FlowInstance();
        flowInstance.setBizDataFlowStatus(bizDataFlowStatus);
        flowInstance.setId(Long.valueOf(id));
        this.flowInstanceRepository.updateById((Object)flowInstance, id);
    }

    public String getDesignContentForFlowInstance(long flowInstanceId) {
        return this.flowInstanceRepository.getDesignContentForFlowInstance(flowInstanceId);
    }

    public void setVariables(SetVariablesDto dto) {
        FlowInstance flowInstance = this.getFlowInstance(dto.getId());
        if (null == flowInstance || null == dto.getVariables() || dto.getVariables().isEmpty()) {
            return;
        }
        this.flowEngineService.setVariablesByProcessInstanceId(flowInstance.getProcessInstanceId(), dto.getVariables());
    }

    public void addNode(FlowInstanceAddNode node) {
        this.flowInstanceAddNodeRepository.save((Object)node);
    }

    public List<FlowInstanceAddNode> listAddNodes(Long flowInstanceId) {
        return this.flowInstanceAddNodeRepository.findByFlowInstanceId(flowInstanceId);
    }

    public void addUrgeTimes(long id) {
        this.flowInstanceRepository.addUrgeTimes(id);
    }

    public void addOrUpdateExtFields(long flowInstanceId, String processInstanceId, Date startTime, FlowInstanceExtDto extDto) {
        if (extDto == null) {
            return;
        }
        FlowInstanceExt ext = this.flowInstanceExtRepository.findByFlowInstanceId(flowInstanceId);
        if (ext == null) {
            ext = new FlowInstanceExt();
            ext.setFlowInstanceId(flowInstanceId);
            ext.setProcessInstanceId(processInstanceId);
            ext.setStartTime(startTime);
        }
        BeanUtils.copyProperties((Object)extDto, (Object)((Object)ext));
        if (ext.getId() == null) {
            this.flowInstanceExtRepository.save((Object)ext);
        } else {
            this.flowInstanceExtRepository.updateAllField(ext);
        }
        if (this.flowInstanceExtArrayRepository.countByFlowInstanceId(flowInstanceId) > 0L) {
            this.flowInstanceExtArrayRepository.deleteByFlowInstanceId(flowInstanceId);
        }
        if (extDto.getExtArrayFields() == null) {
            return;
        }
        List extArrays = extDto.getExtArrayFields().entrySet().stream().filter(e -> e.getValue() != null).flatMap(e -> {
            AtomicInteger sortNo = new AtomicInteger();
            return ((List)e.getValue()).stream().map(v -> {
                FlowInstanceExtArray extArray = new FlowInstanceExtArray();
                extArray.setFlowInstanceId(flowInstanceId);
                extArray.setFieldKey((String)e.getKey());
                extArray.setFieldValue((String)v);
                extArray.setSortNo(sortNo.getAndIncrement());
                extArray.setStartTime(startTime);
                extArray.setProcessInstanceId(processInstanceId);
                return extArray;
            });
        }).collect(Collectors.toList());
        if (!extArrays.isEmpty()) {
            this.flowInstanceExtArrayRepository.batchInsert(extArrays);
        }
    }

    public FlowInstanceExt getExtFieldsByFlowInstanceId(Long flowInstanceId) {
        return this.flowInstanceExtRepository.findByFlowInstanceId(flowInstanceId);
    }

    public List<FlowInstanceExt> getExtFieldsByFlowInstanceIds(Collection<Long> flowInstanceIds) {
        if (flowInstanceIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.flowInstanceExtRepository.findByFlowInstanceIdIn(flowInstanceIds);
    }

    public List<FlowInstanceExtArray> getExtArrayFieldsByFlowInstanceId(Long flowInstanceId) {
        return this.flowInstanceExtArrayRepository.findByFlowInstanceId(flowInstanceId);
    }

    public List<FlowInstanceExtArray> getExtArrayFieldsByFlowInstanceIds(Collection<Long> flowInstanceIds) {
        if (flowInstanceIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.flowInstanceExtArrayRepository.findByFlowInstanceIdIn(flowInstanceIds);
    }

    public void changeRunningProjectId(Long oldProjectId, Long newProjectId) {
        this.flowInstanceRepository.changeRunningProjectId(oldProjectId, newProjectId, new Date(), ServiceContext.getContext().getRequestUserId(), ServiceContext.getContext().getRequestUserName());
    }

    public Long createOrModifyFlowDraftInstance(FlowProject flowProject, FlowDraftInstanceDto dto) {
        FlowInstance flowInstance;
        List<FlowInstance> flowInstanceList = this.flowInstanceRepository.findByFlowProjectCodeAndBusinessKeyAndStatus(flowProject.getCodeName(), dto.getBusinessKey(), FlowInstanceStatus.DRAFT);
        if (CollectionUtils.isEmpty(flowInstanceList)) {
            flowInstance = new FlowInstance();
            flowInstance.setProcessInstanceId(String.valueOf(FlowConstant.EMPTY_ID_VALUE));
            flowInstance.setInstanceName(flowProject.getName());
            flowInstance.setFlowProjectId((Long)flowProject.getId());
            flowInstance.setFlowProjectCode(flowProject.getCodeName());
            flowInstance.setBusinessKey(dto.getBusinessKey());
            flowInstance.setStatus(FlowInstanceStatus.DRAFT);
            flowInstance.setBizDataFlowStatus(BizFlowConstant.FLOW_STATUS_RUNNING);
            flowInstance.setStartTime(new Date());
            flowInstance.setEndTime(FlowConstant.EMPTY_MIN_TIME);
            flowInstance.setStartUserId(ServiceContext.getContext().getRequestUserId());
            flowInstance.setStartUserName(ServiceContext.getContext().getRequestUserName());
            flowInstance.setDueTime(FlowConstant.EMPTY_MAX_TIME);
            flowInstance.setDueNoticed(false);
            flowInstance.setUrgeSpecialTime(FlowConstant.EMPTY_MAX_TIME);
            flowInstance.setUrgeStarterTime(FlowConstant.EMPTY_MAX_TIME);
            flowInstance.setInstanceCode(dto.getInstanceCode());
            this.flowInstanceRepository.save((Object)flowInstance);
        } else {
            flowInstance = flowInstanceList.get(0);
            FlowInstance modifyFlowInstance = new FlowInstance();
            modifyFlowInstance.setFlowProjectId((Long)flowProject.getId());
            modifyFlowInstance.setInstanceName(flowProject.getName());
            this.flowInstanceRepository.updateById((Object)modifyFlowInstance, (Long)flowInstance.getId());
        }
        this.addOrUpdateExtFields((Long)flowInstance.getId(), flowInstance.getProcessInstanceId(), flowInstance.getStartTime(), dto.getExtFields());
        return (Long)flowInstance.getId();
    }

    public List<Long> removeFlowDraftInstance(FlowProject flowProject, Long businessKey) {
        List<FlowInstance> flowInstanceList = this.flowInstanceRepository.findByFlowProjectCodeAndBusinessKeyAndStatus(flowProject.getCodeName(), businessKey, FlowInstanceStatus.DRAFT);
        ArrayList<Long> instanceIds = new ArrayList<Long>(flowInstanceList.size());
        for (FlowInstance flowInstance : flowInstanceList) {
            this.flowInstanceRepository.delete((Long)flowInstance.getId());
            this.flowInstanceExtRepository.deleteByFlowInstanceId((Long)flowInstance.getId());
            this.flowInstanceExtArrayRepository.deleteByFlowInstanceId((Long)flowInstance.getId());
            instanceIds.add((Long)flowInstance.getId());
        }
        return instanceIds;
    }

    public void ccToUsers(FlowInstanceCcDto dto, Long flowInstanceId) {
        List<FlowCc> flowCcList = FlowCc.fromFlowInstanceCcDto(dto, flowInstanceId);
        this.flowCcRepository.batchInsert(flowCcList);
    }

    public List<FlowCc> listFlowCc(Long flowInstanceId) {
        return this.flowCcRepository.findByFlowInstanceIdOrderByCreatedTimeAsc(flowInstanceId);
    }

    public List<FlowCc> listCcInInstance(Long flowInstanceId) {
        return this.flowCcRepository.findByFlowInstanceId(flowInstanceId);
    }
}

