/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.log.service;

import com.cyberway.mp.flow.api.log.enums.UrgeLogType;
import com.cyberway.mp.flow.domain.log.entity.FlowLog;
import com.cyberway.mp.flow.domain.log.entity.FlowUrgeLog;
import com.cyberway.mp.flow.domain.log.repository.FlowLogRepository;
import com.cyberway.mp.flow.domain.log.repository.FlowUrgeLogRepository;
import java.util.List;

public class FlowLogService {
    private final FlowLogRepository flowLogRepository;
    private final FlowUrgeLogRepository flowUrgeLogRepository;

    public FlowLogService(FlowLogRepository flowLogRepository, FlowUrgeLogRepository flowUrgeLogRepository) {
        this.flowLogRepository = flowLogRepository;
        this.flowUrgeLogRepository = flowUrgeLogRepository;
    }

    public void createFlowLog(FlowLog flowLog) {
        if (flowLog.getExtraInfo() == null) {
            flowLog.setExtraInfo("");
        }
        this.flowLogRepository.save((Object)flowLog);
    }

    public List<FlowLog> listFlowLog(long flowInstanceId) {
        return this.flowLogRepository.findByFlowInstanceIdOrderByActionTimeAsc(flowInstanceId);
    }

    public void createFlowUrgeLog(FlowUrgeLog flowUrgeLog) {
        this.flowUrgeLogRepository.save((Object)flowUrgeLog);
    }

    public List<FlowUrgeLog> listFlowTaskUrgeLog(long flowTaskId) {
        return this.flowUrgeLogRepository.findByFlowTaskIdOrderByCreatedTimeDesc(flowTaskId);
    }

    public List<FlowUrgeLog> listFlowInstanceUrgeLog(long flowInstanceId) {
        return this.flowUrgeLogRepository.findByFlowInstanceIdAndLogTypeOrderByCreatedTimeDesc(flowInstanceId, UrgeLogType.INSTANCE);
    }
}

