/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.model.entity;

import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.model.dto.FlowModelCreateDto;
import com.cyberway.mp.flow.api.model.enums.FlowModelStatus;
import com.cyberway.mp.flow.api.model.vo.FlowModelStatusInfoVo;
import com.cyberway.mp.flow.infra.util.CodeUtils;

@Table(name="fc_flow_model")
public class FlowModel
extends BusinessEntityWithAppInstance {
    private String codeName;
    private String name;
    private Long flowCategoryId;
    private String designContent;
    private String imageBase64;
    private String modelNodes;
    private FlowModelStatus status;
    private Integer versionNo;
    private Long baseModelId;
    private Long firstVersionId;
    private String description;

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getFlowCategoryId() {
        return this.flowCategoryId;
    }

    public void setFlowCategoryId(Long flowCategoryId) {
        this.flowCategoryId = flowCategoryId;
    }

    public String getDesignContent() {
        return this.designContent;
    }

    public void setDesignContent(String designContent) {
        this.designContent = designContent;
    }

    public String getImageBase64() {
        return this.imageBase64;
    }

    public void setImageBase64(String imageBase64) {
        this.imageBase64 = imageBase64;
    }

    public String getModelNodes() {
        return this.modelNodes;
    }

    public void setModelNodes(String modelNodes) {
        this.modelNodes = modelNodes;
    }

    public FlowModelStatus getStatus() {
        return this.status;
    }

    public void setStatus(FlowModelStatus status) {
        this.status = status;
    }

    public Integer getVersionNo() {
        return this.versionNo;
    }

    public void setVersionNo(Integer versionNo) {
        this.versionNo = versionNo;
    }

    public Long getBaseModelId() {
        return this.baseModelId;
    }

    public void setBaseModelId(Long baseModelId) {
        this.baseModelId = baseModelId;
    }

    public Long getFirstVersionId() {
        return this.firstVersionId;
    }

    public void setFirstVersionId(Long firstVersionId) {
        this.firstVersionId = firstVersionId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static FlowModel fromFlowModelCreateDto(FlowModelCreateDto dto) {
        FlowModel flowModel = new FlowModel();
        flowModel.setCodeName(dto.getCodeName());
        flowModel.setName(dto.getName());
        flowModel.setFlowCategoryId(dto.getFlowCategoryId());
        flowModel.setDesignContent("");
        flowModel.setModelNodes("");
        flowModel.setImageBase64("");
        flowModel.setStatus(FlowModelStatus.DRAFT);
        flowModel.setVersionNo(FlowConstant.EMPTY_VERSION_VALUE);
        flowModel.setBaseModelId(FlowConstant.EMPTY_ID_VALUE);
        flowModel.setFirstVersionId(FlowConstant.EMPTY_ID_VALUE);
        flowModel.setDescription(dto.getDescription());
        return flowModel;
    }

    public static FlowModel fromOldVersion(FlowModel old) {
        FlowModel flowModel = new FlowModel();
        flowModel.setCodeName(old.getCodeName());
        flowModel.setName(old.getName());
        flowModel.setFlowCategoryId(old.getFlowCategoryId());
        flowModel.setDesignContent(old.getDesignContent());
        flowModel.setModelNodes(old.getModelNodes());
        flowModel.setImageBase64(old.getImageBase64());
        flowModel.setStatus(FlowModelStatus.DRAFT);
        flowModel.setVersionNo(FlowConstant.EMPTY_VERSION_VALUE);
        flowModel.setBaseModelId((Long)old.getId());
        flowModel.setFirstVersionId(old.getFirstVersionId());
        flowModel.setDescription(old.getDescription());
        flowModel.setAppInstanceId(old.getAppInstanceId());
        flowModel.setBusinessZoneId(old.getBusinessZoneId());
        flowModel.setTenantId(old.getTenantId());
        return flowModel;
    }

    public FlowModelStatusInfoVo toFlowModelStatusInfoVo() {
        FlowModelStatusInfoVo vo = new FlowModelStatusInfoVo();
        vo.setId((Long)this.getId());
        vo.setStatus(this.getStatus());
        vo.setVersionNo(CodeUtils.formatNullableVersionNo(this.getVersionNo()));
        return vo;
    }

    public void update(FlowModelCreateDto dto) {
        this.setFlowCategoryId(dto.getFlowCategoryId());
        this.setCodeName(dto.getCodeName());
        this.setName(dto.getName());
        this.setDescription(dto.getDescription());
    }
}

