/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.model.repository.query;

import com.cyberway.mp.bc.common.api.OrderPageParam;
import com.cyberway.mp.bc.dal.annotation.Predicate;
import com.cyberway.mp.bc.dal.annotation.query.Contains;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import com.cyberway.mp.flow.api.model.dto.FlowModelPageDto;
import org.apache.commons.lang3.ObjectUtils;

@Predicate(dynamic=true)
public class FlowModelQuery {
    private static final OrderFragment DEFAULT_ORDER_FRAGMENT = new OrderFragment("created_time", "ASC");
    private static final OrderFragment VERSION_NO_ORDER_FRAGMENT = new OrderFragment("version_no", "DESC");
    @Contains
    private String codeName;
    @Contains
    private String name;
    private Long flowCategoryId;
    @OrderByField
    private OrderFragment orderFragment;

    public FlowModelQuery() {
    }

    public FlowModelQuery(String codeName) {
        this.codeName = codeName;
        this.orderFragment = VERSION_NO_ORDER_FRAGMENT;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getFlowCategoryId() {
        return this.flowCategoryId;
    }

    public void setFlowCategoryId(Long flowCategoryId) {
        this.flowCategoryId = flowCategoryId;
    }

    public OrderFragment getOrderFragment() {
        return this.orderFragment;
    }

    public void setOrderFragment(OrderFragment orderFragment) {
        this.orderFragment = orderFragment;
    }

    public static FlowModelQuery fromFlowModelPageDto(FlowModelPageDto dto) {
        FlowModelQuery flowModelQuery = new FlowModelQuery();
        flowModelQuery.setCodeName(dto.getCodeName());
        flowModelQuery.setName(dto.getName());
        flowModelQuery.setFlowCategoryId(dto.getFlowCategoryId());
        flowModelQuery.setOrderFragment((OrderFragment)ObjectUtils.defaultIfNull((Object)OrderFragment.fromOrderPageParam((OrderPageParam)dto), (Object)DEFAULT_ORDER_FRAGMENT));
        return flowModelQuery;
    }
}

