/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.model.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.model.dto.FlowModelPageDto;
import com.cyberway.mp.flow.api.model.enums.FlowModelNodeType;
import com.cyberway.mp.flow.api.model.enums.FlowModelStatus;
import com.cyberway.mp.flow.api.model.vo.FlowModelLineVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelNodeVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelNodesVo;
import com.cyberway.mp.flow.domain.model.entity.FlowModel;
import com.cyberway.mp.flow.domain.model.entity.FlowModelWithCategoryName;
import com.cyberway.mp.flow.domain.model.entity.SimpleFlowModel;
import com.cyberway.mp.flow.domain.model.entity.SimpleFlowModelWithCategoryName;
import com.cyberway.mp.flow.domain.model.repository.FlowModelRepository;
import com.cyberway.mp.flow.domain.model.repository.query.FlowModelQuery;
import com.cyberway.mp.flow.domain.model.repository.query.FlowModelWithCategoryNameQuery;
import com.cyberway.mp.flow.domain.model.repository.query.SimpleFlowModelQuery;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FlowModelService {
    private final FlowModelRepository flowModelRepository;

    public FlowModelService(FlowModelRepository flowModelRepository) {
        this.flowModelRepository = flowModelRepository;
    }

    public void createFlowModel(FlowModel flowModel) {
        if (CodeUtils.isEmptyId(flowModel.getBaseModelId()) && this.checkCodeExisted(flowModel.getCodeName())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_CODE_ALREADY_EXISTED);
        }
        this.flowModelRepository.save((Object)flowModel);
    }

    public boolean checkCodeExisted(String codeName) {
        return this.flowModelRepository.countByCodeName(codeName) > 0L;
    }

    public FlowModel getFlowModel(long id) {
        return (FlowModel)((Object)this.flowModelRepository.findOne(id));
    }

    public SimpleFlowModelWithCategoryName getSimpleFlowModelWithCategoryName(long id) {
        List<SimpleFlowModelWithCategoryName> list = this.flowModelRepository.searchSimpleWithCategoryNameNoPage(new FlowModelWithCategoryNameQuery(id));
        return list.isEmpty() ? null : list.get(0);
    }

    public FlowModelWithCategoryName getFlowModelWithCategoryName(long id) {
        List<FlowModelWithCategoryName> list = this.flowModelRepository.searchWithCategoryName(new FlowModelWithCategoryNameQuery(id));
        return list.isEmpty() ? null : list.get(0);
    }

    public void modifyFlowModel(FlowModel flowModel) {
        this.flowModelRepository.updateById((Object)flowModel, (Long)flowModel.getId());
    }

    public void enableModel(long id) {
        FlowModel flowModel = (FlowModel)((Object)this.flowModelRepository.findOne(id));
        if (flowModel == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ID_NOT_EXISTED);
        }
        switch (flowModel.getStatus()) {
            case DRAFT: {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.DRAFT_MODEL_NOT_ALLOW_ACTION);
            }
            case DISABLED: {
                this.flowModelRepository.disableAll(flowModel.getFirstVersionId());
                flowModel.setStatus(FlowModelStatus.ENABLED);
                this.flowModelRepository.updateById((Object)flowModel, (Long)flowModel.getId());
                break;
            }
        }
    }

    public void disableModel(long id) {
        FlowModel flowModel = (FlowModel)((Object)this.flowModelRepository.findOne(id));
        if (flowModel == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ID_NOT_EXISTED);
        }
        switch (flowModel.getStatus()) {
            case DRAFT: {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.DRAFT_MODEL_NOT_ALLOW_ACTION);
            }
            case ENABLED: {
                flowModel.setStatus(FlowModelStatus.DISABLED);
                this.flowModelRepository.updateById((Object)flowModel, (Long)flowModel.getId());
                break;
            }
        }
    }

    public void deleteFlowModel(long id) {
        FlowModel flowModel = (FlowModel)((Object)this.flowModelRepository.findOne(id));
        if (flowModel == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ID_NOT_EXISTED);
        }
        if (!FlowModelStatus.DRAFT.equals((Object)flowModel.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.RELEASED_MODEL_NOT_ALLOW_ACTION);
        }
        this.flowModelRepository.delete(id);
    }

    public void releaseFlowModel(long id) {
        FlowModel flowModel = (FlowModel)((Object)this.flowModelRepository.findOne(id));
        if (flowModel == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_ID_NOT_EXISTED);
        }
        this.releaseFlowModel(flowModel);
    }

    public void releaseFlowModel(FlowModel flowModel) {
        if (!FlowModelStatus.DRAFT.equals((Object)flowModel.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.RELEASE_NO_DRAFT_MODEL);
        }
        if (StringUtils.isBlank((CharSequence)flowModel.getDesignContent())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_CONTENT_EMPTY);
        }
        flowModel.setModelNodes(JSON.toJSONString((Object)this.readNodesFromDesignContent(flowModel.getDesignContent())));
        if (CodeUtils.isEmptyId(flowModel.getFirstVersionId())) {
            flowModel.setFirstVersionId((Long)flowModel.getId());
            flowModel.setVersionNo(1);
        } else {
            Integer maxVersionNo = this.flowModelRepository.getMaxVersionNo(flowModel.getFirstVersionId());
            flowModel.setVersionNo((Integer)ObjectUtils.defaultIfNull((Object)maxVersionNo, (Object)0) + 1);
            this.flowModelRepository.disableAll(flowModel.getFirstVersionId());
        }
        flowModel.setStatus(FlowModelStatus.ENABLED);
        this.flowModelRepository.updateById((Object)flowModel, (Long)flowModel.getId());
    }

    public Integer getMaxVersionNo(long firstVersionId) {
        return this.flowModelRepository.getMaxVersionNo(firstVersionId);
    }

    public List<SimpleFlowModelWithCategoryName> pageQueryFlowModel(FlowModelPageDto dto) {
        return this.flowModelRepository.searchSimpleWithCategoryName(FlowModelWithCategoryNameQuery.fromFlowModelPageDto(dto), (PageParam)dto);
    }

    public long countFlowModel(FlowModelWithCategoryNameQuery query) {
        return this.flowModelRepository.countFlowModel(query);
    }

    public void moveCategory(Collection<Long> oldCategoryIds, Long newCategoryId) {
        this.flowModelRepository.moveCategory(oldCategoryIds, newCategoryId);
    }

    public List<SimpleFlowModel> listEnabledInCategory(long categoryId) {
        SimpleFlowModelQuery query = new SimpleFlowModelQuery();
        query.setFlowCategoryId(categoryId);
        query.setStatus(FlowModelStatus.ENABLED);
        return this.flowModelRepository.searchSimple(query);
    }

    private FlowModelNodesVo readNodesFromDesignContent(String designContent) {
        JSONArray designJson = JSON.parseArray((String)designContent);
        HashMap<String, List<JSONObject>> edgeMap = new HashMap<String, List<JSONObject>>(16);
        ArrayList<FlowModelNodeVo> nodes = new ArrayList<FlowModelNodeVo>();
        for (int i = 0; i < designJson.size(); ++i) {
            JSONObject jsonObject = designJson.getJSONObject(i);
            String shape = jsonObject.getString("shape");
            if ("edge".equals(shape)) {
                edgeMap.computeIfAbsent(jsonObject.getJSONObject("source").getString("cell"), key -> new ArrayList()).add(jsonObject);
                continue;
            }
            FlowModelNodeVo nodeVo = new FlowModelNodeVo();
            JSONObject size = jsonObject.getJSONObject("size");
            nodeVo.setHeight(size.getInteger("height"));
            nodeVo.setWidth(size.getInteger("width"));
            JSONObject position = jsonObject.getJSONObject("position");
            nodeVo.setPositionX(position.getInteger("x"));
            nodeVo.setPositionY(position.getInteger("y"));
            nodeVo.setNodeKey(jsonObject.getString("id"));
            if (jsonObject.containsKey((Object)"data")) {
                nodeVo.setNodeName(jsonObject.getJSONObject("data").getString("description"));
            }
            nodeVo.setNodeType(FlowModelNodeType.findByFrontType((String)shape));
            nodes.add(nodeVo);
        }
        return this.buildFlowModelNodesVo(edgeMap, nodes);
    }

    private FlowModelNodesVo buildFlowModelNodesVo(Map<String, List<JSONObject>> edgeMap, List<FlowModelNodeVo> nodes) {
        FlowModelNodesVo nodesVo = new FlowModelNodesVo();
        ArrayList<FlowModelNodeVo> approvalNodes = new ArrayList<FlowModelNodeVo>();
        nodesVo.setApprovalNodes(approvalNodes);
        ArrayList<FlowModelNodeVo> gatewayNodes = new ArrayList<FlowModelNodeVo>();
        nodesVo.setGatewayNodes(gatewayNodes);
        ArrayList<FlowModelNodeVo> serviceNodes = new ArrayList<FlowModelNodeVo>();
        nodesVo.setServiceNodes(serviceNodes);
        ArrayList<FlowModelNodeVo> scriptNodes = new ArrayList<FlowModelNodeVo>();
        nodesVo.setScriptNodes(scriptNodes);
        ArrayList<FlowModelNodeVo> receiveNodes = new ArrayList<FlowModelNodeVo>();
        nodesVo.setReceiveNodes(receiveNodes);
        ArrayList<FlowModelNodeVo> manualNodes = new ArrayList<FlowModelNodeVo>();
        nodesVo.setManualNodes(manualNodes);
        ArrayList<FlowModelNodeVo> endNodes = new ArrayList<FlowModelNodeVo>();
        nodesVo.setEndNodes(endNodes);
        HashMap<String, List<String>> linkInMapping = new HashMap<String, List<String>>();
        for (FlowModelNodeVo node : nodes) {
            this.handleEdgeTarget(edgeMap, node, linkInMapping);
        }
        block10: for (FlowModelNodeVo node : nodes) {
            String nodeDesc = StringUtils.defaultString((String)node.getNodeName()) + "(" + node.getNodeKey() + ")";
            switch (node.getNodeType()) {
                case START: {
                    if (nodesVo.getStartNode() != null) {
                        throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_CONTENT_MULTI_START);
                    }
                    this.checkNotAllowLinkIn(node, linkInMapping, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_START_HAS_IN));
                    this.checkMustHasLinkOut(node, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_START_MISSING_OUT));
                    nodesVo.setStartNode(node);
                    continue block10;
                }
                case END: {
                    this.checkNotAllowLinkOut(node, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_END_HAS_OUT));
                    this.checkMustHasLinkIn(node, linkInMapping, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_END_MISSING_IN));
                    endNodes.add(node);
                    continue block10;
                }
                case APPROVAL: {
                    this.checkMustHasLinkIn(node, linkInMapping, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_MISSING_IN, new Object[]{nodeDesc}));
                    this.checkMustHasLinkOut(node, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_NO_OUT_LINE, new Object[]{nodeDesc}));
                    approvalNodes.add(node);
                    continue block10;
                }
                case SERVICE: {
                    this.checkMustHasLinkIn(node, linkInMapping, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_MISSING_IN, new Object[]{nodeDesc}));
                    this.checkMustHasLinkOut(node, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_NO_OUT_LINE, new Object[]{nodeDesc}));
                    serviceNodes.add(node);
                    continue block10;
                }
                case SCRIPT: {
                    this.checkMustHasLinkIn(node, linkInMapping, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_MISSING_IN, new Object[]{nodeDesc}));
                    this.checkMustHasLinkOut(node, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_NO_OUT_LINE, new Object[]{nodeDesc}));
                    scriptNodes.add(node);
                    continue block10;
                }
                case RECEIVE: {
                    this.checkMustHasLinkIn(node, linkInMapping, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_MISSING_IN, new Object[]{nodeDesc}));
                    this.checkMustHasLinkOut(node, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_NO_OUT_LINE, new Object[]{nodeDesc}));
                    receiveNodes.add(node);
                    continue block10;
                }
                case MANUAL: {
                    this.checkMustHasLinkIn(node, linkInMapping, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_MISSING_IN, new Object[]{nodeDesc}));
                    this.checkMustHasLinkOut(node, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_NO_OUT_LINE, new Object[]{nodeDesc}));
                    manualNodes.add(node);
                    continue block10;
                }
            }
            this.checkMustHasLinkIn(node, linkInMapping, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_MISSING_IN, new Object[]{nodeDesc}));
            this.checkMustHasLinkOut(node, () -> new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_NO_OUT_LINE, new Object[]{nodeDesc}));
            gatewayNodes.add(node);
        }
        this.validateNodesVo(nodesVo);
        return nodesVo;
    }

    private void checkMustHasLinkIn(FlowModelNodeVo node, Map<String, List<String>> linkInMapping, Supplier<BaseException> exceptionBuilder) {
        List linkInNodes = linkInMapping.getOrDefault(node.getNodeKey(), Collections.emptyList());
        if (CollectionUtils.isEmpty(linkInNodes)) {
            throw exceptionBuilder.get();
        }
    }

    private void checkNotAllowLinkOut(FlowModelNodeVo node, Supplier<BaseException> exceptionBuilder) {
        List targetLines = node.getTargetLines();
        if (!CollectionUtils.isEmpty((Collection)targetLines)) {
            throw exceptionBuilder.get();
        }
    }

    private void checkMustHasLinkOut(FlowModelNodeVo node, Supplier<BaseException> exceptionBuilder) {
        List targetLines = node.getTargetLines();
        if (CollectionUtils.isEmpty((Collection)targetLines)) {
            throw exceptionBuilder.get();
        }
    }

    private void checkNotAllowLinkIn(FlowModelNodeVo node, Map<String, List<String>> linkInMapping, Supplier<BaseException> exceptionBuilder) {
        List linkInNodes = linkInMapping.getOrDefault(node.getNodeKey(), Collections.emptyList());
        if (!CollectionUtils.isEmpty(linkInNodes)) {
            throw exceptionBuilder.get();
        }
    }

    private void handleEdgeTarget(Map<String, List<JSONObject>> edgeMap, FlowModelNodeVo node, Map<String, List<String>> linkInMapping) {
        if (edgeMap.containsKey(node.getNodeKey())) {
            ArrayList<FlowModelLineVo> targetLine = new ArrayList<FlowModelLineVo>();
            HashSet<String> targetIds = new HashSet<String>();
            for (JSONObject edge : edgeMap.get(node.getNodeKey())) {
                FlowModelLineVo lineVo = this.buildFlowModelLineVo(node, edge, targetIds);
                targetLine.add(lineVo);
                List linkInNodeKeys = linkInMapping.computeIfAbsent(lineVo.getLineTargetKey(), key -> new ArrayList());
                linkInNodeKeys.add(node.getNodeKey());
            }
            node.setTargetLines(targetLine);
            if (targetLine.size() > 1 && !node.getNodeType().allowMultiOut()) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_MULTI_OUT_LINE, new Object[]{StringUtils.defaultString((String)node.getNodeName()) + "(" + node.getNodeKey() + ")"});
            }
        }
        if (CollectionUtils.isEmpty((Collection)node.getTargetLines()) && !FlowModelNodeType.END.equals((Object)node.getNodeType())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_NODE_NO_OUT_LINE, new Object[]{StringUtils.defaultString((String)node.getNodeName()) + "(" + node.getNodeKey() + ")"});
        }
    }

    private FlowModelLineVo buildFlowModelLineVo(FlowModelNodeVo node, JSONObject edge, Set<String> targetIds) {
        FlowModelLineVo lineVo = new FlowModelLineVo();
        lineVo.setLineKey(edge.getString("id"));
        if (edge.containsKey((Object)"labels")) {
            lineVo.setLineName(edge.getJSONArray("labels").getJSONObject(0).getJSONObject("attrs").getJSONObject("label").getString("text"));
        }
        lineVo.setLineTargetKey(edge.getJSONObject("target").getString("cell"));
        if (node.getNodeKey().equals(lineVo.getLineTargetKey())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_LINK_SELF, new Object[]{StringUtils.defaultString((String)node.getNodeName()) + "(" + node.getNodeKey() + ")"});
        }
        if (targetIds.contains(lineVo.getLineTargetKey())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_MULTI_LINE, new Object[]{StringUtils.defaultString((String)node.getNodeName()) + "(" + node.getNodeKey() + ")", lineVo.getLineTargetKey()});
        }
        targetIds.add(lineVo.getLineTargetKey());
        return lineVo;
    }

    private void validateNodesVo(FlowModelNodesVo nodesVo) {
        FlowModelNodeVo startNode = nodesVo.getStartNode();
        if (startNode == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_CONTENT_NO_START);
        }
        if (CollectionUtils.isEmpty((Collection)nodesVo.getEndNodes())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_CONTENT_NO_END);
        }
        this.validateNotLinkToStart(nodesVo.getApprovalNodes(), startNode);
        this.validateNotLinkToStart(nodesVo.getGatewayNodes(), startNode);
        this.validateNotLinkToStart(nodesVo.getManualNodes(), startNode);
        this.validateNotLinkToStart(nodesVo.getReceiveNodes(), startNode);
        this.validateNotLinkToStart(nodesVo.getScriptNodes(), startNode);
        this.validateNotLinkToStart(nodesVo.getServiceNodes(), startNode);
        this.validateParallelGatewayCross(nodesVo);
    }

    private void validateParallelGatewayCross(FlowModelNodesVo nodesVo) {
        if (nodesVo.getGatewayNodes() == null) {
            return;
        }
        List<FlowModelNodeVo> gateways = nodesVo.getGatewayNodes().stream().filter(node -> node.getNodeType().equals((Object)FlowModelNodeType.PARALLEL_GATEWAY)).collect(Collectors.toList());
        if (gateways.isEmpty()) {
            return;
        }
        HashMap<String, FlowModelNodeVo> nodeMap = new HashMap<String, FlowModelNodeVo>(16);
        nodeMap.put(nodesVo.getStartNode().getNodeKey(), nodesVo.getStartNode());
        nodesVo.getEndNodes().forEach(node -> nodeMap.put(node.getNodeKey(), (FlowModelNodeVo)node));
        nodesVo.getApprovalNodes().forEach(node -> nodeMap.put(node.getNodeKey(), (FlowModelNodeVo)node));
        nodesVo.getGatewayNodes().forEach(node -> nodeMap.put(node.getNodeKey(), (FlowModelNodeVo)node));
        nodesVo.getManualNodes().forEach(node -> nodeMap.put(node.getNodeKey(), (FlowModelNodeVo)node));
        nodesVo.getReceiveNodes().forEach(node -> nodeMap.put(node.getNodeKey(), (FlowModelNodeVo)node));
        nodesVo.getScriptNodes().forEach(node -> nodeMap.put(node.getNodeKey(), (FlowModelNodeVo)node));
        nodesVo.getServiceNodes().forEach(node -> nodeMap.put(node.getNodeKey(), (FlowModelNodeVo)node));
        ArrayList existedLines = new ArrayList();
        gateways.forEach(gateway -> {
            if (gateway.getTargetLines() == null || gateway.getTargetLines().size() < 2) {
                return;
            }
            gateway.getTargetLines().forEach(line -> {
                HashSet<String> existedNodes = new HashSet<String>();
                Pair pair = Pair.of((Object)gateway, existedNodes);
                this.addNextLineNode((FlowModelLineVo)line, (Set<String>)existedNodes, nodeMap);
                existedLines.forEach(existedPair -> {
                    Optional<String> crossNodeKey = ((Set)existedPair.getValue()).stream().filter(existedNodes::contains).findAny();
                    if (crossNodeKey.isPresent()) {
                        FlowModelNodeVo existedGateway = (FlowModelNodeVo)existedPair.getKey();
                        FlowModelNodeVo crossNode = (FlowModelNodeVo)nodeMap.get(crossNodeKey.get());
                        throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_PARALLEL_GATEWAY_CROSS, new Object[]{StringUtils.defaultString((String)gateway.getNodeName()) + "(" + gateway.getNodeKey() + ")", StringUtils.defaultString((String)existedGateway.getNodeName()) + "(" + existedGateway.getNodeKey() + ")", StringUtils.defaultString((String)crossNode.getNodeName()) + "(" + crossNode.getNodeKey() + ")"});
                    }
                });
                existedLines.add(pair);
            });
        });
    }

    private void addNextLineNode(FlowModelLineVo line, Set<String> existedNodes, Map<String, FlowModelNodeVo> nodeMap) {
        String targetKey = line.getLineTargetKey();
        if (existedNodes.contains(targetKey) || !nodeMap.containsKey(targetKey)) {
            return;
        }
        FlowModelNodeVo targetNode = nodeMap.get(targetKey);
        if (FlowModelNodeType.PARALLEL_GATEWAY.equals((Object)targetNode.getNodeType())) {
            return;
        }
        existedNodes.add(targetKey);
        if (targetNode.getTargetLines() == null) {
            return;
        }
        targetNode.getTargetLines().forEach(targetLine -> this.addNextLineNode((FlowModelLineVo)targetLine, existedNodes, nodeMap));
    }

    private void validateNotLinkToStart(List<FlowModelNodeVo> approvalNodes, FlowModelNodeVo startNode) {
        approvalNodes.forEach(node -> {
            if (node.getTargetLines() == null) {
                return;
            }
            node.getTargetLines().forEach(line -> {
                if (line.getLineTargetKey().equals(startNode.getNodeKey())) {
                    throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_LINK_TO_START, new Object[]{StringUtils.defaultString((String)node.getNodeName()) + "(" + node.getNodeKey() + ")"});
                }
            });
        });
    }

    public List<FlowModel> listByIds(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.flowModelRepository.findByIdIn(ids);
    }

    public FlowModel getLastVersionByCodeName(String codeName) {
        FlowModelQuery flowModelQuery = new FlowModelQuery(codeName);
        PageParam pageParam = new PageParam();
        pageParam.setCurrent(0);
        pageParam.setPageSize(1);
        List<FlowModel> flowModels = this.flowModelRepository.search(flowModelQuery, pageParam);
        return CollectionUtils.isEmpty(flowModels) ? null : flowModels.get(0);
    }
}

