/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.node.service;

import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.domain.node.entity.FlowNode;
import com.cyberway.mp.flow.domain.node.repository.FlowNodeRepository;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class FlowNodeService {
    private final FlowNodeRepository flowNodeRepository;

    public FlowNodeService(FlowNodeRepository flowNodeRepository) {
        this.flowNodeRepository = flowNodeRepository;
    }

    public void createFlowNode(FlowNode flowNode) {
        this.flowNodeRepository.save((Object)flowNode);
    }

    public void updateNodeFin(long id, FlowTaskStatus status, Date endTime) {
        FlowNode flowNode = new FlowNode();
        flowNode.setId(Long.valueOf(id));
        flowNode.setStatus(status);
        flowNode.setEndTime(endTime);
        this.flowNodeRepository.updateById((Object)flowNode, id);
    }

    public void updateNodeFinAndRejected(long id, FlowTaskStatus status, Date endTime) {
        FlowNode flowNode = new FlowNode();
        flowNode.setId(Long.valueOf(id));
        flowNode.setStatus(status);
        flowNode.setEndTime(endTime);
        flowNode.setRejected(true);
        this.flowNodeRepository.updateById((Object)flowNode, id);
    }

    public FlowNode getFlowNode(long id) {
        return (FlowNode)((Object)this.flowNodeRepository.findOne(id));
    }

    public void updateNodeFinAllRunning(long flowInstanceId, FlowTaskStatus status, Date endTime) {
        this.flowNodeRepository.updateNodeFinAllRunning(flowInstanceId, status, endTime);
    }

    public List<FlowNode> listByFlowInstanceId(long flowInstanceId) {
        return this.flowNodeRepository.findByFlowInstanceIdOrderByStartTimeDesc(flowInstanceId);
    }

    public List<FlowNode> listByFlowInstanceIdAsc(long flowInstanceId) {
        return this.flowNodeRepository.findByFlowInstanceIdOrderByStartTimeAsc(flowInstanceId);
    }

    public FlowNode findOne(Long id) {
        return (FlowNode)((Object)this.flowNodeRepository.findOne(id));
    }

    public List<String> listRunningNodes(long flowInstanceId) {
        return this.flowNodeRepository.listRunningNodes(flowInstanceId);
    }

    public List<FlowNode> listRunningNodesForInstances(Collection<Long> flowInstanceIds) {
        return this.flowNodeRepository.findByFlowInstanceIdInAndStatusIn(flowInstanceIds, List.of(FlowTaskStatus.RUNNING, FlowTaskStatus.SUSPENDED, FlowTaskStatus.WAIT_STARTER_FILL, FlowTaskStatus.WAIT_STARTER_FILL_SAME_NODE));
    }

    public void markNodeRejected(long flowInstanceId, String targetNodeKey, Set<String> parallelLine) {
        Long rejectNodeLastId;
        Long l = rejectNodeLastId = targetNodeKey == null ? null : this.flowNodeRepository.findRejectNodeLastId(flowInstanceId, targetNodeKey);
        if (rejectNodeLastId == null) {
            this.flowNodeRepository.markRejected(flowInstanceId);
        } else if (parallelLine != null) {
            this.flowNodeRepository.markRejectedParallel(flowInstanceId, rejectNodeLastId, parallelLine);
        } else {
            this.flowNodeRepository.markRejectedFromId(flowInstanceId, rejectNodeLastId);
        }
    }

    public List<FlowNode> listForRollbackPrev(long flowInstanceId) {
        return this.flowNodeRepository.listForRollbackPrev(flowInstanceId);
    }

    public void updateNodeStatus(long id, FlowTaskStatus status) {
        FlowNode flowNode = new FlowNode();
        flowNode.setId(Long.valueOf(id));
        flowNode.setStatus(status);
        this.flowNodeRepository.updateById((Object)flowNode, id);
    }
}

