/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.opinion.service;

import com.cyberway.mp.bc.common.utils.BeanUtils;
import com.cyberway.mp.flow.api.opinion.dto.OpinionAssociationCreateDto;
import com.cyberway.mp.flow.domain.opinion.entity.OpinionAssociation;
import com.cyberway.mp.flow.domain.opinion.repository.OpinionAssociationRepository;
import java.util.List;

public class OpinionAssociationService {
    private final OpinionAssociationRepository opinionAssociationRepository;

    public OpinionAssociationService(OpinionAssociationRepository opinionAssociationRepository) {
        this.opinionAssociationRepository = opinionAssociationRepository;
    }

    public void createOpinionAssociation(OpinionAssociation opinionAssociation) {
        this.opinionAssociationRepository.save((Object)opinionAssociation);
    }

    public void modifyOpinionAssociation(OpinionAssociation opinionAssociation) {
        this.opinionAssociationRepository.updateById((Object)opinionAssociation, (Long)opinionAssociation.getId());
    }

    public List<OpinionAssociation> getOpinionAssociation(long id) {
        return this.opinionAssociationRepository.findByOpinionPoolIdOrderByDisplayOrderDesc(id);
    }

    public void deleteOpinionAssociation(long id) {
        this.opinionAssociationRepository.deleteByOpinionPoolId(id);
    }

    public void batchSaveOpinions(Long id, List<OpinionAssociationCreateDto> opinionDtoList) {
        for (OpinionAssociationCreateDto opinionDto : opinionDtoList) {
            OpinionAssociation opinionAssociation = new OpinionAssociation();
            BeanUtils.copyProperties((Object)((Object)opinionAssociation), (Object)opinionDto);
            opinionAssociation.setOpinionPoolId(id);
            this.opinionAssociationRepository.save((Object)opinionAssociation);
        }
    }

    public void batchModifyOpinions(Long id, List<OpinionAssociationCreateDto> opinionDtoList) {
        this.opinionAssociationRepository.deleteByOpinionPoolId(id);
        this.batchSaveOpinions(id, opinionDtoList);
    }

    public void deleteOpinion(long id) {
        this.opinionAssociationRepository.delete(id);
    }

    public OpinionAssociation getOpinionSelf(long id) {
        return (OpinionAssociation)((Object)this.opinionAssociationRepository.findOne(id));
    }

    public List<OpinionAssociation> findByUserIdOrderByDisplayOrderDesc(Long userId) {
        return this.opinionAssociationRepository.findByUserIdOrderByDisplayOrderDesc(userId);
    }
}

