/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.project.entity;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.model.vo.FlowModelNodesVo;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectBundleCreateDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectCreateBaseDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectCreateDto;
import com.cyberway.mp.flow.api.project.dto.NodesConfigDto;
import com.cyberway.mp.flow.api.project.dto.VariableDefineDto;
import com.cyberway.mp.flow.api.project.enums.FlowProjectStatus;
import com.cyberway.mp.flow.api.project.enums.FormType;
import com.cyberway.mp.flow.api.project.enums.TaskExecuteType;
import com.cyberway.mp.flow.api.project.vo.FlowProjectFullInfoVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectSimpleInfoVo;
import com.cyberway.mp.flow.api.project.vo.FlowProjectStatusInfoVo;
import com.cyberway.mp.flow.domain.model.entity.FlowModelWithCategoryName;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import java.util.Collections;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@Table(name="fc_flow_project")
public class FlowProject
extends BusinessEntityWithAppInstance {
    private String codeName;
    private String name;
    private Long flowModelId;
    private FormType formType;
    private String formEntityCode;
    private String formSubEntityCodes;
    private String formUrl;
    private String formName;
    private String editFormUrl;
    private String editFormName;
    private FormType editFormType;
    private String variableConfigs;
    private String nodeConfigs;
    private String definitionId;
    private String description;
    private Integer versionNo;
    private Long baseProjectId;
    private Long firstVersionId;
    private FlowProjectStatus status;

    public FormType getEditFormType() {
        return this.editFormType;
    }

    public void setEditFormType(FormType editFormType) {
        this.editFormType = editFormType;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getFlowModelId() {
        return this.flowModelId;
    }

    public void setFlowModelId(Long flowModelId) {
        this.flowModelId = flowModelId;
    }

    public FormType getFormType() {
        return this.formType;
    }

    public void setFormType(FormType formType) {
        this.formType = formType;
    }

    public String getFormEntityCode() {
        return this.formEntityCode;
    }

    public void setFormEntityCode(String formEntityCode) {
        this.formEntityCode = formEntityCode;
    }

    public String getFormSubEntityCodes() {
        return this.formSubEntityCodes;
    }

    public void setFormSubEntityCodes(String formSubEntityCodes) {
        this.formSubEntityCodes = formSubEntityCodes;
    }

    public String getFormUrl() {
        return this.formUrl;
    }

    public void setFormUrl(String formUrl) {
        this.formUrl = formUrl;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getEditFormUrl() {
        return this.editFormUrl;
    }

    public void setEditFormUrl(String editFormUrl) {
        this.editFormUrl = editFormUrl;
    }

    public String getEditFormName() {
        return this.editFormName;
    }

    public void setEditFormName(String editFormName) {
        this.editFormName = editFormName;
    }

    public String getVariableConfigs() {
        return this.variableConfigs;
    }

    public void setVariableConfigs(String variableConfigs) {
        this.variableConfigs = variableConfigs;
    }

    public String getNodeConfigs() {
        return this.nodeConfigs;
    }

    public void setNodeConfigs(String nodeConfigs) {
        this.nodeConfigs = nodeConfigs;
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getVersionNo() {
        return this.versionNo;
    }

    public void setVersionNo(Integer versionNo) {
        this.versionNo = versionNo;
    }

    public Long getBaseProjectId() {
        return this.baseProjectId;
    }

    public void setBaseProjectId(Long baseProjectId) {
        this.baseProjectId = baseProjectId;
    }

    public Long getFirstVersionId() {
        return this.firstVersionId;
    }

    public void setFirstVersionId(Long firstVersionId) {
        this.firstVersionId = firstVersionId;
    }

    public FlowProjectStatus getStatus() {
        return this.status;
    }

    public void setStatus(FlowProjectStatus status) {
        this.status = status;
    }

    private static void fixNodeConfigs(FlowProjectCreateBaseDto dto) {
        if (dto.getNodeConfigs() != null && dto.getNodeConfigs().getApprovalNodes() != null) {
            for (ApprovalNodeConfigDto approvalNode : dto.getNodeConfigs().getApprovalNodes()) {
                if (!FlowConstant.SIGN_TYPE_SINGER_SIGN.equals(approvalNode.getSignType())) continue;
                approvalNode.setTaskExecuteType(TaskExecuteType.PARALLEL);
            }
        }
    }

    public static FlowProject fromFlowProjectCreateDto(FlowProjectCreateDto dto) {
        FlowProject flowProject = new FlowProject();
        flowProject.initByFlowProjectCreateBaseDto((FlowProjectCreateBaseDto)dto);
        flowProject.setFlowModelId(dto.getFlowModelId());
        return flowProject;
    }

    public static FlowProject fromFlowProjectBundleCreateDto(FlowProjectBundleCreateDto dto) {
        FlowProject flowProject = new FlowProject();
        flowProject.initByFlowProjectCreateBaseDto((FlowProjectCreateBaseDto)dto);
        return flowProject;
    }

    public void updateByFlowProjectCreateBaseDto(FlowProjectCreateBaseDto dto) {
        FlowProject.fixNodeConfigs(dto);
        this.setCodeName(dto.getCodeName());
        this.setName(dto.getName());
        this.setFormType(dto.getFormType());
        this.setFormEntityCode(dto.getFormEntityCode());
        this.setFormUrl(dto.getFormUrl());
        this.setFormName(dto.getFormName());
        this.setEditFormUrl(dto.getEditFormUrl());
        this.setEditFormName(dto.getEditFormName());
        this.setVariableConfigs(JSON.toJSONString((Object)ObjectUtils.defaultIfNull((Object)dto.getVariableConfigs(), Collections.emptyList())));
        this.setNodeConfigs(JSON.toJSONString((Object)ObjectUtils.defaultIfNull((Object)dto.getNodeConfigs(), Collections.emptyList())));
        this.setDescription(dto.getDescription());
        if (dto.getFormSubEntityCodes() != null) {
            this.setFormSubEntityCodes(JSON.toJSONString((Object)dto.getFormSubEntityCodes()));
        }
    }

    private void initByFlowProjectCreateBaseDto(FlowProjectCreateBaseDto dto) {
        this.updateByFlowProjectCreateBaseDto(dto);
        this.setStatus(FlowProjectStatus.DRAFT);
        this.setVersionNo(FlowConstant.EMPTY_VERSION_VALUE);
    }

    public static FlowProject fromOldVersion(FlowProject old) {
        FlowProject flowProject = new FlowProject();
        flowProject.setCodeName(old.getCodeName());
        flowProject.setName(old.getName());
        flowProject.setFlowModelId(old.getFlowModelId());
        flowProject.setFormType(old.getFormType());
        flowProject.setFormEntityCode(old.getFormEntityCode());
        flowProject.setFormSubEntityCodes(old.getFormSubEntityCodes());
        flowProject.setFormUrl(old.getFormUrl());
        flowProject.setFormName(old.getFormName());
        flowProject.setEditFormUrl(old.getEditFormUrl());
        flowProject.setEditFormName(old.getEditFormName());
        flowProject.setVariableConfigs(old.getVariableConfigs());
        flowProject.setNodeConfigs(old.getNodeConfigs());
        flowProject.setDescription(old.getDescription());
        flowProject.setVersionNo(FlowConstant.EMPTY_VERSION_VALUE);
        flowProject.setBaseProjectId((Long)old.getId());
        flowProject.setFirstVersionId(old.getFirstVersionId());
        flowProject.setStatus(FlowProjectStatus.DRAFT);
        flowProject.setAppInstanceId(old.getAppInstanceId());
        flowProject.setBusinessZoneId(old.getBusinessZoneId());
        flowProject.setTenantId(old.getTenantId());
        return flowProject;
    }

    public void update(FlowProjectCreateDto dto) {
        this.updateByFlowProjectCreateBaseDto((FlowProjectCreateBaseDto)dto);
        this.setFlowModelId(dto.getFlowModelId());
    }

    public FlowProjectStatusInfoVo toFlowProjectStatusInfoVo() {
        FlowProjectStatusInfoVo flowProjectStatusInfoVo = new FlowProjectStatusInfoVo();
        flowProjectStatusInfoVo.setId((Long)this.getId());
        flowProjectStatusInfoVo.setVersionNo(CodeUtils.formatNullableVersionNo(this.getVersionNo()));
        flowProjectStatusInfoVo.setStatus(this.getStatus());
        return flowProjectStatusInfoVo;
    }

    public FlowProjectSimpleInfoVo toFlowProjectSimpleInfoVo() {
        FlowProjectFullInfoVo vo = new FlowProjectFullInfoVo();
        this.initFlowProjectSimpleInfoVo((FlowProjectSimpleInfoVo)vo);
        return vo;
    }

    private void initFlowProjectSimpleInfoVo(FlowProjectSimpleInfoVo vo) {
        vo.setId((Long)this.getId());
        vo.setCodeName(this.getCodeName());
        vo.setName(this.getName());
        vo.setDescription(this.getDescription());
        vo.setFormType(this.getFormType());
        vo.setFormEntityCode(this.getFormEntityCode());
        vo.setFormSubEntityCodes(StringUtils.isBlank((CharSequence)this.getFormSubEntityCodes()) ? Collections.emptyList() : JSON.parseArray((String)this.getFormSubEntityCodes(), String.class));
        vo.setFormUrl(this.getFormUrl());
        vo.setFormName(this.getFormName());
        vo.setEditFormUrl(this.getEditFormUrl());
        vo.setEditFormName(this.getEditFormName());
        vo.setVersionNo(CodeUtils.formatNullableVersionNo(this.getVersionNo()));
        vo.setStatus(this.getStatus());
    }

    public FlowProjectFullInfoVo toFlowProjectFullInfoVo(FlowModelWithCategoryName flowModel) {
        FlowProjectFullInfoVo flowProjectFullInfoVo = new FlowProjectFullInfoVo();
        this.initFlowProjectSimpleInfoVo((FlowProjectSimpleInfoVo)flowProjectFullInfoVo);
        flowProjectFullInfoVo.setFlowModel(flowModel.toFlowModelListVo());
        flowProjectFullInfoVo.setFlowModelNodes((FlowModelNodesVo)JSON.parseObject((String)flowModel.getModelNodes(), FlowModelNodesVo.class));
        flowProjectFullInfoVo.setDesignContent(flowModel.getDesignContent());
        flowProjectFullInfoVo.setVariableConfigs(JSON.parseArray((String)this.getVariableConfigs(), VariableDefineDto.class));
        flowProjectFullInfoVo.setNodeConfigs((NodesConfigDto)JSON.parseObject((String)this.getNodeConfigs(), NodesConfigDto.class));
        flowProjectFullInfoVo.setAllowChangeCode(Boolean.valueOf(CodeUtils.isEmptyId(this.getFirstVersionId())));
        return flowProjectFullInfoVo;
    }
}

