/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.project.entity;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.flow.api.model.enums.FlowModelNodeType;
import com.cyberway.mp.flow.api.model.vo.FlowModelNodeVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelNodesVo;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.BaseNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GatewayNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.project.dto.ManualNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.NodesConfigDto;
import com.cyberway.mp.flow.api.project.dto.ReceiveNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.ScriptNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.ServiceNodeConfigDto;
import com.cyberway.mp.flow.api.project.enums.FormType;
import com.cyberway.mp.flow.domain.model.entity.FlowModel;
import com.cyberway.mp.flow.domain.project.entity.FlowProject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FlowProjectConfig {
    private String processDefinitionId;
    private FormType formType;
    private String formUrl;
    private String editFormUrl;
    private FormType editFormType;
    private Map<String, FlowModelNodeType> nodeTypeMap = new HashMap<String, FlowModelNodeType>();
    private Map<String, String> nodeNameMap = new HashMap<String, String>();
    private GlobalConfigDto globalConfig;
    private Map<String, ApprovalNodeConfigDto> approvalNodeConfigMap = new HashMap<String, ApprovalNodeConfigDto>();
    private Map<String, GatewayNodeConfigDto> gatewayNodeConfigMap = new HashMap<String, GatewayNodeConfigDto>();
    private Map<String, ManualNodeConfigDto> manualNodeConfigMap = new HashMap<String, ManualNodeConfigDto>();
    private Map<String, ReceiveNodeConfigDto> receiveNodeConfigMap = new HashMap<String, ReceiveNodeConfigDto>();
    private Map<String, ScriptNodeConfigDto> scriptNodeConfigMap = new HashMap<String, ScriptNodeConfigDto>();
    private Map<String, ServiceNodeConfigDto> serviceNodeConfigMap = new HashMap<String, ServiceNodeConfigDto>();

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public FormType getFormType() {
        return this.formType;
    }

    public void setFormType(FormType formType) {
        this.formType = formType;
    }

    public String getFormUrl() {
        return this.formUrl;
    }

    public void setFormUrl(String formUrl) {
        this.formUrl = formUrl;
    }

    public String getEditFormUrl() {
        return this.editFormUrl;
    }

    public void setEditFormUrl(String editFormUrl) {
        this.editFormUrl = editFormUrl;
    }

    public Map<String, FlowModelNodeType> getNodeTypeMap() {
        return this.nodeTypeMap;
    }

    public void setNodeTypeMap(Map<String, FlowModelNodeType> nodeTypeMap) {
        this.nodeTypeMap = nodeTypeMap;
    }

    public Map<String, String> getNodeNameMap() {
        return this.nodeNameMap;
    }

    public void setNodeNameMap(Map<String, String> nodeNameMap) {
        this.nodeNameMap = nodeNameMap;
    }

    public GlobalConfigDto getGlobalConfig() {
        return this.globalConfig;
    }

    public void setGlobalConfig(GlobalConfigDto globalConfig) {
        this.globalConfig = globalConfig;
    }

    public Map<String, ApprovalNodeConfigDto> getApprovalNodeConfigMap() {
        return this.approvalNodeConfigMap;
    }

    public void setApprovalNodeConfigMap(Map<String, ApprovalNodeConfigDto> approvalNodeConfigMap) {
        this.approvalNodeConfigMap = approvalNodeConfigMap;
    }

    public Map<String, GatewayNodeConfigDto> getGatewayNodeConfigMap() {
        return this.gatewayNodeConfigMap;
    }

    public void setGatewayNodeConfigMap(Map<String, GatewayNodeConfigDto> gatewayNodeConfigMap) {
        this.gatewayNodeConfigMap = gatewayNodeConfigMap;
    }

    public Map<String, ManualNodeConfigDto> getManualNodeConfigMap() {
        return this.manualNodeConfigMap;
    }

    public void setManualNodeConfigMap(Map<String, ManualNodeConfigDto> manualNodeConfigMap) {
        this.manualNodeConfigMap = manualNodeConfigMap;
    }

    public Map<String, ReceiveNodeConfigDto> getReceiveNodeConfigMap() {
        return this.receiveNodeConfigMap;
    }

    public void setReceiveNodeConfigMap(Map<String, ReceiveNodeConfigDto> receiveNodeConfigMap) {
        this.receiveNodeConfigMap = receiveNodeConfigMap;
    }

    public Map<String, ScriptNodeConfigDto> getScriptNodeConfigMap() {
        return this.scriptNodeConfigMap;
    }

    public void setScriptNodeConfigMap(Map<String, ScriptNodeConfigDto> scriptNodeConfigMap) {
        this.scriptNodeConfigMap = scriptNodeConfigMap;
    }

    public Map<String, ServiceNodeConfigDto> getServiceNodeConfigMap() {
        return this.serviceNodeConfigMap;
    }

    public void setServiceNodeConfigMap(Map<String, ServiceNodeConfigDto> serviceNodeConfigMap) {
        this.serviceNodeConfigMap = serviceNodeConfigMap;
    }

    public static FlowProjectConfig fromFlowProject(FlowProject flowProject, FlowModel flowModel) {
        FlowProjectConfig flowProjectConfig = new FlowProjectConfig();
        flowProjectConfig.setProcessDefinitionId(flowProject.getDefinitionId());
        flowProjectConfig.setFormUrl(StringUtils.defaultString((String)flowProject.getFormUrl()));
        flowProjectConfig.setEditFormUrl(StringUtils.defaultString((String)flowProject.getEditFormUrl()));
        flowProjectConfig.setFormType(flowProject.getFormType());
        flowProjectConfig.setEditFormType(flowProject.getEditFormType());
        FlowModelNodesVo nodesVo = (FlowModelNodesVo)JSON.parseObject((String)flowModel.getModelNodes(), FlowModelNodesVo.class);
        flowProjectConfig.initNodeTypeMap(nodesVo.getApprovalNodes());
        flowProjectConfig.initNodeTypeMap(nodesVo.getGatewayNodes());
        flowProjectConfig.initNodeTypeMap(nodesVo.getManualNodes());
        flowProjectConfig.initNodeTypeMap(nodesVo.getReceiveNodes());
        flowProjectConfig.initNodeTypeMap(nodesVo.getScriptNodes());
        flowProjectConfig.initNodeTypeMap(nodesVo.getServiceNodes());
        flowProjectConfig.initNodeTypeMap(nodesVo.getEndNodes());
        flowProjectConfig.getNodeTypeMap().put(nodesVo.getStartNode().getNodeKey(), nodesVo.getStartNode().getNodeType());
        flowProjectConfig.getNodeNameMap().put(nodesVo.getStartNode().getNodeKey(), nodesVo.getStartNode().getNodeName());
        NodesConfigDto nodesConfig = (NodesConfigDto)JSON.parseObject((String)flowProject.getNodeConfigs(), NodesConfigDto.class);
        flowProjectConfig.setGlobalConfig(nodesConfig.getGlobal());
        flowProjectConfig.setApprovalNodeConfigMap(nodesConfig.getApprovalNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, d -> d)));
        flowProjectConfig.setGatewayNodeConfigMap(nodesConfig.getGatewayNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, d -> d)));
        flowProjectConfig.setManualNodeConfigMap(nodesConfig.getManualNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, d -> d)));
        flowProjectConfig.setReceiveNodeConfigMap(nodesConfig.getReceiveNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, d -> d)));
        flowProjectConfig.setScriptNodeConfigMap(nodesConfig.getScriptNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, d -> d)));
        flowProjectConfig.setServiceNodeConfigMap(nodesConfig.getServiceNodes().stream().collect(Collectors.toMap(ServiceNodeConfigDto::getNodeKey, d -> d)));
        return flowProjectConfig;
    }

    private void initNodeTypeMap(List<FlowModelNodeVo> nodeVos) {
        for (FlowModelNodeVo nodeVo : nodeVos) {
            this.nodeTypeMap.put(nodeVo.getNodeKey(), nodeVo.getNodeType());
            this.nodeNameMap.put(nodeVo.getNodeKey(), nodeVo.getNodeName());
        }
    }

    public FormType getEditFormType() {
        return this.editFormType;
    }

    public void setEditFormType(FormType editFormType) {
        this.editFormType = editFormType;
    }
}

