/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.project.repository;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GatewayNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.project.dto.ServiceNodeConfigDto;
import com.cyberway.mp.flow.api.project.enums.TaskExecuteType;
import com.cyberway.mp.flow.api.task.enums.FlowTaskType;
import com.cyberway.mp.flow.api.task.vo.StarterFillTaskCustomInfoVo;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstanceAddNode;
import com.cyberway.mp.flow.domain.instance.repository.FlowInstanceAddNodeRepository;
import com.cyberway.mp.flow.domain.model.entity.FlowModel;
import com.cyberway.mp.flow.domain.model.repository.FlowModelRepository;
import com.cyberway.mp.flow.domain.project.entity.FlowProject;
import com.cyberway.mp.flow.domain.project.entity.FlowProjectConfig;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectRepository;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithBusinessKey;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlowProjectConfigCacheRepository {
    private final Map<Long, FlowProjectConfig> flowProjectConfigMap = new LinkedHashMap<Long, FlowProjectConfig>();
    private final FlowProjectRepository flowProjectRepository;
    private final FlowInstanceAddNodeRepository flowInstanceAddNodeRepository;
    private final FlowModelRepository flowModelRepository;

    public FlowProjectConfigCacheRepository(FlowProjectRepository flowProjectRepository, FlowInstanceAddNodeRepository flowInstanceAddNodeRepository, FlowModelRepository flowModelRepository) {
        this.flowProjectRepository = flowProjectRepository;
        this.flowInstanceAddNodeRepository = flowInstanceAddNodeRepository;
        this.flowModelRepository = flowModelRepository;
    }

    public GlobalConfigDto getGlobalConfig(long projectId) {
        if (!this.flowProjectConfigMap.containsKey(projectId)) {
            this.initFlowProjectConfig(projectId);
        }
        return this.flowProjectConfigMap.get(projectId).getGlobalConfig();
    }

    public GatewayNodeConfigDto getGatewayNodeConfig(long projectId, String nodeKey) {
        if (!this.flowProjectConfigMap.containsKey(projectId)) {
            this.initFlowProjectConfig(projectId);
        }
        return this.flowProjectConfigMap.get(projectId).getGatewayNodeConfigMap().get(nodeKey);
    }

    public ApprovalNodeConfigDto getApprovalNodeConfig(long projectId, String nodeKey) {
        if (!this.flowProjectConfigMap.containsKey(projectId)) {
            this.initFlowProjectConfig(projectId);
        }
        return this.flowProjectConfigMap.get(projectId).getApprovalNodeConfigMap().get(nodeKey);
    }

    public ApprovalNodeConfigDto getApprovalNodeConfig(FlowTaskWithProject flowTask) {
        return this.getApprovalNodeConfig(flowTask, flowTask.getFlowProjectId());
    }

    public ApprovalNodeConfigDto getApprovalNodeConfig(FlowTaskWithBusinessKey flowTask) {
        return this.getApprovalNodeConfig(flowTask, flowTask.getFlowProjectId());
    }

    public ApprovalNodeConfigDto getApprovalNodeConfig(FlowTask flowTask, Long flowProjectId) {
        if (FlowTaskType.STARTER_FILL.equals((Object)flowTask.getTaskType())) {
            StarterFillTaskCustomInfoVo customInfoVo = (StarterFillTaskCustomInfoVo)JSON.parseObject((String)flowTask.getCustomTaskInfo(), StarterFillTaskCustomInfoVo.class);
            ApprovalNodeConfigDto actionNodeConfig = this.getApprovalNodeConfig(flowProjectId, customInfoVo.getActionNodeKey());
            ApprovalNodeConfigDto dto = new ApprovalNodeConfigDto();
            dto.setAssigneeApprove(Boolean.valueOf(true));
            dto.setAssigneeCancel(customInfoVo.getAssigneeCancel());
            dto.setSignType(FlowConstant.SIGN_TYPE_NORMAL);
            dto.setTaskExecuteType(TaskExecuteType.PARALLEL);
            dto.setFormFieldConfigs(actionNodeConfig.getStarterFillFormFieldConfigs());
            dto.setSubFormFieldConfigs(actionNodeConfig.getStarterFillSubFormFieldConfigs());
            return dto;
        }
        return this.getApprovalNodeConfig(flowProjectId, flowTask.getFlowInstanceId(), flowTask.getNodeKey());
    }

    public ApprovalNodeConfigDto getApprovalNodeConfig(long projectId, long flowInstanceId, String nodeKey) {
        ApprovalNodeConfigDto approvalNodeConfig = this.getApprovalNodeConfig(projectId, nodeKey);
        if (approvalNodeConfig == null && nodeKey.startsWith("dynamicTask")) {
            List<FlowInstanceAddNode> addNodes = this.flowInstanceAddNodeRepository.findByFlowInstanceIdAndNodeKey(flowInstanceId, nodeKey);
            if (addNodes.isEmpty()) {
                return null;
            }
            return (ApprovalNodeConfigDto)JSON.parseObject((String)addNodes.get(0).getApproveNodeConfig(), ApprovalNodeConfigDto.class);
        }
        return approvalNodeConfig;
    }

    public FlowProjectConfig getProjectConfig(long projectId) {
        if (!this.flowProjectConfigMap.containsKey(projectId)) {
            this.initFlowProjectConfig(projectId);
        }
        return this.flowProjectConfigMap.get(projectId);
    }

    public ServiceNodeConfigDto getServiceNodeConfig(long projectId, String nodeKey) {
        if (!this.flowProjectConfigMap.containsKey(projectId)) {
            this.initFlowProjectConfig(projectId);
        }
        return this.flowProjectConfigMap.get(projectId).getServiceNodeConfigMap().get(nodeKey);
    }

    private synchronized void initFlowProjectConfig(long projectId) {
        FlowProject flowProject = this.flowProjectRepository.getFlowProjectIgnoreTenant(projectId);
        if (flowProject == null) {
            this.flowProjectConfigMap.put(projectId, new FlowProjectConfig());
        } else {
            FlowModel flowModel = this.flowModelRepository.getIgnoreTenant(flowProject.getFlowModelId());
            this.flowProjectConfigMap.put(projectId, FlowProjectConfig.fromFlowProject(flowProject, flowModel));
        }
    }

    public Set<String> getApprovalNodeKeys(long projectId) {
        if (!this.flowProjectConfigMap.containsKey(projectId)) {
            this.initFlowProjectConfig(projectId);
        }
        return new HashSet<String>(this.flowProjectConfigMap.get(projectId).getApprovalNodeConfigMap().keySet());
    }

    public String getProcessDefinitionId(long projectId) {
        if (!this.flowProjectConfigMap.containsKey(projectId)) {
            this.initFlowProjectConfig(projectId);
        }
        return this.flowProjectConfigMap.get(projectId).getProcessDefinitionId();
    }

    public String getNodeName(long projectId, String nodeKey) {
        if (!this.flowProjectConfigMap.containsKey(projectId)) {
            this.initFlowProjectConfig(projectId);
        }
        return this.flowProjectConfigMap.get(projectId).getNodeNameMap().get(nodeKey);
    }
}

