/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.project.repository.query;

import com.cyberway.mp.bc.common.api.OrderPageParam;
import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.dal.annotation.Join;
import com.cyberway.mp.bc.dal.annotation.Predicate;
import com.cyberway.mp.bc.dal.annotation.query.Contains;
import com.cyberway.mp.bc.dal.annotation.query.In;
import com.cyberway.mp.bc.dal.annotation.query.NotIn;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.project.dto.FlowProjectBundlePageDto;
import com.cyberway.mp.flow.api.project.dto.FlowProjectPageDto;
import com.cyberway.mp.flow.api.project.enums.FlowProjectStatus;
import com.cyberway.mp.flow.api.project.enums.FormType;
import java.util.Collection;
import java.util.List;

@Predicate(dynamic=true)
@Join(script="fc_flow_project p join fc_flow_model m on m.id=p.flow_model_id join fc_flow_category c on c.id=m.flow_category_id")
public class SimpleFlowProjectQuery {
    private static final OrderFragment DEFAULT_ORDER_FRAGMENT = new OrderFragment("p.created_time", "ASC");
    private static final String FIELD_FLOW_CATEGORY_NAME = "flowCategoryName";
    private static final String FIELD_FLOW_CATEGORY_ID = "flowCategoryId";
    @Alias(name="p.id")
    private Long id;
    @Contains
    @Alias(name="p.code_name")
    private String codeName;
    @Alias(name="p.code_name")
    private String codeNameEq;
    @In
    @Alias(name="p.code_name")
    private Collection<String> codeNameIn;
    @Contains
    @Alias(name="p.name")
    private String name;
    @Alias(name="p.status")
    private FlowProjectStatus status;
    @Alias(name="c.id")
    private Long flowCategoryId;
    @Alias(name="p.base_project_id")
    private Long baseProjectId;
    @Alias(name="p.first_version_id")
    private Long firstVersionId;
    @Alias(name="p.form_type")
    private FormType formType;
    @NotIn
    @Alias(name="p.form_type")
    private List<FormType> excludeFormTypes;
    @Alias(name="p.form_entity_code")
    private String formEntityCode;
    @OrderByField
    private OrderFragment orderFragment;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getCodeNameEq() {
        return this.codeNameEq;
    }

    public void setCodeNameEq(String codeNameEq) {
        this.codeNameEq = codeNameEq;
    }

    public Collection<String> getCodeNameIn() {
        return this.codeNameIn;
    }

    public void setCodeNameIn(Collection<String> codeNameIn) {
        this.codeNameIn = codeNameIn;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FlowProjectStatus getStatus() {
        return this.status;
    }

    public void setStatus(FlowProjectStatus status) {
        this.status = status;
    }

    public Long getFlowCategoryId() {
        return this.flowCategoryId;
    }

    public void setFlowCategoryId(Long flowCategoryId) {
        this.flowCategoryId = flowCategoryId;
    }

    public Long getFirstVersionId() {
        return this.firstVersionId;
    }

    public void setFirstVersionId(Long firstVersionId) {
        this.firstVersionId = firstVersionId;
    }

    public Long getBaseProjectId() {
        return this.baseProjectId;
    }

    public void setBaseProjectId(Long baseProjectId) {
        this.baseProjectId = baseProjectId;
    }

    public FormType getFormType() {
        return this.formType;
    }

    public void setFormType(FormType formType) {
        this.formType = formType;
    }

    public List<FormType> getExcludeFormTypes() {
        return this.excludeFormTypes;
    }

    public void setExcludeFormTypes(List<FormType> excludeFormTypes) {
        this.excludeFormTypes = excludeFormTypes;
    }

    public String getFormEntityCode() {
        return this.formEntityCode;
    }

    public void setFormEntityCode(String formEntityCode) {
        this.formEntityCode = formEntityCode;
    }

    public OrderFragment getOrderFragment() {
        return this.orderFragment;
    }

    public void setOrderFragment(OrderFragment orderFragment) {
        this.orderFragment = orderFragment;
    }

    public static SimpleFlowProjectQuery fromFlowProjectBundlePageDto(FlowProjectBundlePageDto dto) {
        SimpleFlowProjectQuery flowModelWithCategoryNameQuery = new SimpleFlowProjectQuery();
        flowModelWithCategoryNameQuery.initByFlowProjectBundlePageDto(dto);
        flowModelWithCategoryNameQuery.setBaseProjectId(FlowConstant.EMPTY_ID_VALUE);
        return flowModelWithCategoryNameQuery;
    }

    public static SimpleFlowProjectQuery fromFlowProjectPageDto(FlowProjectPageDto flowProjectPageDto) {
        SimpleFlowProjectQuery flowModelWithCategoryNameQuery = new SimpleFlowProjectQuery();
        flowModelWithCategoryNameQuery.initByFlowProjectBundlePageDto((FlowProjectBundlePageDto)flowProjectPageDto);
        flowModelWithCategoryNameQuery.setStatus(flowProjectPageDto.getStatus());
        return flowModelWithCategoryNameQuery;
    }

    private void initByFlowProjectBundlePageDto(FlowProjectBundlePageDto dto) {
        this.setCodeName(dto.getCodeName());
        this.setName(dto.getName());
        this.setFlowCategoryId(dto.getFlowCategoryId());
        this.setFormType(dto.getFormType());
        this.setExcludeFormTypes(dto.getExcludeFormTypes());
        this.setFormEntityCode(dto.getFormEntityCode());
        OrderFragment paramOrderFragment = OrderFragment.fromOrderPageParam((OrderPageParam)dto);
        if (paramOrderFragment == null) {
            this.setOrderFragment(DEFAULT_ORDER_FRAGMENT);
        } else {
            if (FIELD_FLOW_CATEGORY_NAME.equals(paramOrderFragment.getFieldName()) || FIELD_FLOW_CATEGORY_ID.equals(paramOrderFragment.getFieldName())) {
                paramOrderFragment.setFieldName("c." + paramOrderFragment.getFieldName().substring(12).toLowerCase());
            } else {
                paramOrderFragment.setFieldName("p." + Strings.underscoreName((String)paramOrderFragment.getFieldName()));
            }
            this.setOrderFragment(paramOrderFragment);
        }
    }
}

