/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.project.service;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.common.vo.IdNameVo;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.model.enums.FlowModelStatus;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.NodesConfigDto;
import com.cyberway.mp.flow.api.project.enums.FlowProjectStatus;
import com.cyberway.mp.flow.domain.condition.service.ConditionMatrixService;
import com.cyberway.mp.flow.domain.model.entity.FlowModel;
import com.cyberway.mp.flow.domain.model.service.FlowModelService;
import com.cyberway.mp.flow.domain.project.entity.FlowProject;
import com.cyberway.mp.flow.domain.project.entity.FlowProjectForStatus;
import com.cyberway.mp.flow.domain.project.entity.SimpleFlowProject;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectRepository;
import com.cyberway.mp.flow.domain.project.repository.query.FlowProjectQuery;
import com.cyberway.mp.flow.domain.project.repository.query.SimpleFlowProjectQuery;
import com.cyberway.mp.flow.infra.dto.DeployResult;
import com.cyberway.mp.flow.infra.service.FlowDefinitionGenerateService;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import io.seata.common.util.CollectionUtils;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FlowProjectService {
    private static final String IMAGE_BASE64_DATA_PREFIX = "data:";
    private static final String IMAGE_BASE64_TYPE_PREFIX = "image/";
    private final FlowProjectRepository flowProjectRepository;
    private final FlowModelService flowModelService;
    private final FlowDefinitionGenerateService flowDefinitionGenerateService;
    private final FlowEngineService flowEngineService;
    private final ConditionMatrixService conditionMatrixService;

    public FlowProjectService(FlowProjectRepository flowProjectRepository, FlowModelService flowModelService, FlowDefinitionGenerateService flowDefinitionGenerateService, FlowEngineService flowEngineService, ConditionMatrixService conditionMatrixService) {
        this.flowProjectRepository = flowProjectRepository;
        this.flowModelService = flowModelService;
        this.flowDefinitionGenerateService = flowDefinitionGenerateService;
        this.flowEngineService = flowEngineService;
        this.conditionMatrixService = conditionMatrixService;
    }

    public void createFlowProject(FlowProject flowProject, boolean forceCreate) {
        if (!forceCreate && CodeUtils.isEmptyId(flowProject.getBaseProjectId()) && this.checkCodeExisted(flowProject.getCodeName())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_CODE_ALREADY_EXISTED);
        }
        this.flowProjectRepository.save((Object)flowProject);
    }

    public boolean checkCodeExisted(String codeName) {
        return this.flowProjectRepository.countByCodeName(codeName) > 0L;
    }

    public boolean checkUsedModel(Long flowModelId) {
        return this.flowProjectRepository.countByFlowModelId(flowModelId) > 0L;
    }

    public FlowProject getFlowProject(long id) {
        return (FlowProject)((Object)this.flowProjectRepository.findOne(id));
    }

    public FlowProject getLastEnabledVersionFlowProject(String codeName) {
        PageParam pageParam = new PageParam();
        pageParam.setCurrent(0);
        pageParam.setPageSize(1);
        List<FlowProject> list = this.flowProjectRepository.search(new FlowProjectQuery(codeName), pageParam);
        return list.isEmpty() ? null : list.get(0);
    }

    public FlowProject getLastVersionFlowProject(String codeName) {
        PageParam pageParam = new PageParam();
        pageParam.setCurrent(0);
        pageParam.setPageSize(1);
        FlowProjectQuery query = new FlowProjectQuery(codeName);
        query.setStatus(null);
        List<FlowProject> list = this.flowProjectRepository.search(query, pageParam);
        return list.isEmpty() ? null : list.get(0);
    }

    public FlowProject getEnabledFlowProject(String codeName, Integer version) {
        PageParam pageParam = new PageParam();
        pageParam.setCurrent(0);
        pageParam.setPageSize(1);
        List<FlowProject> list = this.flowProjectRepository.search(new FlowProjectQuery(codeName, version), pageParam);
        return list.isEmpty() ? null : list.get(0);
    }

    public void modifyFlowProject(FlowProject flowProject) {
        this.flowProjectRepository.updateById((Object)flowProject, (Long)flowProject.getId());
    }

    public List<SimpleFlowProject> pageQueryFlowProject(SimpleFlowProjectQuery query, PageParam pageParam) {
        return this.flowProjectRepository.searchSimple(query, pageParam);
    }

    public List<SimpleFlowProject> listFlowProject(SimpleFlowProjectQuery query) {
        return this.flowProjectRepository.searchSimpleNoPage(query);
    }

    public long countFlowProject(SimpleFlowProjectQuery query) {
        return this.flowProjectRepository.countSimple(query);
    }

    public void releaseFlowProject(FlowProject flowProject) {
        NodesConfigDto nodesConfigDto;
        if (!FlowProjectStatus.DRAFT.equals((Object)flowProject.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.RELEASED_PROJECT_NOT_ALLOW_ACTION);
        }
        FlowModel flowModel = this.flowModelService.getFlowModel(flowProject.getFlowModelId());
        if (FlowModelStatus.DRAFT.equals((Object)flowModel.getStatus())) {
            this.flowModelService.releaseFlowModel(flowModel);
        }
        if ((nodesConfigDto = (NodesConfigDto)JSON.parseObject((String)flowProject.getNodeConfigs(), NodesConfigDto.class)).getApprovalNodes() != null) {
            Set<Long> matrixIds = nodesConfigDto.getApprovalNodes().stream().filter(dto -> Boolean.TRUE.equals(dto.getUseConditionMatrix()) && dto.getConditionMatrixId() != null).map(ApprovalNodeConfigDto::getConditionMatrixId).collect(Collectors.toSet());
            this.conditionMatrixService.markUsed(matrixIds);
        }
        String definition = this.flowDefinitionGenerateService.generate(flowModel, flowProject);
        String imageBase64 = flowModel.getImageBase64();
        if (imageBase64.startsWith(IMAGE_BASE64_DATA_PREFIX) || imageBase64.startsWith(IMAGE_BASE64_TYPE_PREFIX)) {
            imageBase64 = imageBase64.substring(imageBase64.indexOf(",") + 1);
        }
        DeployResult deployResult = this.flowEngineService.deploy(flowProject, definition, Base64.getDecoder().decode(imageBase64));
        flowProject.setDefinitionId(deployResult.getDefinitionId());
        flowProject.setVersionNo(deployResult.getVersionNo());
        if (CodeUtils.isEmptyId(flowProject.getFirstVersionId())) {
            flowProject.setFirstVersionId((Long)flowProject.getId());
        } else {
            this.flowProjectRepository.disableAll(flowProject.getFirstVersionId());
            this.flowProjectRepository.updateReleasedInfoField(flowProject.getFirstVersionId(), flowProject.getName(), flowProject.getDescription());
            this.flowProjectRepository.updateReleasedModelInfoField(flowProject.getFirstVersionId(), flowModel.getFlowCategoryId(), flowProject.getName(), flowProject.getDescription());
        }
        flowProject.setStatus(FlowProjectStatus.ENABLED);
        this.flowProjectRepository.updateById((Object)flowProject, (Long)flowProject.getId());
    }

    public void enableFlowProject(long id) {
        FlowProjectForStatus flowProject = this.flowProjectRepository.getFlowProjectForStatus(id);
        if (flowProject == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_ID_NOT_EXISTED);
        }
        if (FlowProjectStatus.DRAFT.equals((Object)flowProject.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DRAFT_PROJECT_NOT_ALLOW_ACTION);
        }
        if (FlowProjectStatus.DISABLED.equals((Object)flowProject.getStatus())) {
            this.flowProjectRepository.disableAll(flowProject.getFirstVersionId());
            this.flowProjectRepository.updateStatus(id, FlowProjectStatus.ENABLED);
        }
    }

    public void disableFlowProject(long id) {
        FlowProjectForStatus flowProject = this.flowProjectRepository.getFlowProjectForStatus(id);
        if (flowProject == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_ID_NOT_EXISTED);
        }
        if (FlowProjectStatus.DRAFT.equals((Object)flowProject.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.DRAFT_PROJECT_NOT_ALLOW_ACTION);
        }
        if (FlowProjectStatus.ENABLED.equals((Object)flowProject.getStatus())) {
            this.flowProjectRepository.updateStatus(id, FlowProjectStatus.DISABLED);
        }
    }

    public void deleteFlowProject(long id) {
        FlowProjectForStatus flowProject = this.flowProjectRepository.getFlowProjectForStatus(id);
        if (flowProject == null) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_PROJECT_ID_NOT_EXISTED);
        }
        if (!FlowProjectStatus.DRAFT.equals((Object)flowProject.getStatus())) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.RELEASED_PROJECT_NOT_ALLOW_ACTION);
        }
        this.flowProjectRepository.delete(id);
    }

    public List<FlowProject> batchGetFlowProject(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.flowProjectRepository.findByIdIn(ids);
    }

    public List<IdNameVo> listEnabledFirstVersion(long tenantId) {
        return this.flowProjectRepository.listEnabledFirstVersion(tenantId);
    }

    public FlowProject findDraftOrEnabled(String codeName) {
        List<FlowProject> list = this.flowProjectRepository.findDraftOrEnabled(codeName);
        if (list.isEmpty()) {
            return null;
        }
        return list.stream().filter(p -> FlowProjectStatus.DRAFT.equals((Object)p.getStatus())).findFirst().orElseGet(() -> (FlowProject)((Object)((Object)list.get(0))));
    }
}

