/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.script.service;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.script.dto.FlowScriptPageDto;
import com.cyberway.mp.flow.domain.script.entity.FlowScript;
import com.cyberway.mp.flow.domain.script.repository.FlowScriptRepository;
import com.cyberway.mp.flow.domain.script.repository.query.FlowScriptQuery;
import java.util.List;

public class FlowScriptService {
    private final FlowScriptRepository flowScriptRepository;

    public FlowScriptService(FlowScriptRepository flowScriptRepository) {
        this.flowScriptRepository = flowScriptRepository;
    }

    public void createScript(FlowScript flowScript) {
        if (this.flowScriptRepository.countByCodeNameAndTenantId(flowScript.getCodeName(), ServiceContext.getContext().getRequestTenantId()) > 0L) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_SCRIPT_CODE_ALREADY_EXISTED);
        }
        this.flowScriptRepository.save((Object)flowScript);
    }

    public void modifyScript(FlowScript flowScript) {
        this.flowScriptRepository.updateById((Object)flowScript, (Long)flowScript.getId());
    }

    public List<FlowScript> pageQueryScript(FlowScriptPageDto dto) {
        return this.flowScriptRepository.searchFlowScript(FlowScriptQuery.fromFlowScriptPageDto(dto), (PageParam)dto);
    }

    public long countScript(FlowScriptQuery query) {
        return this.flowScriptRepository.countFlowScript(query);
    }

    public void deleteScript(long id) {
        this.flowScriptRepository.delete(id);
    }

    public FlowScript getFlowScript(long id) {
        return (FlowScript)((Object)this.flowScriptRepository.findOne(id));
    }
}

