/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.task.entity;

import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.enums.FlowInstanceStatus;
import com.cyberway.mp.flow.api.project.enums.FormType;
import com.cyberway.mp.flow.api.task.vo.FlowTaskAllowActionVo;
import com.cyberway.mp.flow.api.task.vo.FlowTaskBaseVo;
import com.cyberway.mp.flow.api.task.vo.FlowTaskDueVo;
import com.cyberway.mp.flow.api.task.vo.FlowTaskHandledPageVo;
import com.cyberway.mp.flow.api.task.vo.FlowTaskInfoVo;
import com.cyberway.mp.flow.api.task.vo.FlowTaskTodoPageVo;
import com.cyberway.mp.flow.api.task.vo.MdmFlowTaskInfoVo;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import com.cyberway.mp.flow.infra.util.FlowUtils;
import java.util.Date;
import java.util.Map;

public class FlowTaskWithBusinessKey
extends FlowTask {
    @Alias(name="i.business_key")
    private Long businessKey;
    @Alias(name="i.instance_name")
    private String instanceName;
    @Alias(name="i.instance_code")
    private String instanceCode;
    @Alias(name="i.start_time")
    private Date instanceStartTime;
    @Alias(name="i.start_user_id")
    private Long startUserId;
    @Alias(name="i.start_user_name")
    private String startUserName;
    @Alias(name="i.process_instance_id")
    private String processInstanceId;
    @Alias(name="i.flow_project_id")
    private Long flowProjectId;
    @Alias(name="i.flow_project_code")
    private String flowProjectCode;
    @Alias(name="i.status")
    private FlowInstanceStatus flowInstanceStatus;
    @Alias(name="c.id")
    private Long categoryId;
    @Alias(name="c.name")
    private String categoryName;
    @Alias(name="t.edit_form_url")
    private String editFormUrl;
    @Alias(name="i.biz_data_flow_status")
    private Integer bizDataFlowStatus;
    @Alias(name="t.form_type")
    private FormType formType;

    public Long getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(Long businessKey) {
        this.businessKey = businessKey;
    }

    public Long getStartUserId() {
        return this.startUserId;
    }

    public void setStartUserId(Long startUserId) {
        this.startUserId = startUserId;
    }

    public String getStartUserName() {
        return this.startUserName;
    }

    public void setStartUserName(String startUserName) {
        this.startUserName = startUserName;
    }

    public Date getInstanceStartTime() {
        return this.instanceStartTime;
    }

    public void setInstanceStartTime(Date instanceStartTime) {
        this.instanceStartTime = instanceStartTime;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Long getFlowProjectId() {
        return this.flowProjectId;
    }

    public void setFlowProjectId(Long flowProjectId) {
        this.flowProjectId = flowProjectId;
    }

    public String getFlowProjectCode() {
        return this.flowProjectCode;
    }

    public void setFlowProjectCode(String flowProjectCode) {
        this.flowProjectCode = flowProjectCode;
    }

    public FlowInstanceStatus getFlowInstanceStatus() {
        return this.flowInstanceStatus;
    }

    public void setFlowInstanceStatus(FlowInstanceStatus flowInstanceStatus) {
        this.flowInstanceStatus = flowInstanceStatus;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    @Override
    public String getEditFormUrl() {
        return this.editFormUrl;
    }

    @Override
    public void setEditFormUrl(String editFormUrl) {
        this.editFormUrl = editFormUrl;
    }

    public Integer getBizDataFlowStatus() {
        return this.bizDataFlowStatus;
    }

    public void setBizDataFlowStatus(Integer bizDataFlowStatus) {
        this.bizDataFlowStatus = bizDataFlowStatus;
    }

    @Override
    public FormType getFormType() {
        return this.formType;
    }

    @Override
    public void setFormType(FormType formType) {
        this.formType = formType;
    }

    public String getInstanceCode() {
        return this.instanceCode;
    }

    public void setInstanceCode(String instanceCode) {
        this.instanceCode = instanceCode;
    }

    private Integer convertTaskDueStatus(Date now) {
        if (this.getDueTime() == null || FlowConstant.EMPTY_MAX_TIME.equals(this.getDueTime())) {
            return 3;
        }
        Date compareDate = this.getEndTime() == null || FlowConstant.EMPTY_MIN_TIME.equals(this.getEndTime()) ? now : this.getEndTime();
        return compareDate.before(this.getDueTime()) ? 2 : 1;
    }

    public FlowTaskDueVo toFlowTaskDueVo(long now) {
        FlowTaskDueVo vo = new FlowTaskDueVo();
        this.initFlowTaskBaseVo((FlowTaskBaseVo)vo);
        vo.setCategoryName(this.getCategoryName());
        vo.setInstanceName(this.getInstanceName());
        vo.setUrgeTimes(this.getUrgeTimes());
        if (vo.getDueTime() == null || vo.getDueTime().getTime() >= now) {
            vo.setDueMs(Long.valueOf(0L));
        } else {
            vo.setDueMs(Long.valueOf(now - vo.getDueTime().getTime()));
        }
        return vo;
    }

    public FlowTaskInfoVo toFlowTaskInfoVo() {
        FlowTaskInfoVo flowTaskInfoVo = new FlowTaskInfoVo();
        this.initFlowTaskInfoVo(flowTaskInfoVo);
        flowTaskInfoVo.setCategoryName(this.getCategoryName());
        return flowTaskInfoVo;
    }

    public FlowTaskInfoVo toFlowTaskInfoVo(Map<Long, Map<String, Object>> processVarMaps) {
        FlowTaskInfoVo flowTaskInfoVo = new FlowTaskInfoVo();
        this.initFlowTaskInfoVo(flowTaskInfoVo);
        flowTaskInfoVo.setVariables(processVarMaps.get(this.getId()));
        flowTaskInfoVo.setCategoryName(this.getCategoryName());
        return flowTaskInfoVo;
    }

    public MdmFlowTaskInfoVo toMdmFlowTaskInfoVo() {
        MdmFlowTaskInfoVo mdmFlowTaskInfoVo = new MdmFlowTaskInfoVo();
        this.initFlowTaskInfoVo((FlowTaskInfoVo)mdmFlowTaskInfoVo);
        mdmFlowTaskInfoVo.setInstanceStartTime(this.getInstanceStartTime());
        mdmFlowTaskInfoVo.setInstanceName(this.getInstanceName());
        mdmFlowTaskInfoVo.setFlowProjectCode(this.getFlowProjectCode());
        mdmFlowTaskInfoVo.setCategoryName(this.getCategoryName());
        mdmFlowTaskInfoVo.setEditFormUrl(this.getEditFormUrl());
        mdmFlowTaskInfoVo.setBizDataFlowStatus(this.getBizDataFlowStatus());
        mdmFlowTaskInfoVo.setFormType(this.getFormType());
        return mdmFlowTaskInfoVo;
    }

    public FlowTaskTodoPageVo toFlowTaskTodoPageVo(Date now) {
        FlowTaskTodoPageVo vo = new FlowTaskTodoPageVo();
        this.initFlowTaskTodoPageVo(vo, now);
        return vo;
    }

    private void initFlowTaskTodoPageVo(FlowTaskTodoPageVo vo, Date now) {
        this.initFlowTaskBaseVo((FlowTaskBaseVo)vo);
        vo.setInstanceName(this.getInstanceName());
        vo.setInstanceCode(this.getInstanceCode());
        vo.setInstanceStartTime(this.getInstanceStartTime());
        vo.setFlowInstanceStatus(this.getFlowInstanceStatus());
        vo.setCategoryId(this.getCategoryId());
        vo.setCategoryName(this.getCategoryName());
        vo.setStarterUserId(this.getStartUserId());
        vo.setStarterUserName(this.getStartUserName());
        vo.setEditFormUrl(this.getEditFormUrl());
        vo.setBizDataFlowStatus(this.getBizDataFlowStatus());
        vo.setFormType(this.getFormType());
        vo.setTaskDueStatus(this.convertTaskDueStatus(now));
        vo.setCustomTaskInfo(this.getCustomTaskInfo());
    }

    public FlowTaskAllowActionVo toFlowTaskAllowActionVo() {
        FlowTaskAllowActionVo flowTaskAllowActionVo = new FlowTaskAllowActionVo();
        this.initFlowTaskInfoVo((FlowTaskInfoVo)flowTaskAllowActionVo);
        return flowTaskAllowActionVo;
    }

    public FlowTaskHandledPageVo toFlowTaskHandledPageVo(Date now) {
        FlowTaskHandledPageVo vo = new FlowTaskHandledPageVo();
        this.initFlowTaskTodoPageVo((FlowTaskTodoPageVo)vo, now);
        vo.setEndTime(CodeUtils.formatNullableMinTime(this.getEndTime()));
        vo.setCountersignResult(this.getCountersignResult());
        vo.setDeleteReason(this.getDeleteReason());
        vo.setOpinion(this.getOpinion());
        return vo;
    }

    protected void initFlowTaskBaseVo(FlowTaskBaseVo vo) {
        vo.setId((Long)this.getId());
        vo.setFlowInstanceId(this.getFlowInstanceId());
        vo.setFlowNodeId(this.getFlowNodeId());
        vo.setTaskName(this.getTaskName());
        vo.setTaskType(this.getTaskType());
        vo.setNodeKey(this.getNodeKey());
        vo.setAssigneeUserId(this.getAssigneeUserId());
        vo.setAssigneeUserName(this.getAssigneeUserName());
        vo.setOwnerUserId(CodeUtils.formatNullableId(this.getOwnerUserId()));
        vo.setOwnerUserName(this.getOwnerUserName());
        vo.setStartTime(this.getStartTime());
        vo.setLastStartTime(this.getLastStartTime());
        vo.setDueTime(CodeUtils.formatNullableMaxTime(this.getDueTime()));
        vo.setCountersign(this.getCountersign());
        vo.setStatus(this.getStatus());
        vo.setAutoCompleteFlag(this.getAutoCompleteFlag());
        vo.setReSubmit(this.getReSubmit());
        vo.setAllowOwnerApprove(this.getAllowOwnerApprove());
        if (!CodeUtils.isEmptyMaxTime(this.getEndTime())) {
            vo.setConsumeTime(Long.valueOf(this.getEndTime().getTime() - this.getStartTime().getTime()));
        }
        vo.setBusinessKey(this.getBusinessKey());
        vo.setFormUrl(FlowUtils.formatFormUrl(this.getFormType(), this.getFormUrl(), this.getFlowInstanceId(), this.getBusinessKey(), (Long)this.getId(), this.getNodeKey()));
    }

    protected void initFlowTaskInfoVo(FlowTaskInfoVo flowTaskInfoVo) {
        this.initFlowTaskBaseVo((FlowTaskBaseVo)flowTaskInfoVo);
        flowTaskInfoVo.setActionUserId(CodeUtils.formatNullableId(this.getActionUserId()));
        flowTaskInfoVo.setActionUserName(this.getActionUserName());
        flowTaskInfoVo.setEndTime(CodeUtils.formatNullableMinTime(this.getEndTime()));
        flowTaskInfoVo.setCountersignResult(this.getCountersignResult());
        flowTaskInfoVo.setDeleteReason(this.getDeleteReason());
        flowTaskInfoVo.setOpinion(this.getOpinion());
        flowTaskInfoVo.setBusinessKey(this.getBusinessKey());
        flowTaskInfoVo.setFlowInstanceStatus(this.getFlowInstanceStatus());
        flowTaskInfoVo.setStartUserId(this.getStartUserId());
        flowTaskInfoVo.setStartUserName(this.getStartUserName());
        flowTaskInfoVo.setInstanceName(this.getInstanceName());
        flowTaskInfoVo.setFlowProjectCode(this.getFlowProjectCode());
        flowTaskInfoVo.setFormUrl(FlowUtils.formatFormUrl(this.getFormType(), this.getFormUrl(), this.getFlowInstanceId(), this.getBusinessKey(), (Long)this.getId(), this.getNodeKey()));
        flowTaskInfoVo.setEditFormUrl(FlowUtils.formatFormUrl(this.getEditFormType(), this.getEditFormUrl(), this.getFlowInstanceId(), this.getBusinessKey(), (Long)this.getId(), this.getNodeKey()));
    }
}

