/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.task.repository;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.dal.GenericMapper;
import com.cyberway.mp.bc.dal.annotation.IgnoreMethod;
import com.cyberway.mp.bc.dal.annotation.IgnoreTenantFilter;
import com.cyberway.mp.bc.dal.annotation.ResultBeanAlias;
import com.cyberway.mp.flow.api.common.vo.IdNameVo;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.api.task.enums.FlowTaskType;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskForUrgeStarter;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithBusinessKey;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import com.cyberway.mp.flow.domain.task.repository.query.FlowTaskQuery;
import com.cyberway.mp.flow.infra.annotation.ReplaceQueryTable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface FlowTaskRepository
extends GenericMapper<FlowTask, Long> {
    public List<FlowTask> findByIdIn(@Param(value="id") Collection<Long> var1);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    public List<FlowTask> findByFlowInstanceIdIn(@Param(value="flowInstanceId") Collection<Long> var1);

    public List<FlowTask> findByIdAndStatus(@Param(value="id") long var1, @Param(value="status") String var3);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    public List<FlowTask> findByFlowInstanceIdAndStatus(@Param(value="flowInstanceId") long var1, @Param(value="status") String var3);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    public List<FlowTask> findByFlowInstanceIdAndStatusAndTaskType(@Param(value="flowInstanceId") long var1, @Param(value="status") String var3, @Param(value="taskType") FlowTaskType var4);

    public List<FlowTask> findByTaskId(@Param(value="taskId") String var1);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    @ResultBeanAlias(value="t")
    public List<FlowTaskWithBusinessKey> searchFlowTaskWithBusinessKeyNoPage(FlowTaskQuery var1);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    public long countFlowTaskWithBusinessKey(FlowTaskQuery var1);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    @ResultBeanAlias(value="t")
    public List<FlowTaskWithBusinessKey> searchFlowTaskWithBusinessKey(FlowTaskQuery var1, PageParam var2);

    @IgnoreTenantFilter
    @IgnoreMethod
    public List<FlowTaskWithProject> listForUrgeAssignee(@Param(value="now") Date var1);

    @IgnoreMethod
    public FlowTaskWithProject getFlowTaskWithProject(@Param(value="id") long var1);

    @IgnoreMethod
    public List<FlowTaskWithProject> batchGetFlowTaskWithProject(@Param(value="ids") Collection<Long> var1);

    @IgnoreTenantFilter
    @IgnoreMethod
    public void markUrgeAssignee(@Param(value="id") long var1, @Param(value="nextTime") Date var3, @Param(value="addUrgeTimes") boolean var4);

    @IgnoreTenantFilter
    @IgnoreMethod
    public List<FlowTaskForUrgeStarter> listForUrgeStarter(@Param(value="now") Date var1);

    @IgnoreTenantFilter
    @IgnoreMethod
    public void markUrgeStarter(@Param(value="id") long var1, @Param(value="emptyTime") Date var3, @Param(value="addUrgeTimes") boolean var4);

    @IgnoreTenantFilter
    @IgnoreMethod
    public List<FlowTaskWithProject> listForUrgeSpecial(@Param(value="now") Date var1);

    @IgnoreTenantFilter
    @IgnoreMethod
    public void markUrgeSpecial(@Param(value="id") long var1, @Param(value="emptyTime") Date var3, @Param(value="addUrgeTimes") boolean var4);

    @IgnoreTenantFilter
    @IgnoreMethod
    public List<FlowTaskWithProject> listForDueHandle(@Param(value="now") Date var1);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    @IgnoreMethod
    public long isOldAssignee(@Param(value="flowInstanceId") long var1, @Param(value="userId") long var3, @Param(value="emptyEndTime") Date var5);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    @IgnoreMethod
    public List<IdNameVo> listAllAssignee(@Param(value="flowInstanceId") long var1);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    public List<FlowTask> findByFlowInstanceIdOrderByStartTimeDesc(@Param(value="flowInstanceId") long var1);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    public List<FlowTask> findByFlowInstanceIdOrderByStartTimeAsc(@Param(value="flowInstanceId") long var1);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    public List<FlowTask> findByFlowInstanceIdAndNodeKeyOrderByStartTimeDesc(@Param(value="flowInstanceId") long var1, @Param(value="nodeKey") String var3);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    @IgnoreMethod
    public long countApprovalSameAssignee(@Param(value="flowInstanceId") long var1, @Param(value="assigneeUserId") long var3);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    @IgnoreMethod
    public long countApprovalSameAssigneeInNodes(@Param(value="flowInstanceId") long var1, @Param(value="assigneeUserId") long var3, @Param(value="nodeKeys") Collection<String> var5);

    @IgnoreMethod
    public List<FlowTask> listToDelegation(@Param(value="ownerUserId") long var1);

    @IgnoreMethod
    public List<FlowTask> listToDelegationForProjects(@Param(value="ownerUserId") long var1, @Param(value="firstVersionIds") Collection<Long> var3);

    @IgnoreMethod
    public List<FlowTask> listToCancelDelegation(@Param(value="delegationRuleId") long var1);

    @IgnoreMethod
    public List<FlowTask> listToCancelDelegationForProjects(@Param(value="delegationRuleId") long var1, @Param(value="firstVersionIds") Collection<Long> var3);

    @IgnoreMethod
    public void updateFinStatusAllRunning(@Param(value="flowInstanceId") long var1, @Param(value="status") FlowTaskStatus var3, @Param(value="deleteReason") FlowTaskDeleteReason var4, @Param(value="opinion") String var5, @Param(value="endTime") Date var6, @Param(value="actionUserId") Long var7, @Param(value="actionUserName") String var8);

    @IgnoreMethod
    public void addUrgeTimes(@Param(value="id") long var1);

    @ReplaceQueryTable(sourceTables={"fc_flow_task"}, targetTables={"fc_sd_flow_task_iid"})
    public List<FlowTask> findByFlowInstanceIdInAndStatusIn(@Param(value="flowInstanceId") Collection<Long> var1, @Param(value="status") Collection<FlowTaskStatus> var2);

    @IgnoreMethod
    @IgnoreTenantFilter
    public FlowTaskWithProject getIgnoreTenant(@Param(value="id") Long var1);

    public void deleteByFlowInstanceIdInAndStatus(@Param(value="flowInstanceId") List<Long> var1, @Param(value="status") FlowTaskStatus var2);

    public List<FlowTask> findByFlowNodeId(@Param(value="flowNodeId") Long var1);
}

