/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.task.repository.query;

import com.cyberway.mp.bc.common.api.OrderPageParam;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.dal.annotation.Join;
import com.cyberway.mp.bc.dal.annotation.Predicate;
import com.cyberway.mp.bc.dal.annotation.query.Contains;
import com.cyberway.mp.bc.dal.annotation.query.GreaterThanEqual;
import com.cyberway.mp.bc.dal.annotation.query.In;
import com.cyberway.mp.bc.dal.annotation.query.LessThanEqual;
import com.cyberway.mp.bc.dal.annotation.query.Not;
import com.cyberway.mp.bc.dal.annotation.query.NotIn;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.dal.annotation.query.SubQuery;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceExtQuerySupportDto;
import com.cyberway.mp.flow.api.instance.enums.FlowInstanceStatus;
import com.cyberway.mp.flow.api.task.dto.FlowTaskDuePageDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskHandledPageDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskInfoListDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskInfoPageDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskTodoPageDto;
import com.cyberway.mp.flow.api.task.dto.MdmFlowTaskInfoPageDto;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.domain.instance.repository.query.FlowInstanceExtQuery;
import com.cyberway.mp.flow.domain.task.repository.query.EmptyDateParam;
import io.seata.common.util.CollectionUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Predicate(dynamic=true)
@Join(script="fc_flow_task t join fc_flow_instance i on i.id = t.flow_instance_id join fc_flow_project p on p.id = i.flow_project_id join fc_flow_model m on m.id = p.flow_model_id join fc_flow_category c on c.id = m.flow_category_id left join fc_flow_instance_ext ext on ext.flow_instance_id=i.id ")
public class FlowTaskQuery
extends FlowInstanceExtQuery {
    private static final OrderFragment DEFAULT_ORDER_FRAGMENT = new OrderFragment("t.start_time", "DESC");
    private static final Map<String, String> ORDER_FIELD_MAP = new HashMap<String, String>();
    @Alias(name="t.id")
    private Long id;
    @Alias(name="i.flow_project_code")
    private String flowProjectCode;
    @Alias(name="i.flow_project_id")
    private Long flowProjectId;
    @Alias(name="i.start_user_id")
    private Long startUserId;
    @Alias(name="i.instance_code")
    @Contains
    private String instanceCodeLike;
    @Alias(name="i.instance_code")
    private String instanceCode;
    @Contains
    @Alias(name="i.start_user_name")
    private String startUserName;
    @Contains
    @Alias(name="i.instance_name")
    private String instanceName;
    @Contains
    @Alias(name="t.task_name")
    private String taskName;
    @Not
    @Alias(name="t.node_key")
    private String notNodeKey;
    @GreaterThanEqual
    @Alias(name="i.start_time")
    private Date minInstanceStartTime;
    @LessThanEqual
    @Alias(name="i.start_time")
    private Date maxInstanceStartTime;
    @GreaterThanEqual
    @Alias(name="t.start_time")
    private Date minTaskStartTime;
    @LessThanEqual
    @Alias(name="t.start_time")
    private Date maxTaskStartTime;
    @GreaterThanEqual
    @Alias(name="t.last_start_time")
    private Date minTaskLastStartTime;
    @LessThanEqual
    @Alias(name="t.last_start_time")
    private Date maxTaskLastStartTime;
    @GreaterThanEqual
    @Alias(name="t.end_time")
    private Date minTaskEndTime;
    @LessThanEqual
    @Alias(name="t.end_time")
    private Date maxTaskEndTime;
    @GreaterThanEqual
    @Alias(name="t.due_time")
    private Date minDueTime;
    @LessThanEqual
    @Alias(name="t.due_time")
    private Date maxDueTime;
    @Alias(name="t.flow_instance_id")
    private Long flowInstanceId;
    @Alias(name="t.assignee_user_id")
    private Long assigneeUserId;
    @In
    @Alias(name="t.assignee_user_id")
    private Collection<Long> assigneeUserIdIn;
    @Alias(name="t.owner_user_id")
    private Long ownerUserId;
    @Alias(name="t.action_user_id")
    private Long actionUserId;
    @SubQuery(value="t.assignee_user_id=#{userId} or t.owner_user_id=#{userId} or t.action_user_id=#{userId}")
    private Long userId;
    @SubQuery(value="t.assignee_user_id=#{approveUserId} or (t.allow_owner_approve=1 and t.owner_user_id=#{approveUserId})")
    private Long approveUserId;
    @Alias(name="i.business_key")
    private Long businessKey;
    @Alias(name="t.node_key")
    private String nodeKey;
    @In
    @Alias(name="t.status")
    private List<FlowTaskStatus> status;
    @NotIn
    @Alias(name="t.status")
    private List<FlowTaskStatus> notStatus;
    @In
    @Alias(name="i.status")
    private List<FlowInstanceStatus> flowInstanceStatus;
    @In
    @Alias(name="t.delete_reason")
    private List<FlowTaskDeleteReason> deleteReason;
    @Alias(name="t.app_instance_id")
    private Long appInstanceId;
    @Alias(name="i.flow_project_code")
    @In
    private List<String> flowProjectCodes;
    @Alias(name="c.id")
    private Long categoryId;
    @Alias(name="t.task_id")
    private String taskId;
    @In
    @Alias(name="c.id")
    private Collection<Long> categoryIdIn;
    @SubQuery(value="t.end_time &gt;= t.due_time or (t.end_time = #{taskAlreadyDue.emptyMinDate} and t.due_time &lt;= #{taskAlreadyDue.value})")
    private EmptyDateParam taskAlreadyDue;
    @SubQuery(value="t.due_time &lt; #{taskNotDue.emptyMaxDate} and t.end_time &lt; t.due_time and (t.end_time &gt; #{taskNotDue.emptyMinDate} or t.due_time &gt; #{taskNotDue.value})")
    private EmptyDateParam taskNotDue;
    @OrderByField
    private List<OrderFragment> orderFragment;

    public String getInstanceCode() {
        return this.instanceCode;
    }

    public void setInstanceCode(String instanceCode) {
        this.instanceCode = instanceCode;
    }

    public String getInstanceCodeLike() {
        return this.instanceCodeLike;
    }

    public void setInstanceCodeLike(String instanceCodeLike) {
        this.instanceCodeLike = instanceCodeLike;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFlowProjectCode() {
        return this.flowProjectCode;
    }

    public void setFlowProjectCode(String flowProjectCode) {
        this.flowProjectCode = flowProjectCode;
    }

    public Long getFlowProjectId() {
        return this.flowProjectId;
    }

    public void setFlowProjectId(Long flowProjectId) {
        this.flowProjectId = flowProjectId;
    }

    public Long getFlowInstanceId() {
        return this.flowInstanceId;
    }

    public void setFlowInstanceId(Long flowInstanceId) {
        this.flowInstanceId = flowInstanceId;
    }

    public Long getAssigneeUserId() {
        return this.assigneeUserId;
    }

    public void setAssigneeUserId(Long assigneeUserId) {
        this.assigneeUserId = assigneeUserId;
    }

    public Collection<Long> getAssigneeUserIdIn() {
        return this.assigneeUserIdIn;
    }

    public void setAssigneeUserIdIn(Collection<Long> assigneeUserIdIn) {
        this.assigneeUserIdIn = assigneeUserIdIn;
    }

    public Long getOwnerUserId() {
        return this.ownerUserId;
    }

    public void setOwnerUserId(Long ownerUserId) {
        this.ownerUserId = ownerUserId;
    }

    public Long getActionUserId() {
        return this.actionUserId;
    }

    public void setActionUserId(Long actionUserId) {
        this.actionUserId = actionUserId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getApproveUserId() {
        return this.approveUserId;
    }

    public void setApproveUserId(Long approveUserId) {
        this.approveUserId = approveUserId;
    }

    public Long getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(Long businessKey) {
        this.businessKey = businessKey;
    }

    public String getNodeKey() {
        return this.nodeKey;
    }

    public void setNodeKey(String nodeKey) {
        this.nodeKey = nodeKey;
    }

    public List<FlowTaskStatus> getStatus() {
        return this.status;
    }

    public void setStatus(List<FlowTaskStatus> status) {
        this.status = status;
    }

    public List<FlowTaskStatus> getNotStatus() {
        return this.notStatus;
    }

    public void setNotStatus(List<FlowTaskStatus> notStatus) {
        this.notStatus = notStatus;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Long getStartUserId() {
        return this.startUserId;
    }

    public void setStartUserId(Long startUserId) {
        this.startUserId = startUserId;
    }

    public String getStartUserName() {
        return this.startUserName;
    }

    public void setStartUserName(String startUserName) {
        this.startUserName = startUserName;
    }

    public Date getMinInstanceStartTime() {
        return this.minInstanceStartTime;
    }

    public void setMinInstanceStartTime(Date minInstanceStartTime) {
        this.minInstanceStartTime = minInstanceStartTime;
    }

    public Date getMaxInstanceStartTime() {
        return this.maxInstanceStartTime;
    }

    public void setMaxInstanceStartTime(Date maxInstanceStartTime) {
        this.maxInstanceStartTime = maxInstanceStartTime;
    }

    public Date getMinTaskStartTime() {
        return this.minTaskStartTime;
    }

    public void setMinTaskStartTime(Date minTaskStartTime) {
        this.minTaskStartTime = minTaskStartTime;
    }

    public Date getMaxTaskStartTime() {
        return this.maxTaskStartTime;
    }

    public void setMaxTaskStartTime(Date maxTaskStartTime) {
        this.maxTaskStartTime = maxTaskStartTime;
    }

    public Date getMinTaskLastStartTime() {
        return this.minTaskLastStartTime;
    }

    public void setMinTaskLastStartTime(Date minTaskLastStartTime) {
        this.minTaskLastStartTime = minTaskLastStartTime;
    }

    public Date getMaxTaskLastStartTime() {
        return this.maxTaskLastStartTime;
    }

    public void setMaxTaskLastStartTime(Date maxTaskLastStartTime) {
        this.maxTaskLastStartTime = maxTaskLastStartTime;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public Date getMinDueTime() {
        return this.minDueTime;
    }

    public void setMinDueTime(Date minDueTime) {
        this.minDueTime = minDueTime;
    }

    public Date getMaxDueTime() {
        return this.maxDueTime;
    }

    public void setMaxDueTime(Date maxDueTime) {
        this.maxDueTime = maxDueTime;
    }

    public Date getMinTaskEndTime() {
        return this.minTaskEndTime;
    }

    public void setMinTaskEndTime(Date minTaskEndTime) {
        this.minTaskEndTime = minTaskEndTime;
    }

    public Date getMaxTaskEndTime() {
        return this.maxTaskEndTime;
    }

    public void setMaxTaskEndTime(Date maxTaskEndTime) {
        this.maxTaskEndTime = maxTaskEndTime;
    }

    public Long getAppInstanceId() {
        return this.appInstanceId;
    }

    public void setAppInstanceId(Long appInstanceId) {
        this.appInstanceId = appInstanceId;
    }

    public List<FlowInstanceStatus> getFlowInstanceStatus() {
        return this.flowInstanceStatus;
    }

    public void setFlowInstanceStatus(List<FlowInstanceStatus> flowInstanceStatus) {
        this.flowInstanceStatus = flowInstanceStatus;
    }

    public List<FlowTaskDeleteReason> getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(List<FlowTaskDeleteReason> deleteReason) {
        this.deleteReason = deleteReason;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public Collection<Long> getCategoryIdIn() {
        return this.categoryIdIn;
    }

    public void setCategoryIdIn(Collection<Long> categoryIdIn) {
        this.categoryIdIn = categoryIdIn;
    }

    public List<OrderFragment> getOrderFragment() {
        return this.orderFragment;
    }

    public void setOrderFragment(List<OrderFragment> orderFragment) {
        this.orderFragment = orderFragment;
    }

    public String getNotNodeKey() {
        return this.notNodeKey;
    }

    public void setNotNodeKey(String notNodeKey) {
        this.notNodeKey = notNodeKey;
    }

    public List<String> getFlowProjectCodes() {
        return this.flowProjectCodes;
    }

    public void setFlowProjectCodes(List<String> flowProjectCodes) {
        this.flowProjectCodes = flowProjectCodes;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public EmptyDateParam getTaskAlreadyDue() {
        return this.taskAlreadyDue;
    }

    public void setTaskAlreadyDue(EmptyDateParam taskAlreadyDue) {
        this.taskAlreadyDue = taskAlreadyDue;
    }

    public EmptyDateParam getTaskNotDue() {
        return this.taskNotDue;
    }

    public void setTaskNotDue(EmptyDateParam taskNotDue) {
        this.taskNotDue = taskNotDue;
    }

    private void initByFlowTaskDuePageDto(FlowTaskDuePageDto dto) {
        this.initByExtDto((FlowInstanceExtQuerySupportDto)dto);
        this.setFlowProjectCode(dto.getFlowProjectCode());
        this.setFlowProjectId(dto.getFlowProjectId());
        this.setFlowInstanceId(dto.getFlowInstanceId());
        this.setAssigneeUserId(dto.getAssigneeUserId());
        this.setAssigneeUserIdIn(dto.getAssigneeUserIdIn());
        this.setOwnerUserId(dto.getOwnerUserId());
        this.setUserId(dto.getUserId());
        this.setApproveUserId(dto.getApproveUserId());
        this.setBusinessKey(dto.getBusinessKey());
        this.setNodeKey(dto.getNodeKey());
        this.setFlowProjectCodes(dto.getFlowProjectCodes());
        this.setCategoryId(dto.getCategoryId());
        this.setCategoryIdIn(dto.getCategoryIdIn());
        this.setMinTaskStartTime(dto.getMinTaskStartTime());
        this.setMaxTaskStartTime(dto.getMaxTaskStartTime());
        this.setMinTaskLastStartTime(dto.getMinTaskLastStartTime());
        this.setMaxTaskLastStartTime(dto.getMaxTaskLastStartTime());
        this.setTaskName(dto.getTaskName());
        this.setInstanceName(dto.getInstanceName());
        this.setStartUserId(dto.getStarterUserId());
        this.setStartUserName(dto.getStarterUserNameLike());
        this.setMinInstanceStartTime(dto.getMinInstanceStartTime());
        this.setMaxInstanceStartTime(dto.getMaxInstanceStartTime());
        this.setMinDueTime(dto.getMinDueTime());
        this.setMaxDueTime(dto.getMaxDueTime());
        this.setMinTaskEndTime(dto.getMinTaskEndTime());
        this.setMaxTaskEndTime(dto.getMaxTaskEndTime());
        this.calOrderFragment((OrderPageParam)dto);
    }

    public static FlowTaskQuery fromFlowTaskInfoListDto(FlowTaskInfoListDto dto) {
        FlowTaskQuery flowTaskQuery = new FlowTaskQuery();
        flowTaskQuery.setFlowProjectCode(dto.getFlowProjectCode());
        flowTaskQuery.setFlowProjectId(dto.getFlowProjectId());
        flowTaskQuery.setFlowInstanceId(dto.getFlowInstanceId());
        flowTaskQuery.setAssigneeUserId(dto.getAssigneeUserId());
        flowTaskQuery.setOwnerUserId(dto.getOwnerUserId());
        flowTaskQuery.setActionUserId(dto.getActionUserId());
        flowTaskQuery.setUserId(dto.getUserId());
        flowTaskQuery.setApproveUserId(dto.getApproveUserId());
        flowTaskQuery.setBusinessKey(dto.getBusinessKey());
        flowTaskQuery.setNodeKey(dto.getNodeKey());
        flowTaskQuery.setStatus(dto.getStatus());
        flowTaskQuery.setFlowInstanceStatus(dto.getFlowInstanceStatus());
        flowTaskQuery.setDeleteReason(dto.getDeleteReason());
        flowTaskQuery.setCategoryId(dto.getCategoryId());
        flowTaskQuery.setStartUserId(dto.getStarterUserId());
        flowTaskQuery.setStartUserName(dto.getStarterUserNameLike());
        flowTaskQuery.setMinInstanceStartTime(dto.getMinInstanceStartTime());
        flowTaskQuery.setMaxInstanceStartTime(dto.getMaxInstanceStartTime());
        flowTaskQuery.initByExtDto((FlowInstanceExtQuerySupportDto)dto);
        OrderPageParam orderPageParam = new OrderPageParam();
        orderPageParam.setOrderField(dto.getOrderField());
        orderPageParam.setOrderDirection(dto.getOrderDirection());
        flowTaskQuery.calOrderFragment(orderPageParam);
        return flowTaskQuery;
    }

    public static FlowTaskQuery fromFlowTaskDuePageDto(FlowTaskDuePageDto dto) {
        FlowTaskQuery flowTaskQuery = new FlowTaskQuery();
        flowTaskQuery.initByFlowTaskDuePageDto(dto);
        flowTaskQuery.setStatus(List.of(FlowTaskStatus.RUNNING, FlowTaskStatus.SUSPENDED, FlowTaskStatus.WAIT_STARTER_FILL, FlowTaskStatus.WAIT_STARTER_FILL_SAME_NODE));
        flowTaskQuery.setMaxDueTime(new Date());
        return flowTaskQuery;
    }

    public static FlowTaskQuery fromFlowTaskInfoPageDto(FlowTaskInfoPageDto dto) {
        FlowTaskQuery flowTaskQuery = new FlowTaskQuery();
        flowTaskQuery.initByFlowTaskDuePageDto((FlowTaskDuePageDto)dto);
        flowTaskQuery.setActionUserId(dto.getActionUserId());
        flowTaskQuery.setStatus(dto.getStatus());
        flowTaskQuery.setDeleteReason(dto.getDeleteReason());
        return flowTaskQuery;
    }

    public static FlowTaskQuery fromMdmFlowTaskInfoPageDto(MdmFlowTaskInfoPageDto dto) {
        FlowTaskQuery flowTaskQuery = FlowTaskQuery.fromFlowTaskInfoPageDto((FlowTaskInfoPageDto)dto);
        flowTaskQuery.setId(dto.getId());
        flowTaskQuery.setStartUserId(dto.getStartUserId());
        flowTaskQuery.setStartUserName(dto.getStartUserName());
        flowTaskQuery.setNotNodeKey(dto.getNotNodeKey());
        flowTaskQuery.setAppInstanceId(dto.getAppInstanceId());
        flowTaskQuery.setFlowProjectCodes(dto.getFlowProjectCodes());
        flowTaskQuery.setCategoryId(dto.getCategoryId());
        return flowTaskQuery;
    }

    public static FlowTaskQuery fromFlowTaskTodoPageDto(FlowTaskTodoPageDto dto) {
        FlowTaskQuery flowTaskQuery = new FlowTaskQuery();
        flowTaskQuery.initByFlowTaskTodoPageDto(dto);
        return flowTaskQuery;
    }

    public static FlowTaskQuery fromFlowTaskDraftPageDto(FlowTaskTodoPageDto dto, Long loginUserId) {
        FlowTaskQuery flowTaskQuery = new FlowTaskQuery();
        if (flowTaskQuery.initByFlowTaskTodoPageDto(dto)) {
            flowTaskQuery.setStatus(List.of(FlowTaskStatus.DRAFT));
        }
        flowTaskQuery.setApproveUserId(loginUserId);
        return flowTaskQuery;
    }

    private boolean initByFlowTaskTodoPageDto(FlowTaskTodoPageDto dto) {
        this.initByExtDto((FlowInstanceExtQuerySupportDto)dto);
        this.setId(dto.getId());
        this.setFlowInstanceId(dto.getFlowInstanceId());
        this.setInstanceName(dto.getInstanceName());
        this.setBusinessKey(dto.getBusinessKey());
        this.setTaskName(dto.getTaskNameLike());
        this.setStartUserId(dto.getStarterUserId());
        this.setStartUserName(dto.getStarterUserNameLike());
        this.setMinTaskStartTime(dto.getMinStartTime());
        this.setMaxTaskStartTime(dto.getMaxStartTime());
        this.setMinTaskLastStartTime(dto.getMinLastStartTime());
        this.setMaxTaskLastStartTime(dto.getMaxLastStartTime());
        this.setMinDueTime(dto.getMinDueTime());
        this.setMaxDueTime(dto.getMaxDueTime());
        this.setMinInstanceStartTime(dto.getMinInstanceStartTime());
        this.setMaxInstanceStartTime(dto.getMaxInstanceStartTime());
        this.setCategoryId(dto.getCategoryId());
        boolean needDefaultStatus = true;
        if (dto.getStatus() != null && !dto.getStatus().isEmpty()) {
            this.setStatus(dto.getStatus());
            needDefaultStatus = false;
        }
        if (dto.getNotStatus() != null && !dto.getNotStatus().isEmpty()) {
            this.setNotStatus(dto.getNotStatus());
            needDefaultStatus = false;
        }
        if (needDefaultStatus) {
            this.setStatus(List.of(FlowTaskStatus.RUNNING, FlowTaskStatus.SUSPENDED));
        }
        this.setInstanceCodeLike(dto.getInstanceCodeLike());
        this.setInstanceCode(dto.getInstanceCode());
        if (dto.getFlowInstanceStatus() != null && !dto.getFlowInstanceStatus().isEmpty()) {
            this.setFlowInstanceStatus(dto.getFlowInstanceStatus());
        }
        this.convertTaskDueStatus(dto.getTaskDueStatus());
        OrderFragment paramOrderFragment = OrderFragment.fromOrderPageParam((OrderPageParam)dto);
        if (paramOrderFragment == null) {
            this.setOrderFragment(List.of(new OrderFragment("case when t.status = 'DRAFT' then 0 when t.status = 'RUNNING' then 1 end", "asc"), DEFAULT_ORDER_FRAGMENT));
        } else {
            this.calOrderFragment((OrderPageParam)dto);
        }
        return needDefaultStatus;
    }

    private void convertTaskDueStatus(Integer taskDueStatus) {
        if (taskDueStatus == null) {
            return;
        }
        EmptyDateParam dateParam = new EmptyDateParam(new Date());
        switch (taskDueStatus) {
            case 1: {
                this.setTaskAlreadyDue(dateParam);
                break;
            }
            case 2: {
                this.setTaskNotDue(dateParam);
                break;
            }
            case 3: {
                this.setMinDueTime(FlowConstant.EMPTY_MAX_TIME);
                break;
            }
        }
    }

    private void calOrderFragment(OrderPageParam orderPageParam) {
        this.calOrderFragment(orderPageParam, DEFAULT_ORDER_FRAGMENT);
    }

    private void calOrderFragment(OrderPageParam orderPageParam, OrderFragment defaultOrderFragment) {
        if (null == orderPageParam || StringUtils.isBlank((CharSequence)orderPageParam.getOrderField()) && CollectionUtils.isEmpty((Collection)orderPageParam.getOrderList())) {
            this.setOrderFragment(List.of(defaultOrderFragment));
            return;
        }
        List orderFragmentList = OrderFragment.fromOrderPageParams((OrderPageParam)orderPageParam);
        orderFragmentList.forEach(paramOrderFragment -> {
            if (paramOrderFragment.getFieldName().startsWith("ext")) {
                this.handleExtFieldsOrderFragment((OrderFragment)paramOrderFragment);
            } else if (ORDER_FIELD_MAP.containsKey(paramOrderFragment.getFieldName())) {
                paramOrderFragment.setFieldName(ORDER_FIELD_MAP.get(paramOrderFragment.getFieldName()));
            } else {
                paramOrderFragment.setFieldName("t." + paramOrderFragment.getFieldName());
            }
        });
        this.setOrderFragment(orderFragmentList);
    }

    public static FlowTaskQuery fromFlowTaskHandledPageDto(FlowTaskHandledPageDto dto) {
        FlowTaskQuery flowTaskQuery = new FlowTaskQuery();
        if (flowTaskQuery.initByFlowTaskTodoPageDto((FlowTaskTodoPageDto)dto)) {
            flowTaskQuery.setNotStatus(List.of(FlowTaskStatus.DELETED, FlowTaskStatus.RUNNING, FlowTaskStatus.SUSPENDED, FlowTaskStatus.WAIT_STARTER_FILL_SAME_NODE));
            flowTaskQuery.setStatus(null);
        }
        flowTaskQuery.setMaxTaskEndTime(dto.getMaxEndTime());
        flowTaskQuery.setMinTaskEndTime(dto.getMinEndTime());
        flowTaskQuery.calOrderFragment((OrderPageParam)dto, new OrderFragment("t.end_time", "DESC"));
        return flowTaskQuery;
    }

    static {
        ORDER_FIELD_MAP.put("businessKey", "i.business_key");
        ORDER_FIELD_MAP.put("business_key", "i.business_key");
        ORDER_FIELD_MAP.put("flowInstanceId", "i.id");
        ORDER_FIELD_MAP.put("flow_instance_id", "i.id");
        ORDER_FIELD_MAP.put("taskName", "t.task_name");
        ORDER_FIELD_MAP.put("task_name", "t.task_name");
        ORDER_FIELD_MAP.put("instanceName", "i.instance_name");
        ORDER_FIELD_MAP.put("instance_name", "i.instance_name");
        ORDER_FIELD_MAP.put("instanceStartTime", "i.start_time");
        ORDER_FIELD_MAP.put("instance_start_time", "i.start_time");
        ORDER_FIELD_MAP.put("startUserId", "i.start_user_id");
        ORDER_FIELD_MAP.put("start_user_id", "i.start_user_id");
        ORDER_FIELD_MAP.put("startUserName", "i.start_user_name");
        ORDER_FIELD_MAP.put("start_user_name", "i.start_user_name");
        ORDER_FIELD_MAP.put("flowInstanceStatus", "i.status");
        ORDER_FIELD_MAP.put("flow_instance_status", "i.status");
        ORDER_FIELD_MAP.put("categoryId", "c.id");
        ORDER_FIELD_MAP.put("category_id", "c.id");
        ORDER_FIELD_MAP.put("categoryName", "c.name");
        ORDER_FIELD_MAP.put("category_name", "c.name");
        ORDER_FIELD_MAP.put("flowProjectCode", "p.code_name");
        ORDER_FIELD_MAP.put("flow_project_code", "p.code_name");
        ORDER_FIELD_MAP.put("editFormUrl", "t.edit_form_url");
        ORDER_FIELD_MAP.put("edit_form_url", "t.edit_form_url");
        ORDER_FIELD_MAP.put("formType", "t.form_type");
        ORDER_FIELD_MAP.put("form_type", "t.form_type");
        ORDER_FIELD_MAP.put("bizDataFlowStatus", "i.biz_data_flow_status");
        ORDER_FIELD_MAP.put("biz_data_flow_status", "i.biz_data_flow_status");
    }
}

