/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.domain.task.service;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.flow.api.common.vo.IdNameVo;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.task.dto.FlowTaskCcDto;
import com.cyberway.mp.flow.api.task.dto.MdmFlowTaskInfoPageDto;
import com.cyberway.mp.flow.api.task.enums.CountersignResult;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.api.task.enums.FlowTaskType;
import com.cyberway.mp.flow.domain.instance.entity.FlowCc;
import com.cyberway.mp.flow.domain.instance.repository.FlowCcRepository;
import com.cyberway.mp.flow.domain.project.entity.FlowProject;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskForUrgeStarter;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithBusinessKey;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import com.cyberway.mp.flow.domain.task.repository.FlowTaskRepository;
import com.cyberway.mp.flow.domain.task.repository.query.FlowTaskQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FlowTaskService {
    private final FlowTaskRepository flowTaskRepository;
    private final FlowCcRepository flowCcRepository;

    public FlowTaskService(FlowTaskRepository flowTaskRepository, FlowCcRepository flowCcRepository) {
        this.flowTaskRepository = flowTaskRepository;
        this.flowCcRepository = flowCcRepository;
    }

    public void createFlowTask(FlowTask flowTask) {
        this.flowTaskRepository.save((Object)flowTask);
    }

    public FlowTask getFlowTask(long id) {
        return (FlowTask)((Object)this.flowTaskRepository.findOne(id));
    }

    public FlowTaskWithProject getFlowTaskIgnoreTenant(long id) {
        return this.flowTaskRepository.getIgnoreTenant(id);
    }

    public FlowTaskWithBusinessKey getFlowTaskWithBusinessKey(long id) {
        FlowTaskQuery query = new FlowTaskQuery();
        query.setId(id);
        List<FlowTaskWithBusinessKey> list = this.flowTaskRepository.searchFlowTaskWithBusinessKeyNoPage(query);
        return list.isEmpty() ? null : list.get(0);
    }

    public FlowTaskWithProject getFlowTaskWithProject(long id) {
        return this.flowTaskRepository.getFlowTaskWithProject(id);
    }

    public FlowTask getFlowTaskByTaskId(String taskId) {
        List<FlowTask> list = this.flowTaskRepository.findByTaskId(taskId);
        return list.isEmpty() ? null : list.get(0);
    }

    public FlowTaskWithBusinessKey getFlowTaskWithBusinessKeyByTaskId(String taskId) {
        FlowTaskQuery query = new FlowTaskQuery();
        query.setTaskId(taskId);
        List<FlowTaskWithBusinessKey> list = this.flowTaskRepository.searchFlowTaskWithBusinessKeyNoPage(query);
        return list.isEmpty() ? null : list.get(0);
    }

    public List<FlowTask> batchGetFlowTask(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.flowTaskRepository.findByIdIn(ids);
    }

    public List<FlowTask> batchGetFlowTaskByFlowInstanceIds(Collection<Long> flowInstanceIds) {
        return this.flowTaskRepository.findByFlowInstanceIdIn(flowInstanceIds);
    }

    public List<FlowTaskWithProject> batchGetFlowTaskWithProject(Collection<Long> ids) {
        return this.flowTaskRepository.batchGetFlowTaskWithProject(ids);
    }

    public void modifyFlowTask(FlowTask flowTask) {
        this.flowTaskRepository.updateById((Object)flowTask, (Long)flowTask.getId());
    }

    public List<FlowTaskWithBusinessKey> listFlowTaskWithBusinessKey(FlowTaskQuery query) {
        return this.flowTaskRepository.searchFlowTaskWithBusinessKeyNoPage(query);
    }

    public long countFlowTaskWithBusinessKey(FlowTaskQuery query) {
        return this.flowTaskRepository.countFlowTaskWithBusinessKey(query);
    }

    public List<FlowTaskWithBusinessKey> pageQueryFlowTaskWithBusinessKey(FlowTaskQuery query, PageParam pageParam) {
        return this.flowTaskRepository.searchFlowTaskWithBusinessKey(query, pageParam);
    }

    public List<FlowTaskWithBusinessKey> pageQueryMdmFlowTaskWithBusinessKey(MdmFlowTaskInfoPageDto dto) {
        return this.flowTaskRepository.searchFlowTaskWithBusinessKey(FlowTaskQuery.fromMdmFlowTaskInfoPageDto(dto), (PageParam)dto);
    }

    public List<FlowTaskForUrgeStarter> listForUrgeStarter() {
        return this.flowTaskRepository.listForUrgeStarter(new Date());
    }

    public void markUrgeStarter(long id, boolean addUrgeTimes) {
        this.flowTaskRepository.markUrgeStarter(id, FlowConstant.EMPTY_MAX_TIME, addUrgeTimes);
    }

    public List<FlowTaskWithProject> listForUrgeSpecial() {
        return this.flowTaskRepository.listForUrgeSpecial(new Date());
    }

    public void markUrgeSpecial(long id, boolean addUrgeTimes) {
        this.flowTaskRepository.markUrgeSpecial(id, FlowConstant.EMPTY_MAX_TIME, addUrgeTimes);
    }

    public List<FlowTaskWithProject> listForDueHandle() {
        return this.flowTaskRepository.listForDueHandle(new Date());
    }

    public List<FlowTaskWithProject> listForUrgeAssignee() {
        return this.flowTaskRepository.listForUrgeAssignee(new Date());
    }

    public void markUrgeAssignee(long id, Date nextTime, boolean addUrgeTimes) {
        this.flowTaskRepository.markUrgeAssignee(id, nextTime, addUrgeTimes);
    }

    public boolean isOldAssignee(long flowInstanceId, long userId) {
        return this.flowTaskRepository.isOldAssignee(flowInstanceId, userId, FlowConstant.EMPTY_MIN_TIME) > 0L;
    }

    public Set<IdNameVo> listAllAssigneeInFlow(long flowInstanceId) {
        return new HashSet<IdNameVo>(this.flowTaskRepository.listAllAssignee(flowInstanceId));
    }

    public List<FlowTask> listByFlowInstance(long flowInstanceId) {
        return this.flowTaskRepository.findByFlowInstanceIdOrderByStartTimeDesc(flowInstanceId);
    }

    public List<FlowTask> listByFlowInstanceAsc(long flowInstanceId) {
        return this.flowTaskRepository.findByFlowInstanceIdOrderByStartTimeAsc(flowInstanceId);
    }

    public List<FlowTask> listByFlowInstanceAndNodeKey(long flowInstanceId, String nodeKey) {
        return this.flowTaskRepository.findByFlowInstanceIdAndNodeKeyOrderByStartTimeDesc(flowInstanceId, nodeKey);
    }

    public boolean hasSameAssigneeCompleted(long flowInstanceId, long assigneeUserId) {
        return this.flowTaskRepository.countApprovalSameAssignee(flowInstanceId, assigneeUserId) > 0L;
    }

    public boolean hasSameAssigneeCompletedInNodes(long flowInstanceId, long assigneeUserId, Collection<String> nodeKeys) {
        return this.flowTaskRepository.countApprovalSameAssigneeInNodes(flowInstanceId, assigneeUserId, nodeKeys) > 0L;
    }

    public void updateFinStatus(long id, FlowTaskStatus status, FlowTaskDeleteReason deleteReason, String opinion, Date endTime) {
        FlowTask flowTask = new FlowTask();
        flowTask.setId(Long.valueOf(id));
        flowTask.setStatus(status);
        flowTask.setDeleteReason(deleteReason);
        flowTask.setEndTime(endTime);
        flowTask.setOpinion(opinion);
        flowTask.setActionUserId(ServiceContext.getContext().getRequestUserId());
        flowTask.setActionUserName(ServiceContext.getContext().getRequestUserName());
        this.flowTaskRepository.updateById((Object)flowTask, id);
    }

    public void updateFinStatusAllRunning(long flowInstanceId, FlowTaskStatus status, FlowTaskDeleteReason deleteReason, String opinion, Date endTime) {
        this.flowTaskRepository.updateFinStatusAllRunning(flowInstanceId, status, deleteReason, StringUtils.defaultString((String)opinion), endTime, ServiceContext.getContext().getRequestUserId(), ServiceContext.getContext().getRequestUserName());
    }

    public void updateCountersignResult(long id, CountersignResult countersignResult) {
        FlowTask flowTask = new FlowTask();
        flowTask.setId(Long.valueOf(id));
        flowTask.setCountersignResult(countersignResult);
        this.flowTaskRepository.updateById((Object)flowTask, id);
    }

    public List<FlowTask> findByIdAndStatus(long id, String status) {
        return this.flowTaskRepository.findByIdAndStatus(id, status);
    }

    public List<FlowTask> findByFlowInstanceIdAndStatus(long flowInstanceId, String status) {
        return this.flowTaskRepository.findByFlowInstanceIdAndStatus(flowInstanceId, status);
    }

    public void addUrgeTimes(long id) {
        this.flowTaskRepository.addUrgeTimes(id);
    }

    public List<FlowTask> listRunningTasksForInstances(Collection<Long> flowInstanceIds) {
        return this.flowTaskRepository.findByFlowInstanceIdInAndStatusIn(flowInstanceIds, List.of(FlowTaskStatus.RUNNING, FlowTaskStatus.SUSPENDED, FlowTaskStatus.WAIT_STARTER_FILL, FlowTaskStatus.WAIT_STARTER_FILL_SAME_NODE));
    }

    public List<FlowTask> listCompletedTasksForInstances(Collection<Long> flowInstanceIds) {
        return this.flowTaskRepository.findByFlowInstanceIdInAndStatusIn(flowInstanceIds, List.of(FlowTaskStatus.COMPLETED));
    }

    public void createFlowDraftTaskIfMissing(Long flowInstanceId, FlowProject flowProject) {
        List<FlowTask> draftTasks = this.flowTaskRepository.findByFlowInstanceIdInAndStatusIn(Collections.singletonList(flowInstanceId), Collections.singletonList(FlowTaskStatus.DRAFT));
        if (CollectionUtils.isEmpty(draftTasks)) {
            FlowTask flowTask = FlowTask.initCustomTask(flowInstanceId, FlowTaskType.DRAFT, "\u8349\u7a3f", ServiceContext.getContext().getRequestUserId(), ServiceContext.getContext().getRequestUserName(), flowProject);
            flowTask.setStatus(FlowTaskStatus.DRAFT);
            this.flowTaskRepository.save((Object)flowTask);
        }
    }

    public void removeFlowDraftTask(List<Long> instanceIds) {
        if (CollectionUtils.isNotEmpty(instanceIds)) {
            this.flowTaskRepository.deleteByFlowInstanceIdInAndStatus(instanceIds, FlowTaskStatus.DRAFT);
        }
    }

    public void ccToUsers(FlowTaskCcDto dto, FlowTask task) {
        List<FlowCc> flowCcList = FlowCc.fromFlowTaskCcDto(dto, task);
        this.flowCcRepository.batchInsert(flowCcList);
    }

    public List<FlowTask> listTasksForNode(Long flowNodeId) {
        return this.flowTaskRepository.findByFlowNodeId(flowNodeId);
    }

    public void updateStatus(long id, FlowTaskStatus status) {
        FlowTask flowTask = new FlowTask();
        flowTask.setId(Long.valueOf(id));
        flowTask.setStatus(status);
        this.flowTaskRepository.updateById((Object)flowTask, id);
    }

    public void updateStatusAndRefreshActionUser(FlowTask task) {
        FlowTask flowTask = new FlowTask();
        flowTask.setId((Long)task.getId());
        flowTask.setStatus(task.getStatus());
        flowTask.setActionUserId(ServiceContext.getContext().getRequestUserId());
        flowTask.setActionUserName(ServiceContext.getContext().getRequestUserName());
        flowTask.setOpinion(task.getOpinion());
        task.setActionUserId(flowTask.getActionUserId());
        task.setActionUserName(flowTask.getActionUserName());
        this.flowTaskRepository.updateById((Object)flowTask, (Long)flowTask.getId());
    }

    public void updateStatusAndLastStartTime(long id, FlowTaskStatus status, Date lastStartTime) {
        FlowTask flowTask = new FlowTask();
        flowTask.setId(Long.valueOf(id));
        flowTask.setStatus(status);
        flowTask.setLastStartTime(lastStartTime);
        this.flowTaskRepository.updateById((Object)flowTask, id);
    }

    public List<FlowTask> listRunningStartFillTask(long flowInstanceId) {
        return this.flowTaskRepository.findByFlowInstanceIdAndStatusAndTaskType(flowInstanceId, FlowTaskStatus.RUNNING.name(), FlowTaskType.STARTER_FILL);
    }
}

