/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.interceptor;

import com.cyberway.mp.flow.infra.interceptor.AbstractReplaceSqlInterceptor;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MultiSaveInterceptor
extends AbstractReplaceSqlInterceptor {
    private static final Set<String> STOP_WORDS = Set.of("set", "select", "values");
    private final char[][] matchTableNamesArray;
    private final Map<String, String[]> tableNamesMap;

    public MultiSaveInterceptor(Map<String, String[]> tableNamesMap) {
        this.tableNamesMap = tableNamesMap;
        this.matchTableNamesArray = new char[tableNamesMap.size() + STOP_WORDS.size()][];
        AtomicInteger count = new AtomicInteger(0);
        for (String tableName : tableNamesMap.keySet()) {
            this.matchTableNamesArray[count.getAndIncrement()] = tableName.toCharArray();
        }
        for (String stopWord : STOP_WORDS) {
            this.matchTableNamesArray[count.getAndIncrement()] = stopWord.toCharArray();
        }
    }

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        Object parameter = invocation.getArgs()[1];
        BoundSql boundSql = ms.getSqlSource().getBoundSql(invocation.getArgs()[1]);
        String sql = boundSql.getSql();
        Triple<Integer, Integer, String> replaceTable = this.findReplaceTable(sql);
        if ((Integer)replaceTable.getLeft() < 0) {
            return invocation.proceed();
        }
        String[] replaceTables = this.tableNamesMap.get(replaceTable.getRight());
        Executor executor = (Executor)invocation.getTarget();
        for (String table : replaceTables) {
            String newSql = sql.substring(0, (Integer)replaceTable.getLeft()) + table + sql.substring((Integer)replaceTable.getMiddle());
            MappedStatement replaceMs = this.buildNewMappedStatement(ms, boundSql, newSql);
            executor.update(replaceMs, parameter);
        }
        return invocation.proceed();
    }

    public Triple<Integer, Integer, String> findReplaceTable(String sql) {
        char[] charArray = sql.toCharArray();
        AbstractReplaceSqlInterceptor.MatchingInfo matchingInfo = new AbstractReplaceSqlInterceptor.MatchingInfo();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (SPECIAL_CHARS.contains(Character.valueOf(c))) {
                Triple<Integer, Integer, String> result = this.handleSpecialChar(matchingInfo, i, c);
                if (result == null) continue;
                return result;
            }
            char lowerCaseChar = Character.toLowerCase(c);
            if (matchingInfo.preBlank) {
                this.matchStartChar(this.matchTableNamesArray, matchingInfo, lowerCaseChar, i);
                continue;
            }
            if (matchingInfo.matchingTableIndexes.length <= 0) continue;
            this.matchNextChar(this.matchTableNamesArray, matchingInfo, lowerCaseChar);
        }
        return Triple.of((Object)-1, (Object)-1, (Object)"");
    }

    private Triple<Integer, Integer, String> handleSpecialChar(AbstractReplaceSqlInterceptor.MatchingInfo matchingInfo, int i, char c) {
        if (matchingInfo.matchingTableIndexes.length > 0) {
            Integer[] integerArray = matchingInfo.matchingTableIndexes;
            int n = integerArray.length;
            for (int j = 0; j < n; ++j) {
                int matchingTableIndex = integerArray[j];
                if (this.matchTableNamesArray[matchingTableIndex].length != matchingInfo.matchingIndex) continue;
                if (matchingTableIndex >= this.tableNamesMap.size()) {
                    return Triple.of((Object)-1, (Object)-1, (Object)"");
                }
                return Triple.of((Object)matchingInfo.startIndex, (Object)i, (Object)new String(this.matchTableNamesArray[matchingTableIndex]));
            }
            matchingInfo.matchingTableIndexes = new Integer[0];
        }
        if (c == ' ') {
            matchingInfo.preBlank = true;
        } else if (c == '(') {
            return Triple.of((Object)-1, (Object)-1, (Object)"");
        }
        return null;
    }
}

