/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.interceptor;

import com.cyberway.mp.flow.infra.annotation.ReplaceQueryTable;
import com.cyberway.mp.flow.infra.interceptor.AbstractReplaceSqlInterceptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.core.annotation.AnnotationUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class ReplaceQueryTableInterceptor
extends AbstractReplaceSqlInterceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        String msId = ms.getId();
        int lastDotIndex = msId.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return invocation.proceed();
        }
        String mapperClassName = msId.substring(0, lastDotIndex);
        String mapperMethodName = msId.substring(lastDotIndex + 1);
        Class<?> mapperClass = Class.forName(mapperClassName);
        Optional<Method> mapperMethodOptional = Arrays.stream(mapperClass.getMethods()).filter(m -> mapperMethodName.equals(m.getName())).findAny();
        if (mapperMethodOptional.isEmpty()) {
            return invocation.proceed();
        }
        Method mapperMethod = mapperMethodOptional.get();
        ReplaceQueryTable annotation = (ReplaceQueryTable)AnnotationUtils.findAnnotation((Method)mapperMethod, ReplaceQueryTable.class);
        if (annotation == null) {
            return invocation.proceed();
        }
        if (annotation.sourceTables().length == 0 || annotation.sourceTables().length != annotation.targetTables().length) {
            return invocation.proceed();
        }
        BoundSql boundSql = ms.getSqlSource().getBoundSql(invocation.getArgs()[1]);
        String sql = boundSql.getSql();
        String newSql = this.replaceSql(sql, annotation.sourceTables(), annotation.targetTables());
        MappedStatement replaceMs = this.buildNewMappedStatement(ms, boundSql, newSql);
        invocation.getArgs()[0] = replaceMs;
        return invocation.proceed();
    }

    private String replaceSql(String sql, String[] sourceTables, String[] targetTables) {
        StringBuilder newSql = new StringBuilder();
        char[] charArray = sql.toCharArray();
        char[][] matchTableNamesArray = new char[sourceTables.length][];
        for (int i = 0; i < sourceTables.length; ++i) {
            matchTableNamesArray[i] = sourceTables[i].toCharArray();
        }
        AbstractReplaceSqlInterceptor.MatchingInfo matchingInfo = new AbstractReplaceSqlInterceptor.MatchingInfo();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (SPECIAL_CHARS.contains(Character.valueOf(c))) {
                ReplaceQueryTableInterceptor.matchSpecialChar(sql, targetTables, matchingInfo, matchTableNamesArray, newSql, i, c);
                continue;
            }
            if (matchingInfo.preBlank) {
                this.matchStartChar(matchTableNamesArray, matchingInfo, Character.toLowerCase(c), i);
                continue;
            }
            if (matchingInfo.matchingTableIndexes.length > 0) {
                this.matchNextChar(matchTableNamesArray, matchingInfo, Character.toLowerCase(c));
                continue;
            }
            if (matchingInfo.startIndex > -1) {
                newSql.append(sql, matchingInfo.startIndex, i);
                matchingInfo.startIndex = -1;
                newSql.append(c);
                continue;
            }
            newSql.append(c);
        }
        if (matchingInfo.startIndex > -1) {
            newSql.append(sql.substring(matchingInfo.startIndex));
        }
        return newSql.toString();
    }

    private static void matchSpecialChar(String sql, String[] targetTables, AbstractReplaceSqlInterceptor.MatchingInfo matchingInfo, char[][] matchTableNamesArray, StringBuilder newSql, int i, char c) {
        if (matchingInfo.matchingTableIndexes.length > 0) {
            boolean matched = false;
            Integer[] integerArray = matchingInfo.matchingTableIndexes;
            int n = integerArray.length;
            for (int j = 0; j < n; ++j) {
                int matchingTableIndex = integerArray[j];
                if (matchTableNamesArray[matchingTableIndex].length != matchingInfo.matchingIndex) continue;
                newSql.append(targetTables[matchingTableIndex]);
                matched = true;
                break;
            }
            if (!matched) {
                newSql.append(sql, matchingInfo.startIndex, i);
            }
            matchingInfo.startIndex = -1;
            matchingInfo.matchingTableIndexes = new Integer[0];
        } else if (matchingInfo.startIndex > -1) {
            newSql.append(sql, matchingInfo.startIndex, i);
            matchingInfo.startIndex = -1;
        }
        if (c == ' ') {
            matchingInfo.preBlank = true;
        }
        newSql.append(c);
    }
}

