/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.listener;

import com.cyberway.mp.bc.event.anotation.FrameworkEventHandler;
import com.cyberway.mp.bc.event.anotation.FrameworkEventListener;
import com.cyberway.mp.flow.infra.service.MailHelperService;
import com.cyberway.mp.mc.api.pull.dto.MailMessagePullDto;
import com.cyberway.mp.mc.api.pull.dto.MessagePullEventDto;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.util.CollectionUtils;

@FrameworkEventListener(value={MessagePullEventDto.class}, queue="TASK_APPROVAL_MAIL_NOTICE", route="TASK_APPROVAL_MAIL_NOTICE")
public class MessagePullNoticeListener {
    private final MailHelperService mailHelperService;

    public MessagePullNoticeListener(MailHelperService mailHelperService) {
        this.mailHelperService = mailHelperService;
    }

    @FrameworkEventHandler
    public void handler(MessagePullEventDto<MailMessagePullDto> messagePullEventDto) {
        List mailMessagePulls = messagePullEventDto.getMessagePullDtos();
        if (CollectionUtils.isEmpty((Collection)mailMessagePulls)) {
            return;
        }
        HashSet handledFlowInstanceIds = new HashSet();
        mailMessagePulls.forEach(mailMessagePullDto -> {
            String sender = mailMessagePullDto.getSender();
            String subject = mailMessagePullDto.getSubject();
            String body = mailMessagePullDto.getBody().replace("\n", "");
            this.mailHelperService.parseEmailAndApproval(sender, subject, body, handledFlowInstanceIds);
        });
    }
}

