/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.scheduler;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.bc.lock.LockService;
import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.constants.FlowConstant;
import com.cyberway.mp.flow.api.log.enums.UrgeLogType;
import com.cyberway.mp.flow.api.log.enums.UrgeSourceType;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.CalendarDto;
import com.cyberway.mp.flow.api.project.dto.EventTemplateDto;
import com.cyberway.mp.flow.api.project.enums.DueAction;
import com.cyberway.mp.flow.api.project.enums.DueTimeType;
import com.cyberway.mp.flow.api.task.dto.FlowTaskActionDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskAutoActionDto;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.log.entity.FlowUrgeLog;
import com.cyberway.mp.flow.domain.log.service.FlowLogService;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskForUrgeStarter;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import com.cyberway.mp.flow.domain.task.service.FlowTaskService;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import com.cyberway.mp.flow.infra.service.TimeHelperService;
import com.cyberway.mp.mc.api.push.dto.EventPushDto;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class DueHandleScheduler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FlowInstanceService flowInstanceService;
    private final FlowTaskService flowTaskService;
    private final FlowLogService flowLogService;
    private final LockService lockService;
    private final FrameworkEventService frameworkEventService;
    private final FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final FlowEngineService flowEngineService;
    private final TimeHelperService timeHelperService;

    public DueHandleScheduler(FlowInstanceService flowInstanceService, FlowTaskService flowTaskService, FlowLogService flowLogService, LockService lockService, FrameworkEventService frameworkEventService, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, FlowEngineService flowEngineService, TimeHelperService timeHelperService) {
        this.flowInstanceService = flowInstanceService;
        this.flowTaskService = flowTaskService;
        this.flowLogService = flowLogService;
        this.lockService = lockService;
        this.frameworkEventService = frameworkEventService;
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.flowEngineService = flowEngineService;
        this.timeHelperService = timeHelperService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0/1 * * * ?")
    public void dueFlowInstanceHandle() {
        String lockKey = "dueFlowInstanceHandle";
        if (this.lockService.tryLock("dueFlowInstanceHandle", TimeUnit.MILLISECONDS, 1L, -1L)) {
            try {
                HashMap<Long, List> templateDtoMap = new HashMap<Long, List>(16);
                List<FlowInstance> instances = this.flowInstanceService.listForDueNotice();
                ServiceContext context = ServiceContext.getContext();
                for (FlowInstance instance : instances) {
                    context.set("req.tenantId", (Object)instance.getTenantId().toString());
                    context.set("req.businessZoneId", (Object)instance.getBusinessZoneId().toString());
                    context.set("req.appInstanceId", (Object)instance.getAppInstanceId().toString());
                    context.set("req.userId", (Object)instance.getStartUserId().toString());
                    context.set("req.userName", (Object)instance.getStartUserName());
                    List templateDtoList = templateDtoMap.computeIfAbsent(instance.getFlowProjectId(), flowProjectId -> this.flowProjectConfigCacheRepository.getGlobalConfig((long)flowProjectId).getDueTemplate());
                    boolean addUrgeTimes = this.urgeInstanceStarter(instance, templateDtoList);
                    this.flowInstanceService.markDueNoticed((Long)instance.getId(), addUrgeTimes);
                }
            }
            finally {
                this.lockService.unlock("dueFlowInstanceHandle");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="5 0/1 * * * ?")
    public void urgeFlowStarter() {
        String lockKey = "urgeFlowStarter";
        if (this.lockService.tryLock("urgeFlowStarter", TimeUnit.MILLISECONDS, 1L, -1L)) {
            try {
                HashMap<Long, List> templateDtoMap = new HashMap<Long, List>(16);
                List<FlowInstance> instances = this.flowInstanceService.listForUrgeStarter();
                for (FlowInstance instance : instances) {
                    List templateDtoList = templateDtoMap.computeIfAbsent(instance.getFlowProjectId(), flowProjectId -> this.flowProjectConfigCacheRepository.getGlobalConfig((long)flowProjectId).getNoticeStarterDueTemplate());
                    boolean addUrgeTimes = this.urgeInstanceStarter(instance, templateDtoList);
                    this.flowInstanceService.markUrgeStarter((Long)instance.getId(), addUrgeTimes);
                }
            }
            finally {
                this.lockService.unlock("urgeFlowStarter");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="10 0/1 * * * ?")
    public void urgeFlowSpecial() {
        String lockKey = "urgeFlowSpecial";
        if (this.lockService.tryLock("urgeFlowSpecial", TimeUnit.MILLISECONDS, 1L, -1L)) {
            try {
                HashMap<Long, List> templateDtoMap = new HashMap<Long, List>(16);
                List<FlowInstance> instances = this.flowInstanceService.listForUrgeSpecial();
                HashMap<Long, List> specialMap = new HashMap<Long, List>(16);
                for (FlowInstance instance : instances) {
                    List specialUsers;
                    List templateDtoList;
                    if (this.pushEvent(instance, (List<EventTemplateDto>)(templateDtoList = templateDtoMap.computeIfAbsent(instance.getFlowProjectId(), flowProjectId -> this.flowProjectConfigCacheRepository.getGlobalConfig((long)flowProjectId).getNoticeSpecialUserDueTemplate())), (List<IdNameDto>)(specialUsers = specialMap.computeIfAbsent(instance.getFlowProjectId(), flowProjectId -> this.flowProjectConfigCacheRepository.getGlobalConfig((long)flowProjectId).getNoticeSpecialUsers())))) {
                        FlowUrgeLog flowUrgeLog = this.buildFlowUrgeLog(instance, templateDtoList);
                        flowUrgeLog.setUrgeSpecialUser(true);
                        flowUrgeLog.setSpecialUsers(JSON.toJSONString((Object)specialUsers));
                        this.flowLogService.createFlowUrgeLog(flowUrgeLog);
                        this.flowInstanceService.markUrgeSpecial((Long)instance.getId(), true);
                        continue;
                    }
                    this.flowInstanceService.markUrgeSpecial((Long)instance.getId(), false);
                }
            }
            finally {
                this.lockService.unlock("urgeFlowSpecial");
            }
        }
    }

    @Scheduled(cron="15 0/1 * * * ?")
    public void urgeTaskAssignee() {
        String lockKey = "urgeTaskAssignee";
        if (this.lockService.tryLock("urgeTaskAssignee", TimeUnit.MILLISECONDS, 1L, -1L)) {
            try {
                this.flowTaskService.listForUrgeAssignee().forEach(this::urgeTaskAssignee);
            }
            finally {
                this.lockService.unlock("urgeTaskAssignee");
            }
        }
    }

    private void urgeTaskAssignee(FlowTaskWithProject task) {
        boolean needRepeat;
        ApprovalNodeConfigDto approvalNodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(task);
        List templateDtoList = approvalNodeConfig.getUrgeAssigneeTemplate();
        if (!this.pushEvent(task, templateDtoList, task.getAssigneeUserId(), task.getAssigneeUserName())) {
            this.flowTaskService.markUrgeAssignee((Long)task.getId(), FlowConstant.EMPTY_MAX_TIME, false);
            return;
        }
        int urgeCount = task.getUrgeAssigneeCount() + 1;
        Integer repeatTime = (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeAssigneeRepeatTime(), (Object)0);
        Integer repeatDay = (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeAssigneeRepeatDay(), (Object)0);
        Integer repeatHour = (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeAssigneeRepeatHour(), (Object)0);
        Integer repeatMinute = (Integer)ObjectUtils.defaultIfNull((Object)approvalNodeConfig.getUrgeAssigneeRepeatMinute(), (Object)0);
        boolean bl = needRepeat = Boolean.TRUE.equals(approvalNodeConfig.getUrgeAssigneeRepeat()) && urgeCount <= repeatTime && (repeatDay > 0 || repeatHour > 0 || repeatMinute > 0);
        if (needRepeat) {
            CalendarDto calendarDto = approvalNodeConfig.getUrgeAssigneeRepeatTimeCalendar();
            String calendarCode = calendarDto == null ? null : calendarDto.getCode();
            Date nextTime = this.timeHelperService.calDueTime(calendarCode, task.getNextUrgeAssigneeTime(), DueTimeType.WORK_DAY.equals((Object)approvalNodeConfig.getUrgeAssigneeRepeatTimeCalculationType()), repeatDay, repeatHour, repeatMinute);
            this.flowTaskService.markUrgeAssignee((Long)task.getId(), nextTime, true);
        } else {
            this.flowTaskService.markUrgeAssignee((Long)task.getId(), FlowConstant.EMPTY_MAX_TIME, true);
        }
        FlowUrgeLog flowUrgeLog = this.buildFlowUrgeLog(task.getFlowInstanceId(), task, (Long)task.getId(), templateDtoList);
        flowUrgeLog.setUrgeAssignee(true);
        flowUrgeLog.setAssigneeId(task.getAssigneeUserId());
        flowUrgeLog.setAssigneeName(task.getAssigneeUserName());
        this.flowLogService.createFlowUrgeLog(flowUrgeLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="20 0/1 * * * ?")
    public void urgeTaskStarter() {
        String lockKey = "urgeTaskStarter";
        if (this.lockService.tryLock("urgeTaskStarter", TimeUnit.MILLISECONDS, 1L, -1L)) {
            try {
                List<FlowTaskForUrgeStarter> tasks = this.flowTaskService.listForUrgeStarter();
                for (FlowTaskForUrgeStarter task : tasks) {
                    List templateDtoList;
                    if (this.pushEvent(task, templateDtoList = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(task).getUrgeStarterTemplate(), task.getStartUserId(), task.getStartUserName())) {
                        FlowUrgeLog flowUrgeLog = this.buildFlowUrgeLog(task.getFlowInstanceId(), task, (Long)task.getId(), templateDtoList);
                        flowUrgeLog.setUrgeStarter(true);
                        flowUrgeLog.setStarterId(task.getStartUserId());
                        flowUrgeLog.setStarterName(task.getStartUserName());
                        this.flowLogService.createFlowUrgeLog(flowUrgeLog);
                        this.flowTaskService.markUrgeStarter((Long)task.getId(), true);
                        continue;
                    }
                    this.flowTaskService.markUrgeStarter((Long)task.getId(), false);
                }
            }
            finally {
                this.lockService.unlock("urgeTaskStarter");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="25 0/1 * * * ?")
    public void urgeTaskSpecial() {
        String lockKey = "urgeTaskSpecial";
        if (this.lockService.tryLock("urgeTaskSpecial", TimeUnit.MILLISECONDS, 1L, -1L)) {
            try {
                List<FlowTaskWithProject> tasks = this.flowTaskService.listForUrgeSpecial();
                HashMap<Long, List> specialMap = new HashMap<Long, List>(16);
                for (FlowTaskWithProject task : tasks) {
                    List specialUsers;
                    List templateDtoList;
                    if (this.pushEvent(task, (List<EventTemplateDto>)(templateDtoList = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(task).getUrgeSpecialTemplate()), (List<IdNameDto>)(specialUsers = specialMap.computeIfAbsent(task.getFlowProjectId(), flowProjectId -> this.flowProjectConfigCacheRepository.getGlobalConfig((long)flowProjectId).getNoticeSpecialUsers())))) {
                        FlowUrgeLog flowUrgeLog = this.buildFlowUrgeLog(task.getFlowInstanceId(), task, (Long)task.getId(), templateDtoList);
                        flowUrgeLog.setUrgeSpecialUser(true);
                        flowUrgeLog.setSpecialUsers(JSON.toJSONString((Object)specialUsers));
                        this.flowLogService.createFlowUrgeLog(flowUrgeLog);
                        this.flowTaskService.markUrgeSpecial((Long)task.getId(), true);
                        continue;
                    }
                    this.flowTaskService.markUrgeSpecial((Long)task.getId(), false);
                }
            }
            finally {
                this.lockService.unlock("urgeTaskSpecial");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0/1 * * * ?")
    public void handleTaskDue() {
        String lockKey = "handleTaskDue";
        if (this.lockService.tryLock("handleTaskDue", TimeUnit.MILLISECONDS, 1L, -1L)) {
            try {
                List<FlowTaskWithProject> tasks = this.flowTaskService.listForDueHandle();
                ServiceContext context = ServiceContext.getContext();
                for (FlowTaskWithProject task : tasks) {
                    FlowTaskAutoActionDto dto;
                    DueAction dueAction = task.getDueAction();
                    context.set("req.tenantId", (Object)task.getTenantId().toString());
                    context.set("req.businessZoneId", (Object)task.getBusinessZoneId().toString());
                    context.set("req.appInstanceId", (Object)task.getAppInstanceId().toString());
                    context.set("req.userId", (Object)task.getAssigneeUserId().toString());
                    context.set("req.userName", (Object)task.getAssigneeUserName());
                    if (DueAction.AUTO_APPROVE.equals((Object)dueAction)) {
                        dto = new FlowTaskAutoActionDto("", null, FlowConstant.AUTO_COMPLETE_FLAG_DUE);
                        this.flowEngineService.completeTask(task, (FlowTaskActionDto)dto, true);
                        continue;
                    }
                    if (!DueAction.AUTO_REJECT.equals((Object)dueAction)) continue;
                    dto = new FlowTaskAutoActionDto("", null, FlowConstant.AUTO_COMPLETE_FLAG_DUE);
                    this.flowEngineService.rejectTask(task, (FlowTaskActionDto)dto, true);
                }
            }
            finally {
                this.lockService.unlock("handleTaskDue");
            }
        }
    }

    private boolean urgeInstanceStarter(FlowInstance flowInstance, List<EventTemplateDto> templateDtoList) {
        if (templateDtoList == null || templateDtoList.isEmpty()) {
            return false;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(this.flowEngineService.getVariablesByProcessInstanceId(flowInstance.getProcessInstanceId()));
        paramsMap.put("flowInstance", (Object)flowInstance);
        List<String> templateCodes = templateDtoList.stream().map(EventTemplateDto::getCode).collect(Collectors.toList());
        this.pushEvent(flowInstance.getTenantId(), flowInstance.getAppInstanceId(), templateCodes, flowInstance.getStartUserId(), flowInstance.getStartUserName(), paramsMap);
        FlowUrgeLog flowUrgeLog = this.buildFlowUrgeLog(flowInstance, templateDtoList);
        flowUrgeLog.setUrgeStarter(true);
        flowUrgeLog.setStarterId(flowInstance.getStartUserId());
        flowUrgeLog.setStarterName(flowInstance.getStartUserName());
        this.flowLogService.createFlowUrgeLog(flowUrgeLog);
        return true;
    }

    private boolean pushEvent(FlowInstance flowInstance, List<EventTemplateDto> templateDtoList, List<IdNameDto> users) {
        if (users == null || users.isEmpty() || templateDtoList == null || templateDtoList.isEmpty()) {
            return false;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(this.flowEngineService.getVariablesByProcessInstanceId(flowInstance.getProcessInstanceId()));
        paramsMap.put("flowInstance", (Object)flowInstance);
        List<String> templateCodes = templateDtoList.stream().map(EventTemplateDto::getCode).collect(Collectors.toList());
        for (IdNameDto user : users) {
            this.pushEvent(flowInstance.getTenantId(), flowInstance.getAppInstanceId(), templateCodes, user.getId(), user.getName(), paramsMap);
        }
        return true;
    }

    private boolean pushEvent(FlowTaskWithProject task, List<EventTemplateDto> templateDtoList, Long userId, String userName) {
        if (templateDtoList == null || templateDtoList.isEmpty()) {
            return false;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(this.flowEngineService.getVariablesByTaskId(task.getTaskId()));
        paramsMap.put("flowTask", (Object)task);
        List<String> templateCodes = templateDtoList.stream().map(EventTemplateDto::getCode).collect(Collectors.toList());
        this.pushEvent(task.getTenantId(), task.getAppInstanceId(), templateCodes, userId, userName, paramsMap);
        return true;
    }

    private boolean pushEvent(FlowTaskWithProject task, List<EventTemplateDto> templateDtoList, List<IdNameDto> users) {
        if (users == null || users.isEmpty() || templateDtoList == null || templateDtoList.isEmpty()) {
            return false;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(this.flowEngineService.getVariablesByTaskId(task.getTaskId()));
        paramsMap.put("flowTask", (Object)task);
        List<String> templateCodes = templateDtoList.stream().map(EventTemplateDto::getCode).collect(Collectors.toList());
        for (IdNameDto user : users) {
            this.pushEvent(task.getTenantId(), task.getAppInstanceId(), templateCodes, user.getId(), user.getName(), paramsMap);
        }
        return true;
    }

    private void pushEvent(Long tenantId, Long appInstanceId, List<String> templateCodes, Long userId, String userName, Map<String, Object> paramsMap) {
        EventPushDto eventPushDto = new EventPushDto();
        eventPushDto.setTenantId(tenantId);
        eventPushDto.setInstanceId(appInstanceId);
        eventPushDto.setEventCode("FLOW_URGE");
        eventPushDto.setMessageTemplateCodes(templateCodes);
        eventPushDto.setUserId(userId);
        eventPushDto.setUserName(userName);
        eventPushDto.setParamsMap(paramsMap);
        this.frameworkEventService.pushEvent((FrameworkEvent)eventPushDto);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u53d1\u9001\u50ac\u529e\u6846\u67b6\u4e8b\u4ef6\u6d88\u606f, event: [{}]", (Object)JSON.toJSONString((Object)eventPushDto));
        }
    }

    private FlowUrgeLog buildFlowUrgeLog(FlowInstance flowInstance, List<EventTemplateDto> templateDtoList) {
        return this.buildFlowUrgeLog((Long)flowInstance.getId(), flowInstance, null, templateDtoList);
    }

    private FlowUrgeLog buildFlowUrgeLog(Long flowInstanceId, BusinessEntityWithAppInstance appInstEntity, Long flowTaskId, List<EventTemplateDto> templateDtoList) {
        FlowUrgeLog log = new FlowUrgeLog();
        log.setFlowInstanceId(flowInstanceId);
        log.setTenantId(appInstEntity.getTenantId());
        log.setBusinessZoneId(appInstEntity.getBusinessZoneId());
        log.setAppInstanceId(appInstEntity.getAppInstanceId());
        if (flowTaskId == null) {
            log.setFlowTaskId(FlowConstant.EMPTY_ID_VALUE);
            log.setLogType(UrgeLogType.INSTANCE);
        } else {
            log.setFlowTaskId(flowTaskId);
            log.setLogType(UrgeLogType.TASK);
        }
        log.setSourceType(UrgeSourceType.SYSTEM);
        if (templateDtoList != null) {
            log.setTemplateCodes(templateDtoList.stream().map(EventTemplateDto::getCode).collect(Collectors.joining(",")));
        } else {
            log.setTemplateCodes("");
        }
        log.setUrgeAssignee(false);
        log.setUrgeSpecialUser(false);
        log.setUrgeStarter(false);
        log.setStarterId(FlowConstant.EMPTY_ID_VALUE);
        log.setStarterName("");
        log.setAssigneeId(FlowConstant.EMPTY_ID_VALUE);
        log.setAssigneeName("");
        log.setSpecialUsers("");
        return log;
    }
}

