/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.service;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.model.enums.FlowModelNodeType;
import com.cyberway.mp.flow.api.model.vo.FlowModelLineVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelNodeVo;
import com.cyberway.mp.flow.api.model.vo.FlowModelNodesVo;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.BaseNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GatewayLineConfigDto;
import com.cyberway.mp.flow.api.project.dto.GatewayNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.project.dto.ManualNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.NodesConfigDto;
import com.cyberway.mp.flow.api.project.dto.ReceiveNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.ScriptNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.ServiceNodeConfigDto;
import com.cyberway.mp.flow.domain.model.entity.FlowModel;
import com.cyberway.mp.flow.domain.project.entity.FlowProject;
import com.cyberway.mp.flow.infra.service.FlowDefinitionGenerateService;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BpmnXmlFlowDefinitionGenerateServiceImpl
implements FlowDefinitionGenerateService {
    private static final String TAG_BPMN_ELEMENT = "bpmnElement";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String bpmnElementPrefix = "bpmn:";
    protected String bpmndiElementPrefix = "bpmndi:";
    protected String diElementPrefix = "di:";
    protected String dcElementPrefix = "dc:";

    @Override
    public String generate(FlowModel flowModel, FlowProject flowProject) {
        BpmnInfo bpmnInfo = new BpmnInfo();
        bpmnInfo.document = this.initDocument();
        Element definitions = this.createDefinitions(bpmnInfo.document);
        bpmnInfo.process = this.createProcess(bpmnInfo.document, definitions, flowProject);
        Element diagram = this.createDiagram(bpmnInfo.document, definitions, flowProject);
        bpmnInfo.plane = this.createPlane(bpmnInfo.document, diagram, flowProject);
        FlowModelNodesVo flowModelNodes = (FlowModelNodesVo)JSON.parseObject((String)flowModel.getModelNodes(), FlowModelNodesVo.class);
        NodesConfigDto nodeConfigs = (NodesConfigDto)JSON.parseObject((String)flowProject.getNodeConfigs(), NodesConfigDto.class);
        bpmnInfo.globalConfig = nodeConfigs.getGlobal();
        this.createStartEvent(bpmnInfo, flowModelNodes.getStartNode());
        bpmnInfo.nodeMap.put(flowModelNodes.getStartNode().getNodeKey(), flowModelNodes.getStartNode());
        for (Object endNode : flowModelNodes.getEndNodes()) {
            bpmnInfo.nodeMap.put(endNode.getNodeKey(), (FlowModelNodeVo)endNode);
        }
        Map<String, ApprovalNodeConfigDto> approvalNodeConfigMap = nodeConfigs.getApprovalNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, dto -> dto));
        for (Object approvalNode : flowModelNodes.getApprovalNodes()) {
            this.createUserTask(bpmnInfo, (FlowModelNodeVo)approvalNode, approvalNodeConfigMap.get(approvalNode.getNodeKey()));
            bpmnInfo.nodeMap.put(approvalNode.getNodeKey(), (FlowModelNodeVo)approvalNode);
        }
        Map<String, ServiceNodeConfigDto> serviceNodeConfigMap = nodeConfigs.getServiceNodes().stream().collect(Collectors.toMap(ServiceNodeConfigDto::getNodeKey, dto -> dto));
        for (Object serviceNode : flowModelNodes.getServiceNodes()) {
            this.createServiceTask(bpmnInfo, (FlowModelNodeVo)serviceNode, serviceNodeConfigMap.get(serviceNode.getNodeKey()));
            bpmnInfo.nodeMap.put(serviceNode.getNodeKey(), (FlowModelNodeVo)serviceNode);
        }
        Map<String, ScriptNodeConfigDto> scriptNodeConfigMap = nodeConfigs.getScriptNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, dto -> dto));
        for (Object scriptNode : flowModelNodes.getScriptNodes()) {
            this.createScriptTask(bpmnInfo, (FlowModelNodeVo)scriptNode, scriptNodeConfigMap.get(scriptNode.getNodeKey()));
            bpmnInfo.nodeMap.put(scriptNode.getNodeKey(), (FlowModelNodeVo)scriptNode);
        }
        Map<String, ReceiveNodeConfigDto> receiveNodeConfigMap = nodeConfigs.getReceiveNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, dto -> dto));
        for (Object receiveNode : flowModelNodes.getReceiveNodes()) {
            this.createReceiveTask(bpmnInfo, (FlowModelNodeVo)receiveNode, receiveNodeConfigMap.get(receiveNode.getNodeKey()));
            bpmnInfo.nodeMap.put(receiveNode.getNodeKey(), (FlowModelNodeVo)receiveNode);
        }
        Map<String, ManualNodeConfigDto> manualNodeConfigMap = nodeConfigs.getManualNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, dto -> dto));
        for (Object manualNode : flowModelNodes.getManualNodes()) {
            this.createManualTask(bpmnInfo, (FlowModelNodeVo)manualNode, manualNodeConfigMap.get(manualNode.getNodeKey()));
            bpmnInfo.nodeMap.put(manualNode.getNodeKey(), (FlowModelNodeVo)manualNode);
        }
        Map<String, GatewayNodeConfigDto> gatewayNodeConfigMap = nodeConfigs.getGatewayNodes().stream().collect(Collectors.toMap(BaseNodeConfigDto::getNodeKey, dto -> dto));
        for (FlowModelNodeVo gatewayNode : flowModelNodes.getGatewayNodes()) {
            this.createGatewayTask(bpmnInfo, gatewayNode, gatewayNodeConfigMap.get(gatewayNode.getNodeKey()));
            bpmnInfo.nodeMap.put(gatewayNode.getNodeKey(), gatewayNode);
        }
        for (FlowModelNodeVo endNode : flowModelNodes.getEndNodes()) {
            this.createEndEvent(bpmnInfo, endNode);
        }
        this.handleLines(bpmnInfo, gatewayNodeConfigMap);
        try {
            TransformerFactory factory = TransformerFactory.newDefaultInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("version", "1.0");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(bpmnInfo.document), new StreamResult(writer));
            return writer.toString();
        }
        catch (TransformerException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.PROJECT_DEFINITION_GENERATE_ERROR);
        }
    }

    private void handleLines(BpmnInfo bpmnInfo, Map<String, GatewayNodeConfigDto> gatewayNodeConfigMap) {
        for (FlowModelNodeVo node : bpmnInfo.nodeMap.values()) {
            List targetLines = node.getTargetLines();
            if (targetLines == null || targetLines.isEmpty()) continue;
            GatewayNodeConfigDto gatewayNodeConfigDto = gatewayNodeConfigMap.get(node.getNodeKey());
            boolean needFormula = this.checkOutLineNeedFormula(node, gatewayNodeConfigDto);
            Map<String, GatewayLineConfigDto> lineConfigMap = this.buildLineConfigMap(gatewayNodeConfigDto);
            List<FlowModelLineVo> sortedLines = this.sortTargetLines(targetLines, lineConfigMap);
            for (FlowModelLineVo targetLine : sortedLines) {
                FlowModelNodeVo targetNode = bpmnInfo.nodeMap.get(targetLine.getLineTargetKey());
                GatewayLineConfigDto lineConfig = lineConfigMap.get(targetLine.getLineTargetKey());
                this.handleLine(bpmnInfo, node, targetLine, lineConfig, needFormula, targetNode);
            }
        }
    }

    private Map<String, GatewayLineConfigDto> buildLineConfigMap(GatewayNodeConfigDto gatewayNodeConfigDto) {
        Map<String, GatewayLineConfigDto> lineConfigMap = gatewayNodeConfigDto == null || gatewayNodeConfigDto.getLineConfigs() == null ? Collections.emptyMap() : gatewayNodeConfigDto.getLineConfigs().stream().collect(Collectors.toMap(GatewayLineConfigDto::getTargetNodeKey, dto -> dto));
        return lineConfigMap;
    }

    private List<FlowModelLineVo> sortTargetLines(List<FlowModelLineVo> targetLines, Map<String, GatewayLineConfigDto> lineConfigMap) {
        if (lineConfigMap.isEmpty()) {
            return targetLines;
        }
        ArrayList<Pair> lines = new ArrayList<Pair>();
        for (FlowModelLineVo targetLine : targetLines) {
            GatewayLineConfigDto lineConfig = lineConfigMap.get(targetLine.getLineTargetKey());
            int sortNo = lineConfig == null ? Integer.MAX_VALUE : (Integer)ObjectUtils.defaultIfNull((Object)lineConfig.getSortNo(), (Object)Integer.MAX_VALUE);
            lines.add(Pair.of((Object)targetLine, (Object)sortNo));
        }
        return lines.stream().sorted(Comparator.comparing(Pair::getRight)).map(Pair::getLeft).collect(Collectors.toList());
    }

    private void handleLine(BpmnInfo bpmnInfo, FlowModelNodeVo node, FlowModelLineVo targetLine, GatewayLineConfigDto lineConfig, boolean needFormula, FlowModelNodeVo targetNode) {
        if (lineConfig != null) {
            if (needFormula && !Boolean.TRUE.equals(lineConfig.getDefaultLine()) && StringUtils.isBlank((CharSequence)lineConfig.getFormula())) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.EXCLUSIVE_GATEWAY_NO_FORMULA, new Object[]{node.getNodeName() + "(" + node.getNodeKey() + ")"});
            }
            this.createSequenceFlow(bpmnInfo, targetLine, node, targetNode, lineConfig);
            return;
        }
        if (needFormula) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.EXCLUSIVE_GATEWAY_NO_FORMULA, new Object[]{node.getNodeName() + "(" + node.getNodeKey() + ")"});
        }
        this.createSequenceFlow(bpmnInfo, targetLine, node, targetNode, null);
    }

    private boolean checkOutLineNeedFormula(FlowModelNodeVo node, GatewayNodeConfigDto gatewayNodeConfigDto) {
        boolean needFormula;
        if (FlowModelNodeType.EXCLUSIVE_GATEWAY.equals((Object)node.getNodeType())) {
            boolean bl = needFormula = node.getTargetLines().size() > 1;
            if (!needFormula && gatewayNodeConfigDto != null && gatewayNodeConfigDto.getLineConfigs() != null && gatewayNodeConfigDto.getLineConfigs().stream().anyMatch(c -> StringUtils.isNotBlank((CharSequence)c.getFormula()))) {
                throw new BaseI18nException((ErrorCode)FlowErrorCode.EXCLUSIVE_GATEWAY_SINGLE_OUT_FORMULA, new Object[]{node.getNodeName() + "(" + node.getNodeKey() + ")"});
            }
        } else {
            needFormula = false;
        }
        return needFormula;
    }

    protected Document initDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.PROJECT_DEFINITION_GENERATE_ERROR);
        }
    }

    protected Element createDefinitions(Document document) {
        Element definitions = document.createElement(this.bpmnElementPrefix + "definitions");
        this.initDefinitions(definitions);
        document.appendChild(definitions);
        return definitions;
    }

    protected void initDefinitions(Element definitions) {
        definitions.setAttribute("xmlns", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        definitions.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        definitions.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        definitions.setAttribute("xmlns:bpmndi", "http://www.omg.org/spec/BPMN/20100524/DI");
        definitions.setAttribute("xmlns:omgdc", "http://www.omg.org/spec/DD/20100524/DC");
        definitions.setAttribute("xmlns:omgdi", "http://www.omg.org/spec/DD/20100524/DI");
    }

    protected Element createProcess(Document document, Element definitions, FlowProject flowProject) {
        Element process = document.createElement(this.bpmnElementPrefix + "process");
        this.initProcess(process, flowProject);
        definitions.appendChild(process);
        return process;
    }

    protected void initProcess(Element process, FlowProject flowProject) {
        process.setAttribute("id", flowProject.getCodeName());
        process.setAttribute("name", flowProject.getName());
        process.setAttribute("isExecutable", "true");
    }

    protected Element createDiagram(Document document, Element definitions, FlowProject flowProject) {
        Element diagram = document.createElement(this.bpmndiElementPrefix + "BPMNDiagram");
        this.initDiagram(diagram, flowProject);
        definitions.appendChild(diagram);
        return diagram;
    }

    protected void initDiagram(Element diagram, FlowProject flowProject) {
        diagram.setAttribute("id", "BPMNDiagram_" + flowProject.getCodeName());
    }

    protected Element createPlane(Document document, Element diagram, FlowProject flowProject) {
        Element plane = document.createElement(this.bpmndiElementPrefix + "BPMNPlane");
        this.initPlane(plane, flowProject);
        diagram.appendChild(plane);
        return plane;
    }

    protected void initPlane(Element plane, FlowProject flowProject) {
        plane.setAttribute("id", "BPMNPlane_" + flowProject.getCodeName());
        plane.setAttribute(TAG_BPMN_ELEMENT, flowProject.getCodeName());
    }

    protected void appendPlaneShape(BpmnInfo bpmnInfo, FlowModelNodeVo node) {
        Element shape = bpmnInfo.document.createElement(this.bpmndiElementPrefix + "BPMNShape");
        this.initShape(shape, node);
        this.createShapeBounds(bpmnInfo, shape, node);
        bpmnInfo.plane.appendChild(shape);
    }

    protected void initShape(Element shape, FlowModelNodeVo node) {
        shape.setAttribute("id", "BPMNShape_" + node.getNodeKey());
        shape.setAttribute(TAG_BPMN_ELEMENT, node.getNodeKey());
    }

    protected void createShapeBounds(BpmnInfo bpmnInfo, Element shape, FlowModelNodeVo node) {
        Element bounds = bpmnInfo.document.createElement(this.dcElementPrefix + "Bounds");
        this.initBounds(bounds, node);
        shape.appendChild(bounds);
    }

    protected void initBounds(Element bounds, FlowModelNodeVo node) {
        bounds.setAttribute("height", node.getHeight().toString());
        bounds.setAttribute("width", node.getWidth().toString());
        bounds.setAttribute("x", node.getPositionX().toString());
        bounds.setAttribute("y", node.getPositionY().toString());
    }

    protected void createStartEvent(BpmnInfo bpmnInfo, FlowModelNodeVo node) {
        Element startEvent = bpmnInfo.document.createElement(this.bpmnElementPrefix + "startEvent");
        this.initStartEvent(startEvent, node, bpmnInfo);
        bpmnInfo.process.appendChild(startEvent);
        this.appendPlaneShape(bpmnInfo, node);
    }

    protected void initStartEvent(Element startEvent, FlowModelNodeVo node, BpmnInfo bpmnInfo) {
        startEvent.setAttribute("id", node.getNodeKey());
        if (StringUtils.isNotBlank((CharSequence)node.getNodeName())) {
            startEvent.setAttribute("name", node.getNodeName());
        }
    }

    protected void createUserTask(BpmnInfo bpmnInfo, FlowModelNodeVo node, ApprovalNodeConfigDto approvalNodeConfig) {
        Element userTask = bpmnInfo.document.createElement(this.bpmnElementPrefix + "userTask");
        this.initUserTask(userTask, node, approvalNodeConfig, bpmnInfo);
        bpmnInfo.process.appendChild(userTask);
        this.appendPlaneShape(bpmnInfo, node);
    }

    protected void initUserTask(Element userTask, FlowModelNodeVo node, ApprovalNodeConfigDto approvalNodeConfig, BpmnInfo bpmnInfo) {
        userTask.setAttribute("id", node.getNodeKey());
        userTask.setAttribute("name", node.getNodeName());
    }

    protected void createServiceTask(BpmnInfo bpmnInfo, FlowModelNodeVo node, ServiceNodeConfigDto serviceNodeConfig) {
        Element serviceTask = bpmnInfo.document.createElement(this.bpmnElementPrefix + "serviceTask");
        this.initServiceTask(serviceTask, node, serviceNodeConfig, bpmnInfo);
        bpmnInfo.process.appendChild(serviceTask);
        this.appendPlaneShape(bpmnInfo, node);
    }

    protected void initServiceTask(Element serviceTask, FlowModelNodeVo node, ServiceNodeConfigDto serviceNodeConfig, BpmnInfo bpmnInfo) {
        serviceTask.setAttribute("id", node.getNodeKey());
        serviceTask.setAttribute("name", node.getNodeName());
    }

    protected void createScriptTask(BpmnInfo bpmnInfo, FlowModelNodeVo node, ScriptNodeConfigDto scriptNodeConfig) {
        Element scriptTask = bpmnInfo.document.createElement(this.bpmnElementPrefix + "scriptTask");
        this.initScriptTask(scriptTask, node, scriptNodeConfig, bpmnInfo);
        bpmnInfo.process.appendChild(scriptTask);
        this.appendPlaneShape(bpmnInfo, node);
    }

    protected void initScriptTask(Element scriptTask, FlowModelNodeVo node, ScriptNodeConfigDto scriptNodeConfig, BpmnInfo bpmnInfo) {
        scriptTask.setAttribute("id", node.getNodeKey());
        scriptTask.setAttribute("name", node.getNodeName());
    }

    protected void createReceiveTask(BpmnInfo bpmnInfo, FlowModelNodeVo node, ReceiveNodeConfigDto receiveNodeConfig) {
        Element receiveTask = bpmnInfo.document.createElement(this.bpmnElementPrefix + "receiveTask");
        this.initReceiveTask(receiveTask, node, receiveNodeConfig, bpmnInfo);
        bpmnInfo.process.appendChild(receiveTask);
        this.appendPlaneShape(bpmnInfo, node);
    }

    protected void initReceiveTask(Element receiveTask, FlowModelNodeVo node, ReceiveNodeConfigDto receiveNodeConfig, BpmnInfo bpmnInfo) {
        receiveTask.setAttribute("id", node.getNodeKey());
        receiveTask.setAttribute("name", node.getNodeName());
    }

    protected void createManualTask(BpmnInfo bpmnInfo, FlowModelNodeVo node, ManualNodeConfigDto manualNodeConfigDto) {
        Element manualTask = bpmnInfo.document.createElement(this.bpmnElementPrefix + "manualTask");
        this.initManualTask(manualTask, node, manualNodeConfigDto, bpmnInfo);
        bpmnInfo.process.appendChild(manualTask);
        this.appendPlaneShape(bpmnInfo, node);
    }

    protected void initManualTask(Element manualTask, FlowModelNodeVo node, ManualNodeConfigDto manualNodeConfigDto, BpmnInfo bpmnInfo) {
        manualTask.setAttribute("id", node.getNodeKey());
        manualTask.setAttribute("name", node.getNodeName());
    }

    protected void createGatewayTask(BpmnInfo bpmnInfo, FlowModelNodeVo node, GatewayNodeConfigDto gatewayNodeConfigDto) {
        String tagName = FlowModelNodeType.EXCLUSIVE_GATEWAY.equals((Object)node.getNodeType()) ? "exclusiveGateway" : "parallelGateway";
        Element gatewayTask = bpmnInfo.document.createElement(this.bpmnElementPrefix + tagName);
        this.initGatewayTask(gatewayTask, node, gatewayNodeConfigDto, bpmnInfo);
        bpmnInfo.process.appendChild(gatewayTask);
        this.appendPlaneShape(bpmnInfo, node);
    }

    protected void initGatewayTask(Element gatewayTask, FlowModelNodeVo node, GatewayNodeConfigDto gatewayNodeConfigDto, BpmnInfo bpmnInfo) {
        gatewayTask.setAttribute("id", node.getNodeKey());
        gatewayTask.setAttribute("name", node.getNodeName());
        if (gatewayNodeConfigDto == null || node.getTargetLines() == null || node.getTargetLines().isEmpty()) {
            return;
        }
        List defaultLines = gatewayNodeConfigDto.getLineConfigs().stream().filter(lineConfig -> Boolean.TRUE.equals(lineConfig.getDefaultLine())).collect(Collectors.toList());
        if (defaultLines.size() > 1) {
            throw new BaseI18nException((ErrorCode)FlowErrorCode.GATEWAY_MULTI_DEFAULT_LINE, new Object[]{node.getNodeName() + "(" + node.getNodeKey() + ")"});
        }
        if (defaultLines.isEmpty()) {
            return;
        }
        String defaultTargetNode = ((GatewayLineConfigDto)defaultLines.get(0)).getTargetNodeKey();
        Optional<String> defaultLineKey = node.getTargetLines().stream().filter(line -> line.getLineTargetKey().equals(defaultTargetNode)).map(FlowModelLineVo::getLineKey).findAny();
        defaultLineKey.ifPresent(key -> gatewayTask.setAttribute("default", (String)key));
    }

    protected void createEndEvent(BpmnInfo bpmnInfo, FlowModelNodeVo node) {
        Element endEvent = bpmnInfo.document.createElement(this.bpmnElementPrefix + "endEvent");
        this.initEndEvent(endEvent, node, bpmnInfo);
        bpmnInfo.process.appendChild(endEvent);
        this.appendPlaneShape(bpmnInfo, node);
    }

    protected void initEndEvent(Element endEvent, FlowModelNodeVo node, BpmnInfo bpmnInfo) {
        endEvent.setAttribute("id", node.getNodeKey());
        if (StringUtils.isNotBlank((CharSequence)node.getNodeName())) {
            endEvent.setAttribute("name", node.getNodeName());
        }
    }

    protected void createSequenceFlow(BpmnInfo bpmnInfo, FlowModelLineVo line, FlowModelNodeVo sourceNode, FlowModelNodeVo targetNode, GatewayLineConfigDto gatewayLineConfigDto) {
        Element sequenceFlow = bpmnInfo.document.createElement(this.bpmnElementPrefix + "sequenceFlow");
        this.initSequenceFlow(bpmnInfo, sequenceFlow, line, sourceNode, targetNode, gatewayLineConfigDto);
        bpmnInfo.process.appendChild(sequenceFlow);
        this.appendPlaneEdge(bpmnInfo, line, sourceNode, targetNode);
    }

    protected void initSequenceFlow(BpmnInfo bpmnInfo, Element sequenceFlow, FlowModelLineVo line, FlowModelNodeVo sourceNode, FlowModelNodeVo targetNode, GatewayLineConfigDto gatewayLineConfigDto) {
        sequenceFlow.setAttribute("id", line.getLineKey());
        if (StringUtils.isNotBlank((CharSequence)line.getLineName())) {
            sequenceFlow.setAttribute("name", line.getLineName());
        }
        sequenceFlow.setAttribute("sourceRef", sourceNode.getNodeKey());
        sequenceFlow.setAttribute("targetRef", targetNode.getNodeKey());
        if (gatewayLineConfigDto != null) {
            this.appendSequenceFlowCondition(bpmnInfo, sequenceFlow, gatewayLineConfigDto);
        }
    }

    protected void appendSequenceFlowCondition(BpmnInfo bpmnInfo, Element sequenceFlow, GatewayLineConfigDto gatewayLineConfigDto) {
        if (StringUtils.isBlank((CharSequence)gatewayLineConfigDto.getFormula()) || Boolean.TRUE.equals(gatewayLineConfigDto.getDefaultLine())) {
            return;
        }
        Element conditionExpression = bpmnInfo.document.createElement(this.bpmnElementPrefix + "conditionExpression");
        conditionExpression.setAttribute("xsi:type", "tFormalExpression");
        conditionExpression.appendChild(bpmnInfo.document.createCDATASection(gatewayLineConfigDto.getFormula()));
        sequenceFlow.appendChild(conditionExpression);
    }

    protected void appendPlaneEdge(BpmnInfo bpmnInfo, FlowModelLineVo line, FlowModelNodeVo sourceNode, FlowModelNodeVo targetNode) {
        Element edge = bpmnInfo.document.createElement(this.bpmndiElementPrefix + "BPMNEdge");
        this.initEdge(edge, line, sourceNode, targetNode);
        this.createEdgeWaypoint(bpmnInfo, edge, sourceNode);
        this.createEdgeWaypoint(bpmnInfo, edge, targetNode);
        bpmnInfo.plane.appendChild(edge);
    }

    protected void initEdge(Element edge, FlowModelLineVo line, FlowModelNodeVo sourceNode, FlowModelNodeVo targetNode) {
        edge.setAttribute("id", "BPMNEdge_" + line.getLineKey());
        edge.setAttribute(TAG_BPMN_ELEMENT, line.getLineKey());
    }

    protected void createEdgeWaypoint(BpmnInfo bpmnInfo, Element edge, FlowModelNodeVo node) {
        Element waypoint = bpmnInfo.document.createElement(this.diElementPrefix + "waypoint");
        this.initWaypoint(waypoint, node);
        edge.appendChild(waypoint);
    }

    protected void initWaypoint(Element waypoint, FlowModelNodeVo node) {
        waypoint.setAttribute("x", node.getPositionX().toString());
        waypoint.setAttribute("y", node.getPositionY().toString());
    }

    protected static class BpmnInfo {
        protected Document document;
        protected Element process;
        protected Element plane;
        protected GlobalConfigDto globalConfig;
        protected Map<String, FlowModelNodeVo> nodeMap = new HashMap<String, FlowModelNodeVo>(16);

        protected BpmnInfo() {
        }
    }
}

