/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.service;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.domain.instance.entity.FlowCc;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.infra.config.FlowBaseContextProperties;
import com.cyberway.mp.flow.infra.service.FlowDataHelperService;
import com.cyberway.mp.flow.infra.service.FlowViewPermissionValidator;
import java.util.List;

public class DefaultFlowViewPermissionValidator
implements FlowViewPermissionValidator {
    private final FlowDataHelperService flowDataHelperService;
    private final FlowBaseContextProperties flowBaseContextProperties;

    public DefaultFlowViewPermissionValidator(FlowDataHelperService flowDataHelperService, FlowBaseContextProperties flowBaseContextProperties) {
        this.flowDataHelperService = flowDataHelperService;
        this.flowBaseContextProperties = flowBaseContextProperties;
    }

    @Override
    public void validateInstance(Long flowInstanceId) {
        this.validateInstance(this.flowDataHelperService.getFlowInstance(flowInstanceId));
    }

    @Override
    public void validateInstance(FlowInstance flowInstance) {
        if (!this.flowBaseContextProperties.isValidateViewPermission()) {
            return;
        }
        Long userId = ServiceContext.getContext().getRequestUserId();
        if (userId.equals(flowInstance.getStartUserId())) {
            return;
        }
        List<FlowTask> tasks = this.flowDataHelperService.listTaskByFlowInstance((Long)flowInstance.getId());
        if (tasks.stream().anyMatch(task -> userId.equals(task.getAssigneeUserId()) || userId.equals(task.getOwnerUserId()))) {
            return;
        }
        List<FlowCc> ccList = this.flowDataHelperService.listCcInInstance((Long)flowInstance.getId());
        if (ccList.stream().anyMatch(cc -> userId.equals(cc.getUserId()))) {
            return;
        }
        throw new BaseI18nException((ErrorCode)FlowErrorCode.NO_VIEW_PERMISSION);
    }
}

