/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.service;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.dal.util.IdWorker;
import com.cyberway.mp.flow.api.instance.dto.FlowInstanceCcDto;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskActionDto;
import com.cyberway.mp.flow.api.task.dto.FlowTaskCcDto;
import com.cyberway.mp.flow.api.task.enums.FlowTaskDeleteReason;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.api.task.enums.FlowTaskType;
import com.cyberway.mp.flow.api.task.vo.StarterFillTaskCustomInfoVo;
import com.cyberway.mp.flow.domain.instance.entity.FlowCc;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.node.entity.FlowNode;
import com.cyberway.mp.flow.domain.node.service.FlowNodeService;
import com.cyberway.mp.flow.domain.project.entity.FlowProject;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.project.service.FlowProjectService;
import com.cyberway.mp.flow.domain.task.entity.FlowTask;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import com.cyberway.mp.flow.domain.task.service.FlowTaskService;
import com.cyberway.mp.flow.infra.service.FlowViewPermissionValidator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;

public class FlowDataHelperService
implements ApplicationContextAware {
    private FlowProjectService flowProjectService;
    private FlowInstanceService flowInstanceService;
    private FlowNodeService flowNodeService;
    private FlowTaskService flowTaskService;
    private FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private FlowViewPermissionValidator flowViewPermissionValidator;
    private IdWorker idWorker;
    private ApplicationContext applicationContext;

    private FlowProjectService getFlowProjectService() {
        if (this.flowProjectService == null) {
            this.flowProjectService = (FlowProjectService)this.applicationContext.getBean(FlowProjectService.class);
        }
        return this.flowProjectService;
    }

    private FlowInstanceService getFlowInstanceService() {
        if (this.flowInstanceService == null) {
            this.flowInstanceService = (FlowInstanceService)this.applicationContext.getBean(FlowInstanceService.class);
        }
        return this.flowInstanceService;
    }

    private FlowNodeService getFlowNodeService() {
        if (this.flowNodeService == null) {
            this.flowNodeService = (FlowNodeService)this.applicationContext.getBean(FlowNodeService.class);
        }
        return this.flowNodeService;
    }

    private FlowTaskService getFlowTaskService() {
        if (this.flowTaskService == null) {
            this.flowTaskService = (FlowTaskService)this.applicationContext.getBean(FlowTaskService.class);
        }
        return this.flowTaskService;
    }

    private FlowProjectConfigCacheRepository getFlowProjectConfigCacheRepository() {
        if (this.flowProjectConfigCacheRepository == null) {
            this.flowProjectConfigCacheRepository = (FlowProjectConfigCacheRepository)this.applicationContext.getBean(FlowProjectConfigCacheRepository.class);
        }
        return this.flowProjectConfigCacheRepository;
    }

    private FlowViewPermissionValidator getFlowViewPermissionValidator() {
        if (this.flowViewPermissionValidator == null) {
            this.flowViewPermissionValidator = (FlowViewPermissionValidator)this.applicationContext.getBean(FlowViewPermissionValidator.class);
        }
        return this.flowViewPermissionValidator;
    }

    private IdWorker getIdWorker() {
        if (this.idWorker == null) {
            this.idWorker = (IdWorker)this.applicationContext.getBean(IdWorker.class);
        }
        return this.idWorker;
    }

    public Triple<List<FlowTask>, FlowTask, FlowInstance> starterFill(FlowTaskWithProject task, FlowTaskActionDto dto) {
        FlowInstance flowInstance = this.getFlowInstanceService().getFlowInstance(task.getFlowInstanceId());
        FlowProject flowProject = this.getFlowProjectService().getFlowProject(flowInstance.getFlowProjectId());
        task.setStatus(FlowTaskStatus.WAIT_STARTER_FILL);
        task.setOpinion(StringUtils.defaultString((String)dto.getOpinion()));
        this.getFlowTaskService().updateStatusAndRefreshActionUser(task);
        List<FlowTask> sameNodeTasks = this.getFlowTaskService().listTasksForNode(task.getFlowNodeId()).stream().filter(t -> FlowTaskStatus.RUNNING.equals((Object)t.getStatus())).collect(Collectors.toList());
        sameNodeTasks.forEach(t -> this.getFlowTaskService().updateStatus((Long)t.getId(), FlowTaskStatus.WAIT_STARTER_FILL_SAME_NODE));
        this.getFlowNodeService().updateNodeStatus(task.getFlowNodeId(), FlowTaskStatus.WAIT_STARTER_FILL);
        ApprovalNodeConfigDto approvalNodeConfig = this.getFlowProjectConfigCacheRepository().getApprovalNodeConfig(task);
        FlowTask starterTask = FlowTask.initCustomTask(task.getFlowInstanceId(), FlowTaskType.STARTER_FILL, "\u53d1\u8d77\u4eba\u8865\u5f55", flowInstance.getStartUserId(), flowInstance.getStartUserName(), flowProject);
        starterTask.setId(Long.valueOf(this.getIdWorker().nextId()));
        starterTask.setTaskId(((Long)starterTask.getId()).toString());
        if (approvalNodeConfig != null) {
            starterTask.setFormUrl((String)StringUtils.defaultIfBlank((CharSequence)approvalNodeConfig.getStartFormUrl(), (CharSequence)flowProject.getFormUrl()));
            starterTask.setFormType(Objects.requireNonNullElse(approvalNodeConfig.getStartFormType(), flowProject.getFormType()));
        }
        StarterFillTaskCustomInfoVo customInfo = new StarterFillTaskCustomInfoVo();
        customInfo.setActionNodeId(task.getFlowNodeId());
        customInfo.setActionOpinion(dto.getOpinion());
        customInfo.setActionTaskId((Long)task.getId());
        customInfo.setActionTaskName(task.getTaskName());
        customInfo.setActionNodeKey(task.getNodeKey());
        customInfo.setAssigneeCancel(Boolean.valueOf(approvalNodeConfig != null && Boolean.TRUE.equals(approvalNodeConfig.getStarterFillCancel())));
        starterTask.setCustomTaskInfo(JSON.toJSONString((Object)customInfo));
        this.getFlowTaskService().createFlowTask(starterTask);
        return Triple.of(sameNodeTasks, (Object)((Object)starterTask), (Object)((Object)flowInstance));
    }

    public List<FlowTask> completeStarterFillTask(FlowTaskWithProject task, FlowTaskActionDto dto) {
        Date endTime = new Date();
        StarterFillTaskCustomInfoVo customInfoVo = (StarterFillTaskCustomInfoVo)JSON.parseObject((String)task.getCustomTaskInfo(), StarterFillTaskCustomInfoVo.class);
        task.setStatus(FlowTaskStatus.COMPLETED);
        task.setDeleteReason(FlowTaskDeleteReason.APPROVE);
        task.setEndTime(endTime);
        task.setOpinion(dto.getOpinion());
        task.setActionUserId(ServiceContext.getContext().getRequestUserId());
        task.setActionUserName(ServiceContext.getContext().getRequestUserName());
        this.getFlowTaskService().updateFinStatus((Long)task.getId(), task.getStatus(), task.getDeleteReason(), task.getOpinion(), task.getEndTime());
        List<FlowTask> runTasks = this.getFlowTaskService().listTasksForNode(customInfoVo.getActionNodeId()).stream().filter(t -> FlowTaskStatus.WAIT_STARTER_FILL.equals((Object)t.getStatus()) || FlowTaskStatus.WAIT_STARTER_FILL_SAME_NODE.equals((Object)t.getStatus())).collect(Collectors.toList());
        runTasks.forEach(t -> {
            t.setStatus(FlowTaskStatus.RUNNING);
            t.setLastStartTime(endTime);
            this.getFlowTaskService().updateStatusAndLastStartTime((Long)t.getId(), FlowTaskStatus.RUNNING, endTime);
        });
        this.getFlowNodeService().updateNodeStatus(customInfoVo.getActionNodeId(), FlowTaskStatus.RUNNING);
        return runTasks;
    }

    public FlowInstance getFlowInstance(Long id) {
        return this.getFlowInstanceService().getFlowInstance(id);
    }

    public FlowTask getFlowTask(Long id) {
        return this.getFlowTaskService().getFlowTask(id);
    }

    public void updateTask(FlowTask task) {
        this.getFlowTaskService().modifyFlowTask(task);
    }

    public List<FlowTask> listTaskByFlowInstanceAndNodeKey(long flowInstanceId, String nodeKey) {
        return this.getFlowTaskService().listByFlowInstanceAndNodeKey(flowInstanceId, nodeKey);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String ccTask(FlowTask task, FlowTaskCcDto dto) {
        this.getFlowTaskService().ccToUsers(dto, task);
        FlowInstance flowInstance = this.getFlowInstanceService().getFlowInstance(task.getFlowInstanceId());
        return flowInstance.getProcessInstanceId();
    }

    public void ccInstance(FlowInstance flowInstance, FlowInstanceCcDto dto) {
        this.getFlowInstanceService().ccToUsers(dto, (Long)flowInstance.getId());
    }

    public List<FlowCc> listCcInInstance(Long flowInstanceId) {
        return this.getFlowInstanceService().listCcInInstance(flowInstanceId);
    }

    public void removeFlowDraftInstance(FlowProject flowProject, Long businessKey) {
        if (null != flowProject && null != businessKey) {
            List<Long> instanceIds = this.getFlowInstanceService().removeFlowDraftInstance(flowProject, businessKey);
            this.getFlowTaskService().removeFlowDraftTask(instanceIds);
        }
    }

    public List<FlowTask> listRunningStartFillTask(long flowInstanceId) {
        return this.getFlowTaskService().listRunningStartFillTask(flowInstanceId);
    }

    public List<FlowTask> listTaskByFlowInstance(long flowInstanceId) {
        return this.getFlowTaskService().listByFlowInstance(flowInstanceId);
    }

    public List<FlowNode> listNodeForRollbackPrev(Long flowInstanceId) {
        return this.getFlowNodeService().listForRollbackPrev(flowInstanceId);
    }

    public void validateViewPermission(FlowTask flowTask) {
        this.getFlowViewPermissionValidator().validateTask(flowTask);
    }

    public void validateViewPermission(FlowInstance flowInstance) {
        this.getFlowViewPermissionValidator().validateInstance(flowInstance);
    }
}

