/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.service;

import com.cyberway.mp.bbc.data.auth.api.data.enums.ConditionTargetType;
import com.cyberway.mp.bbc.data.auth.api.data.enums.RestrictType;
import com.cyberway.mp.bbc.data.auth.api.field.utils.FieldAuthHelper;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.FormFieldConfigDto;
import com.cyberway.mp.flow.api.task.vo.NodeFormFieldConfigVo;
import com.cyberway.mp.flow.api.task.vo.NodeSubFormFieldConfigVo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public interface RoleFieldAuthHelperService {
    public Map<String, String> mergeFieldAuthConfig(String var1, List<FormFieldConfigDto> var2);

    default public NodeFormFieldConfigVo convertNodeFormFieldConfigVo(String entityCode, ApprovalNodeConfigDto approvalNodeConfig) {
        NodeFormFieldConfigVo vo = new NodeFormFieldConfigVo();
        vo.setEntityCode(entityCode);
        if (approvalNodeConfig == null) {
            vo.setFieldConfigs(Collections.emptyMap());
            vo.setFieldGroupConfigs(Collections.emptyMap());
            vo.setSubFormConfigs(Collections.emptyList());
            return vo;
        }
        if (approvalNodeConfig.getFormFieldConfigs() != null) {
            List<FormFieldConfigDto> formFieldConfigs = approvalNodeConfig.getFormFieldConfigs().stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getConditionFieldCode())).collect(Collectors.toList());
            vo.setFieldConfigs(this.mergeFieldAuthConfig(entityCode, formFieldConfigs));
            vo.setFieldGroupConfigs(formFieldConfigs.stream().filter(c -> ConditionTargetType.GROUP.name().equals(c.getConditionTargetType()) && StringUtils.isNotBlank((CharSequence)c.getRestrictType())).collect(Collectors.toMap(FormFieldConfigDto::getConditionFieldCode, FormFieldConfigDto::getRestrictType)));
        } else {
            vo.setFieldConfigs(Collections.emptyMap());
            vo.setFieldGroupConfigs(Collections.emptyMap());
        }
        if (approvalNodeConfig.getSubFormFieldConfigs() != null) {
            vo.setSubFormConfigs(approvalNodeConfig.getSubFormFieldConfigs().stream().map(dto -> {
                NodeSubFormFieldConfigVo subVo = new NodeSubFormFieldConfigVo();
                subVo.setEntityCode(dto.getEntityCode());
                subVo.setAllowAdd(dto.getAllowAdd());
                subVo.setAllowEdit(dto.getAllowEdit());
                subVo.setAllowDel(dto.getAllowDel());
                subVo.setFieldConfigs(this.mergeFieldAuthConfig(dto.getEntityCode(), dto.getFormFieldConfigs()));
                if (dto.getFormFieldConfigs() == null) {
                    subVo.setFieldGroupConfigs(Collections.emptyMap());
                } else {
                    subVo.setFieldGroupConfigs(dto.getFormFieldConfigs().stream().filter(c -> ConditionTargetType.GROUP.name().equals(c.getConditionTargetType()) && StringUtils.isNotBlank((CharSequence)c.getRestrictType())).collect(Collectors.toMap(FormFieldConfigDto::getConditionFieldCode, FormFieldConfigDto::getRestrictType)));
                }
                return subVo;
            }).collect(Collectors.toList()));
        } else {
            vo.setSubFormConfigs(Collections.emptyList());
        }
        return vo;
    }

    default public Map<String, String> mergeFieldAuthConfig(List<FormFieldConfigDto> configs) {
        if (configs == null || configs.isEmpty()) {
            return Collections.emptyMap();
        }
        return configs.stream().filter(item -> ConditionTargetType.FIELD.name().equals(item.getConditionTargetType()) && StringUtils.isNotBlank((CharSequence)item.getRestrictType())).collect(Collectors.toMap(FormFieldConfigDto::getConditionFieldCode, FormFieldConfigDto::getRestrictType, (a, b) -> FieldAuthHelper.greaterThen((RestrictType)RestrictType.valueOf((String)a), (RestrictType)RestrictType.valueOf((String)b)) ? a : b));
    }
}

