/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.service;

import com.cyberway.mp.basic.data.api.calendar.CalendarApi;
import java.util.Calendar;
import java.util.Date;

public class TimeHelperService {
    private final CalendarApi calendarApi;

    public TimeHelperService(CalendarApi calendarApi) {
        this.calendarApi = calendarApi;
    }

    public Date calDueTime(Date startTime, boolean workday, int dueDay, int dueHour, int dueMinute) {
        return this.calDueTime(null, startTime, workday, dueDay, dueHour, dueMinute);
    }

    public Date calDueTime(String calendarCode, Date startTime, boolean workday, int dueDay, int dueHour, int dueMinute) {
        if (workday) {
            return this.calWorkdayTime(calendarCode, startTime, dueDay, dueHour, dueMinute);
        }
        return this.calCalendarDayDueTime(startTime, dueDay, dueHour, dueMinute);
    }

    public Date calCalendarDayDueTime(Date startTime, int dueDay, int dueHour, int dueMinute) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        if (dueDay > 0) {
            calendar.add(5, dueDay);
        }
        if (dueHour > 0) {
            calendar.add(10, dueHour);
        }
        if (dueMinute > 0) {
            calendar.add(12, dueMinute);
        }
        return calendar.getTime();
    }

    public Date calWorkdayTime(String calendarCode, Date startTime, int day, int hour, int minute) {
        return this.calendarApi.calculateEndTime(calendarCode, startTime, day, hour, minute);
    }
}

