/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.service.mp;

import cn.hutool.core.map.MapUtil;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventService;
import com.cyberway.mp.flow.api.common.dto.IdNameDto;
import com.cyberway.mp.flow.api.project.dto.ApprovalNodeConfigDto;
import com.cyberway.mp.flow.api.project.dto.GlobalConfigDto;
import com.cyberway.mp.flow.api.project.enums.AssigneeType;
import com.cyberway.mp.flow.api.task.FlowTaskApi;
import com.cyberway.mp.flow.api.task.dto.FlowTaskActionDto;
import com.cyberway.mp.flow.api.task.enums.FlowTaskApprovalTypes;
import com.cyberway.mp.flow.api.task.enums.FlowTaskStatus;
import com.cyberway.mp.flow.domain.instance.entity.FlowInstance;
import com.cyberway.mp.flow.domain.instance.service.FlowInstanceService;
import com.cyberway.mp.flow.domain.project.repository.FlowProjectConfigCacheRepository;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskApproval;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithBusinessKey;
import com.cyberway.mp.flow.domain.task.entity.FlowTaskWithProject;
import com.cyberway.mp.flow.domain.task.service.FlowTaskService;
import com.cyberway.mp.flow.infra.service.FlowEngineService;
import com.cyberway.mp.flow.infra.service.FlowExpressionExecutor;
import com.cyberway.mp.flow.infra.service.MailHelperService;
import com.cyberway.mp.flow.infra.service.UserHelperService;
import com.cyberway.mp.mc.api.push.dto.EventPushDto;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MpMailHelperServiceImpl
implements MailHelperService {
    private static final int SUBJECT_PART_LENGTH = 4;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FrameworkEventService frameworkEventService;
    private final FlowProjectConfigCacheRepository flowProjectConfigCacheRepository;
    private final FlowTaskService flowTaskService;
    private final FlowInstanceService flowInstanceService;
    private final UserHelperService userHelperService;
    private final FlowTaskApi flowTaskApi;
    private final FlowEngineService flowEngineService;

    public MpMailHelperServiceImpl(FrameworkEventService frameworkEventService, FlowProjectConfigCacheRepository flowProjectConfigCacheRepository, FlowTaskService flowTaskService, FlowInstanceService flowInstanceService, UserHelperService userHelperService, FlowTaskApi flowTaskApi, FlowEngineService flowEngineService) {
        this.frameworkEventService = frameworkEventService;
        this.flowProjectConfigCacheRepository = flowProjectConfigCacheRepository;
        this.flowTaskService = flowTaskService;
        this.flowInstanceService = flowInstanceService;
        this.userHelperService = userHelperService;
        this.flowTaskApi = flowTaskApi;
        this.flowEngineService = flowEngineService;
    }

    @Override
    public void sendApprovalMailNotice(Long flowProjectId, String flowProjectCode, Long flowTaskId) {
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowProjectId);
        if (CollectionUtils.isEmpty((Collection)globalConfig.getApprovalTypes()) || !new HashSet(globalConfig.getApprovalTypes()).contains(FlowTaskApprovalTypes.EMAIL.getType())) {
            this.logger.info("\u5ba1\u6279\u6e20\u9053\u672a\u914d\u7f6e\u90ae\u4ef6\u5ba1\u6279\uff0c\u4e0d\u8fdb\u884c\u90ae\u4ef6\u53d1\u9001\u64cd\u4f5c\u3002flowProjectId\uff1a{}\uff0cflowTaskId\uff1a{}", (Object)flowProjectId, (Object)flowTaskId);
            return;
        }
        FlowTaskWithBusinessKey task = this.flowTaskService.getFlowTaskWithBusinessKey(flowTaskId);
        if (!FlowTaskStatus.RUNNING.equals((Object)task.getStatus())) {
            this.logger.info("\u4efb\u52a1\u4e0d\u4e3a\u8fd0\u884c\u65f6\u72b6\u6001\uff0c\u4e0d\u8fdb\u884c\u90ae\u4ef6\u53d1\u9001\u64cd\u4f5c\u3002flowProjectId\uff1a{}\uff0cflowTaskId\uff1a{}", (Object)flowProjectId, (Object)flowTaskId);
            return;
        }
        FlowInstance flowInstance = this.flowInstanceService.getFlowInstance(task.getFlowInstanceId());
        ApprovalNodeConfigDto nodeConfig = this.flowProjectConfigCacheRepository.getApprovalNodeConfig(task);
        Long assigneeUserId = task.getAssigneeUserId();
        List<String> ccList = this.calCcList(nodeConfig, flowInstance);
        FlowTaskApproval flowTaskApproval = new FlowTaskApproval();
        flowTaskApproval.setApprovalCode(task.getApprovalCode());
        flowTaskApproval.setSubject(flowInstance.getInstanceName());
        flowTaskApproval.setApproveSubject("[Notification:TASK_APPROVAL_MAIL_NOTICE]Approve-" + task.getApprovalCode() + "-" + task.getId() + "-" + task.getAssigneeUserId());
        flowTaskApproval.setRejectSubject("[Notification:TASK_APPROVAL_MAIL_NOTICE]Reject-" + task.getApprovalCode() + "-" + task.getId() + "-" + task.getAssigneeUserId());
        flowTaskApproval.setReceiveUserName(task.getAssigneeUserName());
        flowTaskApproval.setFlowTaskId((Long)task.getId());
        flowTaskApproval.setFlowInstanceId(task.getFlowInstanceId());
        flowTaskApproval.setBusinessKey(task.getBusinessKey());
        HashMap paramsMap = MapUtil.newHashMap((int)2);
        paramsMap.put("flowTask", flowTaskApproval);
        paramsMap.put("flowVars", this.flowEngineService.getVariablesByTaskId(task.getTaskId()));
        EventPushDto eventPushDto = new EventPushDto();
        eventPushDto.setTenantId(task.getTenantId());
        eventPushDto.setInstanceId(task.getAppInstanceId());
        eventPushDto.setEventCode("TASK_APPROVAL_MAIL_NOTICE");
        eventPushDto.setMessageTemplateCode("APPROVAL_MAIL_NOTICE_MODEL_" + flowProjectCode);
        eventPushDto.setUserId(assigneeUserId);
        eventPushDto.setUserName(task.getAssigneeUserName());
        eventPushDto.setParamsMap((Map)paramsMap);
        eventPushDto.setMailCcList(ccList);
        this.frameworkEventService.pushEvent((FrameworkEvent)eventPushDto);
        this.logger.warn("\u5ba1\u6279\u90ae\u4ef6\u901a\u77e5\u53d1\u9001\u6210\u529f\uff01id:{}, taskId:{},flowInstanceId:{}", new Object[]{task.getId(), task.getTaskId(), task.getFlowInstanceId()});
    }

    private List<String> calCcList(ApprovalNodeConfigDto nodeConfig, FlowInstance flowInstance) {
        try {
            AssigneeType assigneeType = nodeConfig.getAuditMailCcUserType();
            if (assigneeType == null) {
                return Collections.emptyList();
            }
            if (AssigneeType.FORMULA.equals((Object)assigneeType) && StringUtils.isBlank((CharSequence)nodeConfig.getAuditMailCcFormula())) {
                return Collections.emptyList();
            }
            if (AssigneeType.FORMULA.equals((Object)assigneeType)) {
                return this.getEmailsByUserIds(this.calUserIdsByFormula(nodeConfig.getAuditMailCcFormula(), flowInstance));
            }
            if (nodeConfig.getAuditMailCcUsers() == null || nodeConfig.getAuditMailCcUsers().isEmpty()) {
                return Collections.emptyList();
            }
            List<Long> userIds = this.userHelperService.findByTypeAndIds(assigneeType, nodeConfig.getAuditMailCcUsers().stream().map(IdNameDto::getId).collect(Collectors.toList()));
            return this.getEmailsByUserIds(userIds);
        }
        catch (Exception e) {
            this.logger.error("\u8ba1\u7b97\u5ba1\u6279\u90ae\u4ef6\u6284\u9001\u4eba\u51fa\u9519: [{}]", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    private Collection<Long> calUserIdsByFormula(String auditMailCcFormula, FlowInstance flowInstance) {
        FlowExpressionExecutor expressionExecutor = this.flowEngineService.getFlowExpressionExecutor(flowInstance.getProcessInstanceId());
        try {
            Object expressionResult = expressionExecutor.execute(auditMailCcFormula);
            if (expressionResult instanceof Long) {
                return Collections.singleton((Long)expressionResult);
            }
            if (expressionResult instanceof Collection) {
                return ((Collection)expressionResult).stream().filter(this::canHandleCollectionResult).map(this::convertCollectionResult).collect(Collectors.toList());
            }
            if (expressionResult != null && StringUtils.isNumeric((CharSequence)expressionResult.toString())) {
                return Collections.singleton(Long.parseLong(expressionResult.toString()));
            }
        }
        catch (Exception e) {
            this.logger.error("Execute expression [{}] failed", (Object)auditMailCcFormula, (Object)e);
        }
        return Collections.emptyList();
    }

    private boolean canHandleCollectionResult(Object result) {
        if (result == null) {
            this.logger.warn("Result collection contains null value");
            return false;
        }
        if (result instanceof Long) {
            return true;
        }
        String resultString = result.toString();
        if (StringUtils.isNumeric((CharSequence)resultString)) {
            return true;
        }
        this.logger.warn("Result collection contains error value: [{}]", (Object)resultString);
        return false;
    }

    private Long convertCollectionResult(Object result) {
        if (result instanceof Long) {
            return (Long)result;
        }
        return Long.parseLong(result.toString());
    }

    private List<String> getEmailsByUserIds(Collection<Long> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.userHelperService.getUserEmailMap(new HashSet<Long>(userIds)).values().stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
    }

    @Override
    public void parseEmailAndApproval(String from, String subject, String body, Set<Long> handledFlowInstanceIds) {
        body = body.replace("\n", "");
        if (!subject.contains("[Notification:TASK_APPROVAL_MAIL_NOTICE]Approve-") && !subject.contains("[Notification:TASK_APPROVAL_MAIL_NOTICE]Reject-")) {
            this.logger.error("\u6536\u5230\u90ae\u4ef6\u6d88\u606f\u4e0d\u6b63\u786e\uff0c\u6807\u9898\u4e0d\u5305\u542b\u5ba1\u6279\u901a\u8fc7\u6216\u8005\u62d2\u7edd\u5173\u952e\u5b57");
            return;
        }
        String[] split = subject.split("-");
        if (split.length != 4) {
            this.logger.error("\u90ae\u4ef6\u5ba1\u6279\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8981\u6c42\u683c\u5f0f\u4e3a[Notification] Approve\u3001Reject-\u5ba1\u6279\u7801-\u4efb\u52a1ID-\u7528\u6237ID\uff0c\u5b9e\u9645\u4e3a\uff1a{}", (Object)subject);
            return;
        }
        String approvalCode = split[1];
        Long flowTaskId = Long.parseLong(split[2]);
        long userId = Long.parseLong(split[3]);
        String userName = this.userHelperService.getUserName(userId);
        FlowTaskWithProject flowTask = this.flowTaskService.getFlowTaskIgnoreTenant(flowTaskId);
        if (null == flowTask) {
            this.logger.error("\u627e\u4e0d\u5230\u5bf9\u5e94\u6d41\u7a0b\u4fe1\u606f,flowTaskId:{}", (Object)flowTaskId);
            return;
        }
        if (!approvalCode.equals(flowTask.getApprovalCode())) {
            this.logger.error("\u90ae\u4ef6\u5ba1\u6279\u5931\u8d25\uff0c\u5ba1\u6279\u7801\u4e0d\u6b63\u786e,flowTaskId:{}", (Object)flowTaskId);
            return;
        }
        GlobalConfigDto globalConfig = this.flowProjectConfigCacheRepository.getGlobalConfig(flowTask.getFlowProjectId());
        if (globalConfig != null && Boolean.TRUE.equals(globalConfig.getValidEmailSender()) && !this.validEmailSender(userId, from)) {
            this.logger.error("\u90ae\u4ef6\u5ba1\u6279\u5931\u8d25\uff0c\u53d1\u4ef6\u4eba[{}]\u4e0e\u4efb\u52a1[{}]\u7684\u529e\u7406\u4eba\u4e0d\u4e00\u81f4", (Object)from, (Object)flowTaskId);
            return;
        }
        this.doEmailApprove(subject, body, handledFlowInstanceIds, flowTask, userId, userName);
    }

    protected void doEmailApprove(String subject, String body, Set<Long> handledFlowInstanceIds, FlowTaskWithProject flowTask, long userId, String userName) {
        ServiceContext context = ServiceContext.getContext();
        context.set("req.tenantId", (Object)flowTask.getTenantId().toString());
        context.set("req.businessZoneId", (Object)flowTask.getBusinessZoneId().toString());
        context.set("req.appInstanceId", (Object)flowTask.getAppInstanceId().toString());
        context.set("req.userId", (Object)Long.toString(userId));
        context.set("req.userName", (Object)userName);
        String comment = null;
        int start = body.indexOf("Comment:");
        int end = -1;
        boolean approve = subject.startsWith("[Notification:TASK_APPROVAL_MAIL_NOTICE]Approve-");
        boolean reject = subject.startsWith("[Notification:TASK_APPROVAL_MAIL_NOTICE]Reject-");
        if (approve) {
            end = body.indexOf("Approved.");
        } else if (reject) {
            end = body.indexOf("Rejected.");
        }
        if (start > -1 && end > -1 && end > start) {
            comment = body.substring(start + "Comment:".length(), end);
        }
        try {
            if (handledFlowInstanceIds.contains(flowTask.getFlowInstanceId())) {
                Thread.sleep(1000L);
            }
            handledFlowInstanceIds.add(flowTask.getFlowInstanceId());
            if (approve) {
                this.doApprovePass(flowTask, comment);
            } else if (reject) {
                this.doApproveReject(flowTask, comment);
            }
        }
        catch (InterruptedException e) {
            this.logger.error("\u5904\u7406\u5ba1\u6279\u51fa\u73b0\u5f02\u5e38, e:{}", (Object)e.getMessage(), (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u5ba1\u6279\u51fa\u73b0\u5f02\u5e38, e:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected void doApprovePass(FlowTaskWithProject flowTask, String opinion) {
        FlowTaskActionDto dto = new FlowTaskActionDto();
        dto.setFlowTaskId((Long)flowTask.getId());
        dto.setOpinion(opinion);
        this.flowTaskApi.completeTask(dto);
    }

    protected void doApproveReject(FlowTaskWithProject flowTask, String opinion) {
        FlowTaskActionDto dto = new FlowTaskActionDto();
        dto.setFlowTaskId((Long)flowTask.getId());
        dto.setOpinion(opinion);
        this.flowTaskApi.rejectTask(dto);
    }

    private boolean validEmailSender(Long userId, String from) {
        return this.getEmailsByUserIds(Collections.singleton(userId)).contains(from);
    }
}

