/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.service.mp;

import com.cyberway.mp.bbc.data.auth.api.data.enums.ConditionTargetType;
import com.cyberway.mp.bbc.data.auth.api.data.enums.RestrictType;
import com.cyberway.mp.bbc.data.auth.api.field.utils.FieldAuthHelper;
import com.cyberway.mp.entity.common.dto.EntityDto;
import com.cyberway.mp.entity.common.dto.EntityFieldGroupDto;
import com.cyberway.mp.entity.common.service.EntityDataCacheService;
import com.cyberway.mp.flow.api.project.dto.FormFieldConfigDto;
import com.cyberway.mp.flow.infra.service.RoleFieldAuthHelperService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MpRoleFieldAuthHelperServiceImpl
implements RoleFieldAuthHelperService {
    private final EntityDataCacheService entityDataCacheService;

    public MpRoleFieldAuthHelperServiceImpl(EntityDataCacheService entityDataCacheService) {
        this.entityDataCacheService = entityDataCacheService;
    }

    @Override
    public Map<String, String> mergeFieldAuthConfig(String entityCode, List<FormFieldConfigDto> configs) {
        if (configs == null || configs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        Map<String, List<String>> groupFieldMap = null;
        for (FormFieldConfigDto config : configs) {
            if (StringUtils.isBlank((CharSequence)config.getRestrictType())) continue;
            if (ConditionTargetType.GROUP.name().equals(config.getConditionTargetType())) {
                if (groupFieldMap == null) {
                    groupFieldMap = this.initGroupFieldMap(entityCode);
                }
                groupFieldMap.getOrDefault(config.getConditionFieldCode(), Collections.emptyList()).forEach(fieldCode -> this.putIfGreaterThan((Map<String, String>)result, (String)fieldCode, config.getRestrictType()));
                continue;
            }
            this.putIfGreaterThan(result, config.getConditionFieldCode(), config.getRestrictType());
        }
        return result;
    }

    private Map<String, List<String>> initGroupFieldMap(String entityCode) {
        if (StringUtils.isBlank((CharSequence)entityCode)) {
            return Collections.emptyMap();
        }
        EntityDto entityDto = this.entityDataCacheService.getFromCache(entityCode);
        if (entityDto == null || entityDto.getEntityFieldGroups() == null) {
            return Collections.emptyMap();
        }
        return entityDto.getEntityFieldGroups().stream().collect(Collectors.toMap(EntityFieldGroupDto::getCode, EntityFieldGroupDto::getFieldCodes, (a, b) -> a));
    }

    private void putIfGreaterThan(Map<String, String> existedFields, String fieldCode, String restrictType) {
        if (existedFields.containsKey(fieldCode)) {
            if (FieldAuthHelper.greaterThen((RestrictType)RestrictType.valueOf((String)restrictType), (RestrictType)RestrictType.valueOf((String)existedFields.get(fieldCode)))) {
                existedFields.put(fieldCode, restrictType);
            }
        } else {
            existedFields.put(fieldCode, restrictType);
        }
    }
}

