/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.service.mp;

import cn.hutool.core.map.MapUtil;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.flow.api.project.enums.AssigneeType;
import com.cyberway.mp.flow.infra.service.UserHelperService;
import com.cyberway.mp.flow.infra.util.CodeUtils;
import com.cyberway.mp.org.api.BasicStatus;
import com.cyberway.mp.org.api.duty.DutyApi;
import com.cyberway.mp.org.api.duty.vo.DutySimpleVo;
import com.cyberway.mp.org.api.employee.EmployeeApi;
import com.cyberway.mp.org.api.organization.OrgUnitApi;
import com.cyberway.mp.org.api.organization.vo.OrgUnitVo;
import com.cyberway.mp.user.api.businessline.BusinessLineApi;
import com.cyberway.mp.user.api.role.RoleApi;
import com.cyberway.mp.user.api.role.dto.AllRoleQueryDto;
import com.cyberway.mp.user.api.role.dto.RolePageDto;
import com.cyberway.mp.user.api.role.enums.RoleStatus;
import com.cyberway.mp.user.api.role.vo.RoleSimpleInfoVo;
import com.cyberway.mp.user.api.user.UserApi;
import com.cyberway.mp.user.api.user.enums.UserStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MpUserHelperServiceImpl
implements UserHelperService {
    private final UserApi userApi;
    private final RoleApi roleApi;
    private final OrgUnitApi orgUnitApi;
    private final DutyApi dutyApi;
    private final EmployeeApi employeeApi;
    private final BusinessLineApi businessLineApi;

    public MpUserHelperServiceImpl(UserApi userApi, RoleApi roleApi, OrgUnitApi orgUnitApi, DutyApi dutyApi, EmployeeApi employeeApi, BusinessLineApi businessLineApi) {
        this.userApi = userApi;
        this.roleApi = roleApi;
        this.orgUnitApi = orgUnitApi;
        this.dutyApi = dutyApi;
        this.employeeApi = employeeApi;
        this.businessLineApi = businessLineApi;
    }

    @Override
    public String getUserName(long id) {
        return (String)this.userApi.getNameOrLoginNameMap(Collections.singletonList(id)).get(id);
    }

    @Override
    public Map<Long, String> getUserNameMap(Set<Long> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.userApi.getNameOrLoginNameMap(userIds);
    }

    @Override
    public List<Long> findByTypeAndIds(AssigneeType assigneeType, Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        switch (assigneeType) {
            case USER: {
                return new ArrayList<Long>(ids);
            }
            case ORG_UNIT: {
                return this.orgUnitApi.listEnabledUserIdInEnabledOrgUnits(ids);
            }
            case DUTY: {
                return this.dutyApi.listEnabledUserIdInEnabledDuties(ids);
            }
            case ROLE: {
                return this.roleApi.listEnabledRoleUserId(ids);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean checkUserHasRole(Long userId, String roleCode) {
        if (CodeUtils.isEmptyId(userId) || StringUtils.isBlank((CharSequence)roleCode)) {
            return false;
        }
        AllRoleQueryDto queryDto = new AllRoleQueryDto();
        queryDto.setCodeName(roleCode);
        return !this.userApi.allRoleList(userId, queryDto).isEmpty();
    }

    @Override
    public boolean checkUserInOrgUnit(Long userId, String orgUnitCode) {
        if (CodeUtils.isEmptyId(userId) || StringUtils.isBlank((CharSequence)orgUnitCode)) {
            return false;
        }
        return this.orgUnitApi.checkUserInOrgUnit(userId.longValue(), orgUnitCode);
    }

    @Override
    public Long getLeaderUserId(Long userId) {
        if (userId == null) {
            return null;
        }
        return this.employeeApi.getLeaderUserIdByUserId(userId.longValue());
    }

    @Override
    public Long getUserMainOrgUnitId(Long userId) {
        if (userId == null) {
            return null;
        }
        return this.orgUnitApi.getUserMainOrgUnitId(userId);
    }

    @Override
    public Long getParentOrgUnitId(Long orgUnitId) {
        if (orgUnitId == null) {
            return null;
        }
        return this.orgUnitApi.getParentOrgUnitId(orgUnitId);
    }

    @Override
    public List<Long> findUserIdsByOrgUnitIdAndRoleCode(Long orgUnitId, String roleCode) {
        if (orgUnitId == null || StringUtils.isBlank((CharSequence)roleCode)) {
            return Collections.emptyList();
        }
        return this.userApi.listEnabledUserIdInOrgUnitAndHasRole(orgUnitId, roleCode);
    }

    @Override
    public List<Long> findUserIdsByOrgUnitCodeAndRoleCode(String orgUnitCode, String roleCode) {
        if (StringUtils.isBlank((CharSequence)orgUnitCode) || StringUtils.isBlank((CharSequence)roleCode)) {
            return Collections.emptyList();
        }
        return this.userApi.listEnabledUserIdByOrgUnitCodeAndHasRole(orgUnitCode, roleCode);
    }

    @Override
    public boolean checkOrgUnitIsSubUnit(Long orgUnitId, String parentOrgUnitCode) {
        if (orgUnitId == null || StringUtils.isBlank((CharSequence)parentOrgUnitCode)) {
            return false;
        }
        return this.orgUnitApi.checkOrgUnitIsSubUnit(orgUnitId, parentOrgUnitCode);
    }

    @Override
    public Map<Long, String> getUserEmailMap(Set<Long> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.userApi.getEmailMap(userIds);
    }

    @Override
    public List<Long> findUserIdsByRoleCodes(Collection<String> roleCodes) {
        if (roleCodes == null || roleCodes.isEmpty()) {
            return Collections.emptyList();
        }
        return this.userApi.listUserIdByRoleCodes(roleCodes);
    }

    @Override
    public List<Long> findUserIdsByBusinessLine(String businessCode, Long reporterId, Integer reporterIdType, Long reporterOrgUnitId) {
        if (businessCode == null || reporterId == null || reporterIdType == null) {
            return Collections.emptyList();
        }
        return this.businessLineApi.findReportedUserIdsByBusinessLine(businessCode, reporterId, reporterIdType, reporterOrgUnitId);
    }

    @Override
    public Map<Long, String> getUserLoginNameMap(Collection<Long> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.userApi.getLoginNameMap(userIds);
    }

    @Override
    public Map<Long, String> getRoleCodeMap(Collection<Long> roleIds) {
        if (roleIds == null || roleIds.isEmpty()) {
            return Collections.emptyMap();
        }
        RolePageDto rolePageDto = new RolePageDto();
        rolePageDto.setPageSize(roleIds.size());
        rolePageDto.setRoleIds(new ArrayList<Long>(roleIds));
        Page page = this.roleApi.queryRole(rolePageDto);
        if (page.getDatas() == null) {
            return Collections.emptyMap();
        }
        return page.getDatas().stream().collect(Collectors.toMap(RoleSimpleInfoVo::getId, RoleSimpleInfoVo::getCodeName));
    }

    @Override
    public Map<Long, String> getOrgUnitCodeMap(Collection<Long> orgUnitIds) {
        if (orgUnitIds == null || orgUnitIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.orgUnitApi.listVoByUnitIds(orgUnitIds).stream().collect(Collectors.toMap(OrgUnitVo::getId, OrgUnitVo::getCode));
    }

    @Override
    public Map<Long, String> getDutyCodeMap(Collection<Long> dutyIds) {
        if (dutyIds == null || dutyIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.dutyApi.listByDutyIds(dutyIds).stream().collect(Collectors.toMap(DutySimpleVo::getId, DutySimpleVo::getCode));
    }

    @Override
    public Map<String, Long> getUserLoginNameIdMap(Collection<String> loginNames) {
        if (loginNames == null || loginNames.isEmpty()) {
            return Collections.emptyMap();
        }
        List voList = this.userApi.listByLoginNames(loginNames);
        HashMap result = MapUtil.newHashMap((int)loginNames.size());
        voList.forEach(vo -> {
            if (!result.containsKey(vo.getLoginName()) || UserStatus.ENABLED.equals((Object)vo.getStatus())) {
                result.put(vo.getLoginName(), vo.getId());
            }
        });
        return result;
    }

    @Override
    public Map<String, Long> getRoleCodeIdMap(Collection<String> codes) {
        if (codes == null || codes.isEmpty()) {
            return Collections.emptyMap();
        }
        RolePageDto rolePageDto = new RolePageDto();
        rolePageDto.setCodeNames(codes);
        rolePageDto.setPageSize(9999999);
        Page page = this.roleApi.queryRole(rolePageDto);
        if (page.getDatas() == null) {
            return Collections.emptyMap();
        }
        HashMap result = MapUtil.newHashMap((int)codes.size());
        page.getDatas().forEach(role -> {
            if (!result.containsKey(role.getCodeName()) || RoleStatus.ENABLED.equals((Object)role.getStatus())) {
                result.put(role.getCodeName(), role.getId());
            }
        });
        return result;
    }

    @Override
    public Map<String, Long> getOrgUnitCodeIdMap(Collection<String> codes) {
        if (codes == null || codes.isEmpty()) {
            return Collections.emptyMap();
        }
        List voList = this.orgUnitApi.listByCodes(codes);
        HashMap result = MapUtil.newHashMap((int)codes.size());
        voList.forEach(unit -> {
            if (!result.containsKey(unit.getCode()) || BasicStatus.ENABLED.equals((Object)unit.getStatus())) {
                result.put(unit.getCode(), unit.getId());
            }
        });
        return result;
    }

    @Override
    public Map<String, Long> getDutyCodeIdMap(Collection<String> codes) {
        if (codes == null || codes.isEmpty()) {
            return Collections.emptyMap();
        }
        List voList = this.dutyApi.listByDutyCodes(codes);
        HashMap result = MapUtil.newHashMap((int)codes.size());
        voList.forEach(duty -> {
            if (!result.containsKey(duty.getCode()) || BasicStatus.ENABLED.equals((Object)duty.getStatus())) {
                result.put(duty.getCode(), duty.getId());
            }
        });
        return result;
    }
}

