/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.util;

import com.cyberway.mp.flow.api.constants.FlowConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.ObjectUtils;

public class CodeUtils {
    public static final int DEFAULT_MAP_SIZE = 16;

    private CodeUtils() {
    }

    public static boolean isEmptyId(Long id) {
        return id == null || id.equals(FlowConstant.EMPTY_ID_VALUE);
    }

    public static boolean isNotEmptyId(Long id) {
        return id != null && !id.equals(FlowConstant.EMPTY_ID_VALUE);
    }

    public static Long formatNullableId(Long id) {
        return CodeUtils.isEmptyId(id) ? null : id;
    }

    public static Long nullableIdValue(Long id) {
        return (Long)ObjectUtils.defaultIfNull((Object)id, (Object)FlowConstant.EMPTY_ID_VALUE);
    }

    public static boolean isEmptyVersionNo(Integer versionNo) {
        return versionNo == null || versionNo.equals(FlowConstant.EMPTY_VERSION_VALUE);
    }

    public static Integer formatNullableVersionNo(Integer versionNo) {
        return CodeUtils.isEmptyVersionNo(versionNo) ? null : versionNo;
    }

    public static Integer nullableIdValue(Integer versionNo) {
        return (Integer)ObjectUtils.defaultIfNull((Object)versionNo, (Object)FlowConstant.EMPTY_VERSION_VALUE);
    }

    public static Date nullableMaxTime(Date time) {
        return (Date)ObjectUtils.defaultIfNull((Object)time, (Object)FlowConstant.EMPTY_MAX_TIME);
    }

    public static Date formatNullableMaxTime(Date time) {
        return CodeUtils.isEmptyMaxTime(time) ? null : time;
    }

    public static boolean isEmptyMaxTime(Date time) {
        return time == null || time.equals(FlowConstant.EMPTY_MAX_TIME);
    }

    public static Date nullableMinTime(Date time) {
        return (Date)ObjectUtils.defaultIfNull((Object)time, (Object)FlowConstant.EMPTY_MIN_TIME);
    }

    public static Date formatNullableMinTime(Date time) {
        return CodeUtils.isEmptyMinTime(time) ? null : time;
    }

    public static boolean isEmptyMinTime(Date time) {
        return time == null || time.equals(FlowConstant.EMPTY_MIN_TIME);
    }

    public static <T> void pageDoAction(Collection<T> elements, Consumer<Collection<T>> action) {
        CodeUtils.pageDoAction(elements, 1000, action);
    }

    public static <T> void pageDoAction(Collection<T> elements, int pageSize, Consumer<Collection<T>> action) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        if (elements.size() <= pageSize) {
            action.accept(elements);
        } else {
            ArrayList<T> elementList = elements instanceof List ? (ArrayList<T>)elements : new ArrayList<T>(elements);
            for (int i = 0; i < elementList.size(); i += pageSize) {
                action.accept(elementList.subList(i, Math.min(elementList.size(), i + pageSize)));
            }
        }
    }
}

