/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.infra.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.flow.api.constants.FlowErrorCode;
import com.cyberway.mp.flow.api.project.enums.FlowVariableType;
import com.cyberway.mp.flow.api.project.enums.FormType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowUtils.class);
    private static final String NODE_ID = "id";
    private static final String NODE_SHAPE = "shape";
    private static final String NODE_CELL = "cell";
    private static final String NODE_SOURCE = "source";
    private static final String NODE_TARGET = "target";
    private static final String NODE_EDGE = "edge";
    private static final String NODE_START = "node-start";

    private FlowUtils() {
    }

    public static String formatFormUrl(FormType formType, String formUrl, Long flowInstanceId, Long businessKey) {
        return FlowUtils.formatFormUrl(formType, formUrl, flowInstanceId, businessKey, null, null);
    }

    public static String formatFormUrl(FormType formType, String formUrl, Long flowInstanceId, Long businessKey, Long flowTaskId, String flowNodeKey) {
        if (StringUtils.isBlank((CharSequence)formUrl)) {
            return "";
        }
        return formUrl.replace("{flowTaskId}", flowTaskId == null ? "" : flowTaskId.toString()).replace("{flowInstanceId}", flowInstanceId == null ? "" : flowInstanceId.toString()).replace("{businessKey}", businessKey == null ? "" : businessKey.toString()).replace("{nodeKey}", StringUtils.defaultString((String)flowNodeKey));
    }

    public static void putVariable(Map<String, Object> variables, ObjectMapper objectMapper, FlowVariableType variableType, String key, String value) {
        if (value == null) {
            variables.put(key, null);
            return;
        }
        try {
            switch (variableType) {
                case NULL: {
                    variables.put(key, null);
                    break;
                }
                case STRING: {
                    variables.put(key, value);
                    break;
                }
                case BOOLEAN: {
                    variables.put(key, Boolean.valueOf(value));
                    break;
                }
                case SHORT: {
                    variables.put(key, Short.parseShort(value));
                    break;
                }
                case INTEGER: {
                    variables.put(key, Integer.parseInt(value));
                    break;
                }
                case LONG: {
                    variables.put(key, Long.parseLong(value));
                    break;
                }
                case DOUBLE: {
                    variables.put(key, Double.valueOf(value));
                    break;
                }
                case DATE: {
                    variables.put(key, new Date(Long.parseLong(value)));
                    break;
                }
                case BIG_DECIMAL: {
                    variables.put(key, new BigDecimal(value));
                    break;
                }
                case JSON: {
                    variables.put(key, objectMapper.readTree(value));
                    break;
                }
                default: {
                    throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_VAR_NOT_EDITABLE);
                }
            }
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_INSTANCE_VAR_SET_FAILED, new Object[]{key});
        }
    }

    public static ModelDesignContentInfo extractModelDesignContent(JSONArray designJson) {
        ModelDesignContentInfo info = new ModelDesignContentInfo();
        for (int i = 0; i < designJson.size(); ++i) {
            JSONObject designObj = designJson.getJSONObject(i);
            if (NODE_EDGE.equals(designObj.getString(NODE_SHAPE))) {
                info.edgeInMap.computeIfAbsent(designObj.getJSONObject(NODE_TARGET).getString(NODE_CELL), k -> new ArrayList()).add(designObj);
                info.edgeOutMap.computeIfAbsent(designObj.getJSONObject(NODE_SOURCE).getString(NODE_CELL), k -> new ArrayList()).add(designObj);
                continue;
            }
            if (NODE_START.equals(designObj.getString(NODE_SHAPE))) {
                if (info.startNode != null) {
                    throw new BaseI18nException((ErrorCode)FlowErrorCode.FLOW_MODEL_CONTENT_MULTI_START);
                }
                info.startNode = designObj;
            }
            info.designNodeMap.put(designObj.getString(NODE_ID), designObj);
        }
        return info;
    }

    public static class ModelDesignContentInfo {
        private JSONObject startNode;
        public final Map<String, JSONObject> designNodeMap = new HashMap<String, JSONObject>(16);
        public final Map<String, List<JSONObject>> edgeInMap = new HashMap<String, List<JSONObject>>(16);
        public final Map<String, List<JSONObject>> edgeOutMap = new HashMap<String, List<JSONObject>>(16);

        public JSONObject getStartNode() {
            return this.startNode;
        }
    }
}

