/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.flow.controller;

import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.flow.api.delegation.DelegationApi;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRuleCreateDto;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRuleModifyBaseDto;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRuleModifyDto;
import com.cyberway.mp.flow.api.delegation.dto.DelegationRulePageDto;
import com.cyberway.mp.flow.api.delegation.vo.DelegationRuleInfoVo;
import com.cyberway.mp.flow.api.delegation.vo.DelegationRuleListVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/delegation"})
@Tag(name="delegation")
public class DelegationController {
    private final DelegationApi delegationApi;

    public DelegationController(DelegationApi delegationApi) {
        this.delegationApi = delegationApi;
    }

    @Operation(summary="\u521b\u5efa\u4ee3\u7406\u89c4\u5219")
    @PostMapping(value={"rule"})
    public ResponseResult<Long> createDelegationRule(@RequestBody DelegationRuleCreateDto dto) {
        return ResponseResult.successResult((Object)this.delegationApi.createDelegationRule(dto));
    }

    @Operation(summary="\u4fee\u6539\u4ee3\u7406\u89c4\u5219")
    @PutMapping(value={"rule/{id}"})
    public ResponseResult<Void> modifyDelegationRule(@Parameter(description="ID") @PathVariable(value="id") long id, @RequestBody DelegationRuleModifyBaseDto dto) {
        this.delegationApi.modifyDelegationRule(DelegationRuleModifyDto.fromDelegationRuleModifyBaseDto((long)id, (DelegationRuleModifyBaseDto)dto));
        return ResponseResult.successResult();
    }

    @Operation(summary="\u5220\u9664\u4ee3\u7406\u89c4\u5219")
    @DeleteMapping(value={"rule/{id}"})
    public ResponseResult<Void> deleteDelegationRule(@Parameter(description="ID") @PathVariable(value="id") long id) {
        this.delegationApi.deleteDelegationRule(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u67e5\u8be2\u4ee3\u7406\u89c4\u5219")
    @PostMapping(value={"rule/query"})
    public ResponseResult<Page<DelegationRuleListVo>> queryDelegationRule(@RequestBody DelegationRulePageDto dto) {
        return ResponseResult.successResult((Object)this.delegationApi.queryDelegationRule(dto));
    }

    @Operation(summary="\u83b7\u53d6\u4ee3\u7406\u89c4\u5219")
    @GetMapping(value={"rule/{id}"})
    public ResponseResult<DelegationRuleInfoVo> getDelegationRule(@Parameter(description="ID") @PathVariable(value="id") long id) {
        return ResponseResult.successResult((Object)this.delegationApi.getDelegationRule(id));
    }

    @Operation(summary="\u542f\u7528\u4ee3\u7406\u89c4\u5219")
    @PostMapping(value={"rule/{id}/enable"})
    public ResponseResult<Void> enableDelegationRule(@Parameter(description="ID") @PathVariable(value="id") long id) {
        this.delegationApi.enableDelegationRule(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u7981\u7528\u4ee3\u7406\u89c4\u5219")
    @PostMapping(value={"rule/{id}/disable"})
    public ResponseResult<Void> disableDelegationRule(@Parameter(description="ID") @PathVariable(value="id") long id) {
        this.delegationApi.disableDelegationRule(id);
        return ResponseResult.successResult();
    }
}

